/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.config;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.core.crypto.internal.AliasPrivateKey;
import net.corda.core.internal.PathUtilsKt;
import net.corda.nodeapi.internal.config.CertificateStore;
import net.corda.nodeapi.internal.config.DelegatingCertificateStore;
import net.corda.nodeapi.internal.crypto.KeyStoreUtilities;
import net.corda.nodeapi.internal.crypto.X509KeyStore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 02\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u00010J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0016J@\u0010\u0014\u001a\u00020\u001226\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00120\u0016H\u0016J\u0011\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002J\u001b\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u001cH\u0096\u0002J,\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u001e0\u001f\u00a2\u0006\u0002\b H\u0016\u00a2\u0006\u0002\u0010!J\u0019\u0010\"\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0004H\u0096\u0002J\u001e\u0010#\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0016J!\u0010&\u001a\u00020\u00122\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u001f\u00a2\u0006\u0002\b H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0016J)\u0010'\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.H\u0016\u00a2\u0006\u0002\u0010/R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00061"}, d2={"Lnet/corda/nodeapi/internal/config/CertificateStore;", "", "Lkotlin/Pair;", "", "Ljava/security/cert/X509Certificate;", "entryPassword", "getEntryPassword", "()Ljava/lang/String;", "password", "getPassword", "value", "Lnet/corda/nodeapi/internal/crypto/X509KeyStore;", "getValue", "()Lnet/corda/nodeapi/internal/crypto/X509KeyStore;", "contains", "", "alias", "copyTo", "", "certificateStore", "forEach", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "certificate", "get", "iterator", "", "query", "RESULT", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "set", "setCertPathOnly", "certificates", "", "update", "writeTo", "stream", "Ljava/io/OutputStream;", "path", "Ljava/nio/file/Path;", "options", "", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "Companion", "node-api"})
public interface CertificateStore
extends Iterable<Pair<? extends String, ? extends X509Certificate>>,
KMappedMarker {
    public static final Companion Companion = net.corda.nodeapi.internal.config.CertificateStore$Companion.$$INSTANCE;

    @NotNull
    public X509KeyStore getValue();

    @NotNull
    public String getPassword();

    @NotNull
    public String getEntryPassword();

    public void writeTo(@NotNull OutputStream var1);

    @NotNull
    public OutputStream writeTo(@NotNull Path var1, OpenOption ... var2);

    public void update(@NotNull Function1<? super X509KeyStore, Unit> var1);

    public <RESULT> RESULT query(@NotNull Function1<? super X509KeyStore, ? extends RESULT> var1);

    public void set(@NotNull String var1, @NotNull X509Certificate var2);

    @Override
    @NotNull
    public Iterator<Pair<String, X509Certificate>> iterator();

    public void forEach(@NotNull Function2<? super String, ? super X509Certificate, Unit> var1);

    @NotNull
    public X509Certificate get(@NotNull String var1);

    public boolean contains(@NotNull String var1);

    public void copyTo(@NotNull CertificateStore var1);

    public void setCertPathOnly(@NotNull String var1, @NotNull List<? extends X509Certificate> var2);

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        public static void writeTo(CertificateStore $this, @NotNull OutputStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            String string = $this.getPassword();
            OutputStream outputStream = stream;
            KeyStore keyStore = $this.getValue().getInternal();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray2 = cArray;
            keyStore.store(outputStream, cArray2);
        }

        @NotNull
        public static OutputStream writeTo(CertificateStore $this, @NotNull Path path, OpenOption ... options) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return PathUtilsKt.outputStream((Path)path, (OpenOption[])Arrays.copyOf(options, options.length));
        }

        public static void update(CertificateStore $this, @NotNull Function1<? super X509KeyStore, Unit> action) {
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            Unit result = (Unit)action.invoke((Object)$this.getValue());
            $this.getValue().save();
        }

        public static <RESULT> RESULT query(CertificateStore $this, @NotNull Function1<? super X509KeyStore, ? extends RESULT> action) {
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            return (RESULT)action.invoke((Object)$this.getValue());
        }

        public static void set(CertificateStore $this, @NotNull String alias, @NotNull X509Certificate certificate) {
            Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            $this.update((Function1<? super X509KeyStore, Unit>)((Function1)new Function1<X509KeyStore, Unit>(certificate){
                final /* synthetic */ X509Certificate $certificate;

                public final void invoke(@NotNull X509KeyStore $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    KeyStoreUtilities.addOrReplaceCertificate($receiver.getInternal(), "cordarootca", this.$certificate);
                }
                {
                    this.$certificate = x509Certificate;
                    super(1);
                }
            }));
        }

        @NotNull
        public static Iterator<Pair<String, X509Certificate>> iterator(CertificateStore $this) {
            return SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)((Iterator)$this.query(iterator.1.INSTANCE))), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends X509Certificate>>($this){
                final /* synthetic */ CertificateStore this$0;

                @NotNull
                public final Pair<String, X509Certificate> invoke(@NotNull String alias) {
                    Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
                    return TuplesKt.to((Object)alias, (Object)this.this$0.get(alias));
                }
                {
                    this.this$0 = certificateStore;
                    super(1);
                }
            })).iterator();
        }

        public static void forEach(CertificateStore $this, @NotNull Function2<? super String, ? super X509Certificate, Unit> action) {
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            Iterable $receiver$iv = $this;
            for (Object element$iv : $receiver$iv) {
                Pair $alias_certificate = (Pair)element$iv;
                String alias = (String)$alias_certificate.component1();
                X509Certificate certificate = (X509Certificate)$alias_certificate.component2();
                action.invoke((Object)alias, (Object)certificate);
            }
        }

        @NotNull
        public static X509Certificate get(CertificateStore $this, @NotNull String alias) {
            Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
            return (X509Certificate)$this.query((Function1)new Function1<X509KeyStore, X509Certificate>(alias){
                final /* synthetic */ String $alias;

                @NotNull
                public final X509Certificate invoke(@NotNull X509KeyStore $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return $receiver.getCertificate(this.$alias);
                }
                {
                    this.$alias = string;
                    super(1);
                }
            });
        }

        public static boolean contains(CertificateStore $this, @NotNull String alias) {
            Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
            return $this.getValue().contains(alias);
        }

        public static void copyTo(CertificateStore $this, @NotNull CertificateStore certificateStore) {
            Intrinsics.checkParameterIsNotNull((Object)certificateStore, (String)"certificateStore");
            certificateStore.update((Function1<? super X509KeyStore, Unit>)((Function1)new Function1<X509KeyStore, Unit>($this){
                final /* synthetic */ CertificateStore this$0;

                public final void invoke(@NotNull X509KeyStore $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    this.this$0.forEach((Function2<? super String, ? super X509Certificate, Unit>)((Function2)new Function2<String, X509Certificate, Unit>($receiver){

                        public final void invoke(@NotNull String p1, @NotNull X509Certificate p2) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                            ((X509KeyStore)this.receiver).setCertificate(p1, p2);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(X509KeyStore.class);
                        }

                        public final String getName() {
                            return "setCertificate";
                        }

                        public final String getSignature() {
                            return "setCertificate(Ljava/lang/String;Ljava/security/cert/X509Certificate;)V";
                        }
                    }));
                }
                {
                    this.this$0 = certificateStore;
                    super(1);
                }
            }));
        }

        public static void setCertPathOnly(CertificateStore $this, @NotNull String alias, @NotNull List<? extends X509Certificate> certificates) {
            Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
            Intrinsics.checkParameterIsNotNull(certificates, (String)"certificates");
            PrivateKey privateKey = $this.contains(alias) ? $this.getValue().getPrivateKey(alias, $this.getEntryPassword()) : (PrivateKey)new AliasPrivateKey(alias);
            $this.getValue().setPrivateKey(alias, privateKey, certificates, $this.getEntryPassword());
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"Lnet/corda/nodeapi/internal/config/CertificateStore$Companion;", "", "()V", "fromFile", "Lnet/corda/nodeapi/internal/config/CertificateStore;", "storePath", "Ljava/nio/file/Path;", "password", "", "entryPassword", "createNew", "", "fromInputStream", "stream", "Ljava/io/InputStream;", "fromResource", "storeResourceName", "classLoader", "Ljava/lang/ClassLoader;", "of", "store", "Lnet/corda/nodeapi/internal/crypto/X509KeyStore;", "node-api"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final CertificateStore of(@NotNull X509KeyStore store, @NotNull String password, @NotNull String entryPassword) {
            Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            Intrinsics.checkParameterIsNotNull((Object)entryPassword, (String)"entryPassword");
            return new DelegatingCertificateStore(store, password, entryPassword);
        }

        @NotNull
        public final CertificateStore fromFile(@NotNull Path storePath, @NotNull String password, @NotNull String entryPassword, boolean createNew) {
            Intrinsics.checkParameterIsNotNull((Object)storePath, (String)"storePath");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            Intrinsics.checkParameterIsNotNull((Object)entryPassword, (String)"entryPassword");
            return new DelegatingCertificateStore(X509KeyStore.Companion.fromFile(storePath, password, createNew), password, entryPassword);
        }

        @NotNull
        public final CertificateStore fromInputStream(@NotNull InputStream stream, @NotNull String password, @NotNull String entryPassword) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            Intrinsics.checkParameterIsNotNull((Object)entryPassword, (String)"entryPassword");
            return new DelegatingCertificateStore(X509KeyStore.Companion.fromInputStream(stream, password), password, entryPassword);
        }

        @NotNull
        public final CertificateStore fromResource(@NotNull String storeResourceName, @NotNull String password, @NotNull String entryPassword, @NotNull ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)storeResourceName, (String)"storeResourceName");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            Intrinsics.checkParameterIsNotNull((Object)entryPassword, (String)"entryPassword");
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            InputStream inputStream = classLoader.getResourceAsStream(storeResourceName);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"classLoader.getResourceAsStream(storeResourceName)");
            return this.fromInputStream(inputStream, password, entryPassword);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CertificateStore fromResource$default(Companion companion, String string, String string2, String string3, ClassLoader classLoader, int n, Object object) {
            if ((n & 8) != 0) {
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                ClassLoader classLoader2 = thread.getContextClassLoader();
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"Thread.currentThread().contextClassLoader");
                classLoader = classLoader2;
            }
            return companion.fromResource(string, string2, string3, classLoader);
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

