/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.crypto;

import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.CertRole;
import net.corda.core.internal.InternalUtils;
import net.corda.nodeapi.internal.crypto.CertificateType;
import net.corda.nodeapi.internal.crypto.X509CertificateFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0006\u001a\n\u0010\u0016\u001a\u00020\u0006*\u00020\u0015\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\n*\b\u0012\u0004\u0012\u00020\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\f\"\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"certificateType", "Lnet/corda/nodeapi/internal/crypto/CertificateType;", "Lnet/corda/core/internal/CertRole;", "getCertificateType", "(Lnet/corda/core/internal/CertRole;)Lnet/corda/nodeapi/internal/crypto/CertificateType;", "x509", "Ljava/security/cert/X509Certificate;", "Ljava/security/cert/Certificate;", "getX509", "(Ljava/security/cert/Certificate;)Ljava/security/cert/X509Certificate;", "", "", "([Ljava/security/cert/Certificate;)Ljava/util/List;", "x509Certificates", "Ljava/security/cert/CertPath;", "getX509Certificates", "(Ljava/security/cert/CertPath;)Ljava/util/List;", "isSignatureValid", "", "Lorg/bouncycastle/pkcs/PKCS10CertificationRequest;", "toBc", "Lorg/bouncycastle/cert/X509CertificateHolder;", "toJca", "node-api"})
public final class X509UtilitiesKt {
    @NotNull
    public static final CertificateType getCertificateType(@NotNull CertRole $receiver) {
        CertificateType element$iv2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            for (CertificateType element$iv2 : CertificateType.values()) {
                CertificateType it = element$iv2;
                if (!(it.getRole() == $receiver)) {
                    continue;
                }
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        return element$iv2;
    }

    @NotNull
    public static final X509CertificateHolder toBc(@NotNull X509Certificate $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new X509CertificateHolder($receiver.getEncoded());
    }

    @NotNull
    public static final X509Certificate toJca(@NotNull X509CertificateHolder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        X509CertificateFactory x509CertificateFactory = new X509CertificateFactory();
        byte[] byArray = $receiver.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"encoded");
        byte[] byArray2 = byArray;
        X509CertificateFactory x509CertificateFactory2 = x509CertificateFactory;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        return x509CertificateFactory2.generateCertificate(byteArrayInputStream);
    }

    @NotNull
    public static final List<X509Certificate> getX509Certificates(@NotNull CertPath $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = Intrinsics.areEqual((Object)$receiver.getType(), (Object)"X.509");
        if (!bl) {
            String string = "Not an X.509 cert path: " + $receiver;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (List)InternalUtils.uncheckedCast($receiver.getCertificates());
    }

    @NotNull
    public static final X509Certificate getX509(@NotNull Certificate $receiver) {
        X509Certificate x509Certificate;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Certificate certificate = $receiver;
        if (!(certificate instanceof X509Certificate)) {
            certificate = null;
        }
        if ((x509Certificate = (X509Certificate)certificate) == null) {
            String string = "Not an X.509 certificate: " + $receiver;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return x509Certificate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<X509Certificate> getX509(@NotNull Certificate[] $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Certificate[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Certificate[] certificateArray = $receiver$iv = $receiver;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int n = ((void)$receiver$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var7_7 = item$iv$iv = $receiver$iv$iv[j];
            Collection collection = destination$iv$iv;
            X509Certificate x509Certificate = X509UtilitiesKt.getX509((Certificate)it);
            collection.add(x509Certificate);
        }
        return (List)var3_3;
    }

    public static final boolean isSignatureValid(@NotNull PKCS10CertificationRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.isSignatureValid(new JcaContentVerifierProviderBuilder().build($receiver.getSubjectPublicKeyInfo()));
    }
}

