/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.PathUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ4\u0010\f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH$J \u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0004j\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lnet/corda/nodeapi/internal/network/CopyCordapps;", "", "(Ljava/lang/String;I)V", "copy", "", "cordappJars", "", "Ljava/nio/file/Path;", "nodeDirs", "networkAlreadyExists", "", "fromCordform", "copyTo", "FirstRunOnly", "Yes", "No", "node-api"})
public abstract class CopyCordapps
extends Enum<CopyCordapps> {
    public static final /* enum */ CopyCordapps FirstRunOnly;
    public static final /* enum */ CopyCordapps Yes;
    public static final /* enum */ CopyCordapps No;
    private static final /* synthetic */ CopyCordapps[] $VALUES;

    static {
        CopyCordapps[] copyCordappsArray = new CopyCordapps[3];
        CopyCordapps[] copyCordappsArray2 = copyCordappsArray;
        copyCordappsArray[0] = FirstRunOnly = new FirstRunOnly("FirstRunOnly", 0);
        copyCordappsArray[1] = Yes = new Yes("Yes", 1);
        copyCordappsArray[2] = No = new No("No", 2);
        $VALUES = copyCordappsArray;
    }

    protected abstract void copyTo(@NotNull List<? extends Path> var1, @NotNull List<? extends Path> var2, boolean var3, boolean var4);

    protected final void copy(@NotNull List<? extends Path> $receiver, @NotNull List<? extends Path> nodeDirs) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(nodeDirs, (String)"nodeDirs");
        Collection object = $receiver;
        if (!object.isEmpty()) {
            String string = "Copying CorDapp JARs into node directories";
            System.out.println((Object)string);
            for (Path path : nodeDirs) {
                Path cordappsDir = PathUtilsKt.createDirectories((Path)PathUtilsKt.div((Path)path, (String)"cordapps"), (FileAttribute[])new FileAttribute[0]);
                Iterable $receiver$iv = $receiver;
                for (Object element$iv : $receiver$iv) {
                    Path it = (Path)element$iv;
                    try {
                        PathUtilsKt.copyToDirectory((Path)it, (Path)cordappsDir, (CopyOption[])new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        String string2 = "WARNING: " + it.getFileName() + " already exists in " + cordappsDir + ", ignoring and leaving existing CorDapp untouched";
                        System.out.println((Object)string2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void copy(@NotNull List<? extends Path> cordappJars, @NotNull List<? extends Path> nodeDirs, boolean networkAlreadyExists, boolean fromCordform) {
        Intrinsics.checkParameterIsNotNull(cordappJars, (String)"cordappJars");
        Intrinsics.checkParameterIsNotNull(nodeDirs, (String)"nodeDirs");
        if (!fromCordform) {
            Collection<Path> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Object object = cordappJars;
            StringBuilder stringBuilder = new StringBuilder().append("Found the following CorDapps: ");
            void var6_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                collection = destination$iv$iv;
                Path path2 = it.getFileName();
                collection.add(path2);
            }
            collection = (List)destination$iv$iv;
            object = stringBuilder.append(collection).toString();
            System.out.println(object);
        }
        this.copyTo(cordappJars, nodeDirs, networkAlreadyExists, fromCordform);
    }

    public static CopyCordapps[] values() {
        return (CopyCordapps[])$VALUES.clone();
    }

    public static CopyCordapps valueOf(String string) {
        return Enum.valueOf(CopyCordapps.class, string);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J4\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lnet/corda/nodeapi/internal/network/CopyCordapps$FirstRunOnly;", "Lnet/corda/nodeapi/internal/network/CopyCordapps;", "copyTo", "", "cordappJars", "", "Ljava/nio/file/Path;", "nodeDirs", "networkAlreadyExists", "", "fromCordform", "node-api"})
    public static final class FirstRunOnly
    extends CopyCordapps {
        @Override
        protected void copyTo(@NotNull List<? extends Path> cordappJars, @NotNull List<? extends Path> nodeDirs, boolean networkAlreadyExists, boolean fromCordform) {
            Intrinsics.checkParameterIsNotNull(cordappJars, (String)"cordappJars");
            Intrinsics.checkParameterIsNotNull(nodeDirs, (String)"nodeDirs");
            if (networkAlreadyExists) {
                if (!fromCordform) {
                    String string = "Not copying CorDapp JARs as --copy-cordapps is set to FirstRunOnly, and it looks like this network has already been bootstrapped.";
                    System.out.println((Object)string);
                }
                return;
            }
            this.copy(cordappJars, nodeDirs);
        }

        FirstRunOnly() {
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J4\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lnet/corda/nodeapi/internal/network/CopyCordapps$Yes;", "Lnet/corda/nodeapi/internal/network/CopyCordapps;", "copyTo", "", "cordappJars", "", "Ljava/nio/file/Path;", "nodeDirs", "networkAlreadyExists", "", "fromCordform", "node-api"})
    public static final class Yes
    extends CopyCordapps {
        @Override
        protected void copyTo(@NotNull List<? extends Path> cordappJars, @NotNull List<? extends Path> nodeDirs, boolean networkAlreadyExists, boolean fromCordform) {
            Intrinsics.checkParameterIsNotNull(cordappJars, (String)"cordappJars");
            Intrinsics.checkParameterIsNotNull(nodeDirs, (String)"nodeDirs");
            this.copy(cordappJars, nodeDirs);
        }

        Yes() {
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J4\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lnet/corda/nodeapi/internal/network/CopyCordapps$No;", "Lnet/corda/nodeapi/internal/network/CopyCordapps;", "copyTo", "", "cordappJars", "", "Ljava/nio/file/Path;", "nodeDirs", "networkAlreadyExists", "", "fromCordform", "node-api"})
    public static final class No
    extends CopyCordapps {
        @Override
        protected void copyTo(@NotNull List<? extends Path> cordappJars, @NotNull List<? extends Path> nodeDirs, boolean networkAlreadyExists, boolean fromCordform) {
            Intrinsics.checkParameterIsNotNull(cordappJars, (String)"cordappJars");
            Intrinsics.checkParameterIsNotNull(nodeDirs, (String)"nodeDirs");
            if (!fromCordform) {
                String string = "Not copying CorDapp JARs as --copy-cordapps is set to No.";
                System.out.println((Object)string);
            }
        }

        No() {
        }
    }
}

