/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarInputStream;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import net.corda.core.concurrent.CordaFuture;
import net.corda.core.crypto.SecureHash;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.JarSignatureCollector;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.internal.SignedDataWithCert;
import net.corda.core.internal.ThreadLocalToggleField;
import net.corda.core.internal.concurrent.CordaFutureImplKt;
import net.corda.core.node.NetworkParameters;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.NotaryInfo;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.serialization.internal.SerializationEnvironment;
import net.corda.core.serialization.internal.SerializationEnvironmentKt;
import net.corda.core.utilities.ByteArrays;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.ContractsJar;
import net.corda.nodeapi.internal.DevIdentityGenerator;
import net.corda.nodeapi.internal.KeyStoreConfigHelpersKt;
import net.corda.nodeapi.internal.SignedNodeInfo;
import net.corda.nodeapi.internal.config.ConfigUtilities;
import net.corda.nodeapi.internal.network.CopyCordapps;
import net.corda.nodeapi.internal.network.NetworkBootstrapper;
import net.corda.nodeapi.internal.network.NetworkBootstrapperKt;
import net.corda.nodeapi.internal.network.NetworkBootstrapperWithOverridableParameters;
import net.corda.nodeapi.internal.network.NetworkMapKt;
import net.corda.nodeapi.internal.network.NetworkParametersCopier;
import net.corda.nodeapi.internal.network.NetworkParametersOverrides;
import net.corda.nodeapi.internal.network.WhitelistGeneratorKt;
import net.corda.serialization.internal.CordaSerializationMagic;
import net.corda.serialization.internal.SerializationFactoryImpl;
import net.corda.serialization.internal.SerializationScheme;
import net.corda.serialization.internal.SharedContexts;
import net.corda.serialization.internal.amqp.AbstractAMQPSerializationScheme;
import net.corda.serialization.internal.amqp.SchemaKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 =2\u00020\u0001:\u0004<=>?B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002BQ\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u001e\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u001c\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J4\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\n2\u001c\u0010#\u001a\u0018\u0012\u0004\u0012\u00020%\u0012\u000e\u0012\f\u0012\b\u0012\u00060&j\u0002`'0\n0$H\u0002J$\u0010(\u001a\u00020\u00102\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J0\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0\n2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001d0$H\u0002J\u001c\u0010.\u001a\u00020\u00102\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001d0$H\u0002J\b\u0010/\u001a\u00020\u0010H\u0002JT\u00100\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\n2\u001c\u0010#\u001a\u0018\u0012\u0004\u0012\u00020%\u0012\u000e\u0012\f\u0012\b\u0012\u00060&j\u0002`'0\n0$2\b\u00101\u001a\u0004\u0018\u00010 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u001dH\u0002J\u0010\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u000bH\u0002J\u0018\u00106\u001a\u0004\u0018\u00010 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J.\u00107\u001a\u0014\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0$2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001d0$H\u0002J\f\u00109\u001a\u00020:*\u00020;H\u0002R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkBootstrapper;", "Lnet/corda/nodeapi/internal/network/NetworkBootstrapperWithOverridableParameters;", "()V", "initSerEnv", "", "embeddedCordaJar", "Lkotlin/Function0;", "Ljava/io/InputStream;", "nodeInfosGenerator", "Lkotlin/Function1;", "", "Ljava/nio/file/Path;", "contractsJarConverter", "Lnet/corda/nodeapi/internal/ContractsJar;", "(ZLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "bootstrap", "", "directory", "cordappJars", "copyCordapps", "Lnet/corda/nodeapi/internal/network/CopyCordapps;", "fromCordform", "networkParametersOverrides", "Lnet/corda/nodeapi/internal/network/NetworkParametersOverrides;", "networkParameterOverrides", "bootstrapCordform", "checkForDuplicateLegalNames", "nodeConfigs", "", "Lcom/typesafe/config/Config;", "createNodeDirectoriesIfNeeded", "defaultNetworkParametersWith", "Lnet/corda/core/node/NetworkParameters;", "notaryInfos", "Lnet/corda/core/node/NotaryInfo;", "whitelist", "", "", "Lnet/corda/core/crypto/SecureHash;", "Lnet/corda/core/node/services/AttachmentId;", "distributeNodeInfos", "nodeDirs", "nodeInfoFiles", "gatherNodeDirectories", "gatherNotaryInfos", "configs", "generateServiceIdentitiesForNotaryClusters", "initialiseSerialization", "installNetworkParameters", "existingNetParams", "isBFTNotary", "config", "isSigned", "file", "loadNetworkParameters", "notaryClusters", "Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$NotaryCluster;", "notaryIdentity", "Lnet/corda/core/identity/Party;", "Lnet/corda/core/node/NodeInfo;", "AMQPParametersSerializationScheme", "Companion", "DirectoryAndConfig", "NotaryCluster", "node-api"})
public final class NetworkBootstrapper
implements NetworkBootstrapperWithOverridableParameters {
    private final boolean initSerEnv;
    private final Function0<InputStream> embeddedCordaJar;
    private final Function1<List<? extends Path>, List<Path>> nodeInfosGenerator;
    private final Function1<Path, ContractsJar> contractsJarConverter;
    private static final List<String> nodeInfoGenCmd;
    private static final String LOGS_DIR_NAME = "logs";
    private static final Set<String> jarsThatArentCordapps;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0xA00000;
    public static final int DEFAULT_MAX_TRANSACTION_SIZE = 524288000;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final Map<NotaryCluster, List<Path>> notaryClusters(Map<Path, ? extends Config> configs) {
        Iterable list$iv$iv;
        CordaX500Name key$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = configs;
        Map<Path, ? extends Config> map = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        Object object = $receiver$iv$iv;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            List list2;
            Map.Entry element$iv$iv;
            Map.Entry $path_config;
            Map.Entry entry = $path_config = (element$iv$iv = iterator2.next());
            Path path = (Path)entry.getKey();
            entry = $path_config;
            Config config = (Config)entry.getValue();
            if (config.hasPath("notary.serviceLegalName")) {
                String string = config.getString("notary.serviceLegalName");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"config.getString(\"notary.serviceLegalName\")");
                list2 = CollectionsKt.listOf((Object)TuplesKt.to((Object)CordaX500Name.Companion.parse(string), (Object)new DirectoryAndConfig(path, config)));
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv2 = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        List clusteredNotaries = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)clusteredNotaries;
        destination$iv$iv = new LinkedHashMap();
        object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object.next();
            Pair it = (Pair)element$iv$iv;
            key$iv$iv = (CordaX500Name)it.getFirst();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.size());
        object = $receiver$iv$iv;
        iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Path path;
            Iterator iterator3;
            Config it;
            Object element$iv;
            boolean bl;
            List cs;
            Object object3;
            Pair it2;
            Object object4;
            Object item$iv$iv;
            Object $receiver$iv$iv2;
            Collection destination$iv$iv2;
            Iterable $receiver$iv2;
            List vs;
            CordaX500Name k;
            Object object5;
            block19: {
                void $k_vs;
                Map.Entry item$iv$iv2;
                Map.Entry $i$a$1$groupBy = item$iv$iv2 = iterator2.next();
                object5 = destination$iv$iv;
                key$iv$iv = $k_vs;
                k = (CordaX500Name)key$iv$iv.getKey();
                key$iv$iv = $k_vs;
                vs = (List)key$iv$iv.getValue();
                $receiver$iv2 = vs;
                list$iv$iv = $receiver$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                Iterator $i$f$groupByTo = $receiver$iv$iv2.iterator();
                while ($i$f$groupByTo.hasNext()) {
                    item$iv$iv = $i$f$groupByTo.next();
                    Pair pair2 = (Pair)item$iv$iv;
                    object4 = destination$iv$iv2;
                    object3 = ((DirectoryAndConfig)it2.getSecond()).getConfig();
                    object4.add(object3);
                }
                cs = (List)destination$iv$iv2;
                $receiver$iv2 = cs;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl = false;
                } else {
                    $receiver$iv$iv2 = $receiver$iv2.iterator();
                    while ($receiver$iv$iv2.hasNext()) {
                        element$iv = $receiver$iv$iv2.next();
                        it = (Config)element$iv;
                        if (!this.isBFTNotary(it)) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            }
            if (bl) {
                boolean $receiver$iv3;
                block20: {
                    boolean bl2;
                    $receiver$iv2 = cs;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl2 = true;
                    } else {
                        $receiver$iv$iv2 = $receiver$iv2.iterator();
                        while ($receiver$iv$iv2.hasNext()) {
                            element$iv = $receiver$iv$iv2.next();
                            it = (Config)element$iv;
                            if (this.isBFTNotary(it)) continue;
                            bl2 = false;
                            break block20;
                        }
                        bl2 = $receiver$iv3 = true;
                    }
                }
                if (!$receiver$iv3) {
                    element$iv = "Mix of BFT and non-BFT notaries with service name " + k;
                    throw (Throwable)new IllegalArgumentException(element$iv.toString());
                }
                $receiver$iv2 = vs;
                object4 = new NotaryCluster.BFT(k);
                Iterable $i$a$3$require = $receiver$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                iterator3 = $receiver$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    item$iv$iv = iterator3.next();
                    Pair $i$f$all = (Pair)item$iv$iv;
                    object3 = destination$iv$iv2;
                    path = ((DirectoryAndConfig)it2.getSecond()).getDirectory();
                    object3.add(path);
                }
                object3 = (List)destination$iv$iv2;
                pair = TuplesKt.to((Object)object4, (Object)object3);
            } else {
                $receiver$iv2 = vs;
                object4 = new NotaryCluster.CFT(k);
                $receiver$iv$iv2 = $receiver$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                iterator3 = $receiver$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    item$iv$iv = iterator3.next();
                    it2 = (Pair)item$iv$iv;
                    object3 = destination$iv$iv2;
                    path = ((DirectoryAndConfig)it2.getSecond()).getDirectory();
                    object3.add(path);
                }
                object3 = (List)destination$iv$iv2;
                pair = TuplesKt.to((Object)object4, (Object)object3);
            }
            Pair pair3 = pair;
            object5.add(pair3);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final boolean isBFTNotary(Config config) {
        return config.hasPath("notary.bftSMaRt");
    }

    private final void generateServiceIdentitiesForNotaryClusters(Map<Path, ? extends Config> configs) {
        Map<NotaryCluster, List<Path>> $receiver$iv;
        Map<NotaryCluster, List<Path>> map = $receiver$iv = this.notaryClusters(configs);
        Iterator<Map.Entry<NotaryCluster, List<Path>>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<NotaryCluster, List<Path>> element$iv;
            Map.Entry<NotaryCluster, List<Path>> $cluster_directories = element$iv = iterator2.next();
            Object object = $cluster_directories;
            NotaryCluster cluster = object.getKey();
            object = $cluster_directories;
            List<Path> directories = object.getValue();
            object = cluster;
            if (object instanceof NotaryCluster.BFT) {
                DevIdentityGenerator.INSTANCE.generateDistributedNotaryCompositeIdentity(directories, ((NotaryCluster.BFT)cluster).getName(), 1 + 2 * directories.size() / 3);
                continue;
            }
            if (!(object instanceof NotaryCluster.CFT)) continue;
            DevIdentityGenerator.INSTANCE.generateDistributedNotarySingularIdentity(directories, ((NotaryCluster.CFT)cluster).getName());
        }
    }

    public final void bootstrap(@NotNull Path directory, @NotNull List<? extends Path> cordappJars) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull(cordappJars, (String)"cordappJars");
        NetworkBootstrapper.bootstrap$default(this, directory, cordappJars, CopyCordapps.Yes, true, null, 16, null);
    }

    public final void bootstrapCordform(@NotNull Path directory, @NotNull List<? extends Path> cordappJars) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull(cordappJars, (String)"cordappJars");
        NetworkBootstrapper.bootstrap$default(this, directory, cordappJars, CopyCordapps.No, true, null, 16, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bootstrap(@NotNull Path directory, @NotNull CopyCordapps copyCordapps, @NotNull NetworkParametersOverrides networkParameterOverrides) {
        List list2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)copyCordapps), (String)"copyCordapps");
        Intrinsics.checkParameterIsNotNull((Object)networkParameterOverrides, (String)"networkParameterOverrides");
        boolean bl2 = bl = networkParameterOverrides.getMinimumPlatformVersion() == null || networkParameterOverrides.getMinimumPlatformVersion() <= 4;
        if (!bl) {
            String string = "Minimum platform version cannot be greater than 4";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path bootstrapperJar = InternalUtils.toPath((URL)InternalUtils.getLocation(this.getClass()));
        Path $receiver$iv = directory;
        AutoCloseable autoCloseable = Files.list($receiver$iv);
        Throwable throwable = null;
        try {
            Stream paths = (Stream)autoCloseable;
            Stream stream = paths.filter((Predicate)new Predicate<Path>(bootstrapperJar){
                final /* synthetic */ Path $bootstrapperJar$inlined;
                {
                    this.$bootstrapperJar$inlined = path;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean test(Path it) {
                    if (!StringsKt.endsWith$default((String)((Object)it).toString(), (String)".jar", (boolean)false, (int)2, null)) return false;
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    if (PathUtilsKt.isSameAs((Path)path, (Path)this.$bootstrapperJar$inlined)) return false;
                    String string = ((Object)it.getFileName()).toString();
                    Set set2 = NetworkBootstrapper.access$getJarsThatArentCordapps$cp();
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    String string4 = string3;
                    if (set2.contains(string4)) return false;
                    return true;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(stream, (String)"paths.filter { it.toStri\u2026String().toLowerCase()) }");
            list2 = StreamsKt.toList(stream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        List cordappJars = list2;
        this.bootstrap(directory, cordappJars, copyCordapps, false, networkParameterOverrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void bootstrap(Path directory, List<? extends Path> cordappJars, CopyCordapps copyCordapps, boolean fromCordform, NetworkParametersOverrides networkParametersOverrides) {
        Object $receiver$iv$iv;
        Iterable<Path> iterable;
        Iterable it;
        Collection<Path> collection;
        Object object;
        boolean bl;
        PathUtilsKt.createDirectories((Path)directory, (FileAttribute[])new FileAttribute[0]);
        String string = "Bootstrapping local test network in " + directory;
        System.out.println((Object)string);
        boolean networkAlreadyExists = this.createNodeDirectoriesIfNeeded(directory, fromCordform);
        List<Path> nodeDirs = this.gatherNodeDirectories(directory);
        Collection collection2 = nodeDirs;
        boolean bl2 = bl = !collection2.isEmpty();
        if (!bl) {
            String string2 = "No nodes found";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (!fromCordform) {
            void $receiver$iv$iv2;
            String $receiver$iv;
            Iterable iterable2 = nodeDirs;
            object = new StringBuilder().append("Nodes found in the following sub-directories: ");
            void $i$a$2$require = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$receiver$iv), (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                Path path = (Path)item$iv$iv;
                collection = destination$iv$iv;
                iterable = it.getFileName();
                collection.add((Path)iterable);
            }
            collection = (List)destination$iv$iv;
            $receiver$iv = ((StringBuilder)object).append(collection).toString();
            System.out.println((Object)$receiver$iv);
        }
        Object $receiver$iv = nodeDirs;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Object object2 = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv2);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Path it2;
            Path $i$f$mapTo = (Path)element$iv$iv;
            object = destination$iv$iv;
            collection = it2;
            it2 = (Path)element$iv$iv;
            iterable = ConfigFactory.parseFile((File)PathUtilsKt.div((Path)it2, (String)"node.conf").toFile());
            object.put(collection, iterable);
        }
        Map configs = destination$iv$iv;
        this.checkForDuplicateLegalNames(configs.values());
        copyCordapps.copy(cordappJars, nodeDirs, networkAlreadyExists, fromCordform);
        this.generateServiceIdentitiesForNotaryClusters(configs);
        if (this.initSerEnv) {
            this.initialiseSerialization();
        }
        try {
            String string3;
            void $receiver$iv$iv3;
            Function1<Path, ContractsJar> $receiver$iv$iv4;
            Iterable $receiver$iv2;
            Object element$iv$iv;
            $receiver$iv = "Waiting for all nodes to generate their node-info files...";
            System.out.println($receiver$iv);
            List nodeInfoFiles = (List)this.nodeInfosGenerator.invoke(nodeDirs);
            String capacity$iv2 = "Distributing all node-info files to all nodes";
            System.out.println((Object)capacity$iv2);
            this.distributeNodeInfos(nodeDirs, nodeInfoFiles);
            capacity$iv2 = "Loading existing network parameters... ";
            System.out.print((Object)capacity$iv2);
            NetworkParameters existingNetParams = this.loadNetworkParameters(nodeDirs);
            Object object3 = existingNetParams;
            if (object3 == null) {
                object3 = "none found";
            }
            $receiver$iv$iv = object3;
            System.out.println($receiver$iv$iv);
            $receiver$iv$iv = "Gathering notary identities";
            System.out.println($receiver$iv$iv);
            List<NotaryInfo> notaryInfos = this.gatherNotaryInfos(nodeInfoFiles, configs);
            destination$iv$iv = "Generating contract implementations whitelist";
            System.out.println(destination$iv$iv);
            it = cordappJars;
            collection = WhitelistGeneratorKt.readExcludeWhitelist(directory);
            object = existingNetParams;
            element$iv$iv = $receiver$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv4) {
                Path it3 = (Path)element$iv$iv2;
                if (!(!this.isSigned(it3))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            iterable = (List)destination$iv$iv2;
            $receiver$iv2 = iterable;
            $receiver$iv$iv4 = this.contractsJarConverter;
            destination$iv$iv2 = $receiver$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv3) {
                void transform$iv;
                destination$iv$iv3.add(transform$iv.invoke(item$iv$iv));
            }
            iterable = (List)destination$iv$iv3;
            Map<String, List<SecureHash>> newWhitelist = WhitelistGeneratorKt.generateWhitelist((NetworkParameters)object, collection, (List<? extends ContractsJar>)iterable);
            NetworkParameters newNetParams = this.installNetworkParameters(notaryInfos, newWhitelist, existingNetParams, nodeDirs, networkParametersOverrides);
            if (Intrinsics.areEqual((Object)newNetParams, (Object)existingNetParams) ^ true) {
                string3 = (existingNetParams == null ? "New" : "Updated") + ' ' + newNetParams;
                System.out.println((Object)string3);
            } else {
                string3 = "Network parameters unchanged";
                System.out.println((Object)string3);
            }
            string3 = "Bootstrapping complete!";
            System.out.println((Object)string3);
        }
        finally {
            if (this.initSerEnv) {
                SerializationEnvironmentKt.get_contextSerializationEnv().set(null);
            }
        }
    }

    static /* bridge */ /* synthetic */ void bootstrap$default(NetworkBootstrapper networkBootstrapper, Path path, List list2, CopyCordapps copyCordapps, boolean bl, NetworkParametersOverrides networkParametersOverrides, int n, Object object) {
        if ((n & 0x10) != 0) {
            networkParametersOverrides = new NetworkParametersOverrides(null, null, null, null, null, 31, null);
        }
        networkBootstrapper.bootstrap(path, list2, copyCordapps, bl, networkParametersOverrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean createNodeDirectoriesIfNeeded(Path directory, boolean fromCordform) {
        Object nodeName;
        Object it3;
        Object it23;
        Object object;
        boolean networkAlreadyExists = false;
        Path cordaJar = PathUtilsKt.div((Path)directory, (String)"corda.jar");
        boolean usingEmbedded = false;
        if (!PathUtilsKt.exists((Path)cordaJar, (LinkOption[])new LinkOption[0])) {
            object = (Closeable)this.embeddedCordaJar.invoke();
            Throwable throwable = null;
            try {
                InputStream it222 = (InputStream)object;
                long it222 = InternalUtils.copyTo((InputStream)it222, (Path)cordaJar, (CopyOption[])new CopyOption[0]);
            }
            catch (Throwable it222) {
                throwable = it222;
                throw it222;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            usingEmbedded = true;
        } else if (!fromCordform) {
            object = "Using corda.jar in root directory";
            System.out.println(object);
        }
        Path $receiver$iv = directory;
        AutoCloseable it222 = Files.list($receiver$iv);
        Iterator<Path> iterator2 = null;
        try {
            it23 = (Stream)it222;
            Stream stream = it23.filter(createNodeDirectoriesIfNeeded.confFiles.1.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(stream, (String)"it.filter { it.toString().endsWith(\"_node.conf\") }");
            it23 = StreamsKt.toList(stream);
        }
        catch (Throwable it23) {
            iterator2 = it23;
            throw it23;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)it222, (Throwable)((Object)iterator2));
        }
        Object confFiles2 = it23;
        Iterable<Path> $receiver$iv2 = directory;
        iterator2 = Files.list((Path)$receiver$iv2);
        it23 = null;
        try {
            it3 = (Stream)((Object)iterator2);
            Stream stream = it3.filter(createNodeDirectoriesIfNeeded.webServerConfFiles.1.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(stream, (String)"it.filter { it.toString(\u2026ith(\"_web-server.conf\") }");
            it3 = StreamsKt.toList(stream);
        }
        catch (Throwable it3) {
            it23 = it3;
            throw it3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)((Object)iterator2), (Throwable)it23);
        }
        Object webServerConfFiles2 = it3;
        iterator2 = confFiles2.iterator();
        while (iterator2.hasNext()) {
            Object v3;
            Path nodeDir;
            block34: {
                Path confFile;
                Path path = confFile = (Path)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"confFile");
                nodeName = StringsKt.removeSuffix((String)((Object)path.getFileName()).toString(), (CharSequence)"_node.conf");
                it3 = "Generating node directory for " + (String)nodeName;
                System.out.println(it3);
                if (PathUtilsKt.exists((Path)PathUtilsKt.div((Path)directory, (String)nodeName), (LinkOption[])new LinkOption[0])) {
                    networkAlreadyExists = true;
                }
                nodeDir = PathUtilsKt.createDirectories((Path)PathUtilsKt.div((Path)directory, (String)nodeName), (FileAttribute[])new FileAttribute[0]);
                PathUtilsKt.copyTo((Path)confFile, (Path)PathUtilsKt.div((Path)nodeDir, (String)"node.conf"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                Iterable $receiver$iv3 = (Iterable)webServerConfFiles2;
                for (Object element$iv : $receiver$iv3) {
                    Path it4 = (Path)element$iv;
                    if (!Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)((Object)directory.relativize(it4)).toString(), (CharSequence)"_web-server.conf"), (Object)nodeName)) continue;
                    v3 = element$iv;
                    break block34;
                }
                v3 = null;
            }
            Path path = v3;
            if (path != null) {
                PathUtilsKt.copyTo((Path)path, (Path)PathUtilsKt.div((Path)nodeDir, (String)"web-server.conf"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
            PathUtilsKt.copyToDirectory((Path)cordaJar, (Path)nodeDir, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        $receiver$iv2 = directory;
        iterator2 = Files.list((Path)$receiver$iv2);
        nodeName = null;
        try {
            Stream paths = (Stream)((Object)iterator2);
            paths.filter(createNodeDirectoriesIfNeeded.3.1.INSTANCE).forEach(new Consumer<Path>(cordaJar){
                final /* synthetic */ Path $cordaJar$inlined;
                {
                    this.$cordaJar$inlined = path;
                }

                public final void accept(Path it) {
                    StringBuilder stringBuilder = new StringBuilder().append("Copying corda.jar into node directory ");
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    String string = stringBuilder.append(path.getFileName()).toString();
                    System.out.println((Object)string);
                    PathUtilsKt.copyToDirectory((Path)this.$cordaJar$inlined, (Path)it, (CopyOption[])new CopyOption[0]);
                }
            });
            paths = Unit.INSTANCE;
        }
        catch (Throwable paths) {
            nodeName = paths;
            throw paths;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)((Object)iterator2), (Throwable)nodeName);
        }
        if (fromCordform) {
            Path p1;
            Path element$iv;
            $receiver$iv2 = (Iterable)confFiles2;
            iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                p1 = element$iv = iterator2.next();
                PathUtilsKt.delete((Path)p1);
            }
            $receiver$iv2 = (Iterable)webServerConfFiles2;
            iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                p1 = element$iv = iterator2.next();
                PathUtilsKt.delete((Path)p1);
            }
        }
        if (fromCordform || usingEmbedded) {
            PathUtilsKt.delete((Path)cordaJar);
        }
        return networkAlreadyExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Path> gatherNodeDirectories(Path directory) {
        List list2;
        Path $receiver$iv = directory;
        AutoCloseable autoCloseable = Files.list($receiver$iv);
        Throwable throwable = null;
        try {
            Stream paths = (Stream)autoCloseable;
            Stream stream = paths.filter(gatherNodeDirectories.1.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(stream, (String)"paths.filter {\n         \u2026     exists\n            }");
            list2 = StreamsKt.toList(stream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list2;
    }

    private final void distributeNodeInfos(List<? extends Path> nodeDirs, List<? extends Path> nodeInfoFiles) {
        for (Path path : nodeDirs) {
            Path additionalNodeInfosDir = PathUtilsKt.createDirectories((Path)PathUtilsKt.div((Path)path, (String)"additional-node-infos"), (FileAttribute[])new FileAttribute[0]);
            for (Path path2 : nodeInfoFiles) {
                PathUtilsKt.copyToDirectory((Path)path2, (Path)additionalNodeInfosDir, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
        }
    }

    private final void checkForDuplicateLegalNames(Collection<? extends Config> nodeConfigs) {
        Object $receiver$iv$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = nodeConfigs;
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv2 = destination$iv$iv;
            Object element$iv$iv = iterator2.next();
            Config it = (Config)element$iv$iv;
            String key$iv$iv = it.getString("myLegalName");
            Object value$iv$iv$iv = $receiver$iv$iv$iv2.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Object object = $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Map.Entry element$iv$iv$iv : object.entrySet()) {
            String string;
            Map.Entry element$iv$iv = element$iv$iv$iv;
            Map.Entry it = element$iv$iv;
            String string2 = ((List)it.getValue()).size() > 1 ? (String)it.getKey() : null;
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        List duplicateLegalNames = (List)destination$iv$iv;
        boolean bl = duplicateLegalNames.isEmpty();
        if (!bl) {
            String string = "Nodes must have unique legal names. The following are used more than once: " + duplicateLegalNames;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotaryInfo> gatherNotaryInfos(List<? extends Path> nodeInfoFiles, Map<Path, ? extends Config> configs) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)nodeInfoFiles;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            NotaryInfo notaryInfo;
            NotaryInfo notaryInfo2;
            Config nodeConfig;
            Object element$iv$iv = element$iv$iv$iv;
            Path nodeInfoFile = (Path)element$iv$iv;
            if (configs.get(nodeInfoFile.getParent()) == null) {
                Intrinsics.throwNpe();
            }
            if (nodeConfig.hasPath("notary")) {
                boolean bl;
                boolean validating = ConfigUtilities.getBooleanCaseInsensitive(nodeConfig, "notary.validating");
                Path $receiver$iv2 = nodeInfoFile;
                byte[] $receiver$iv$iv2 = PathUtilsKt.readAll((Path)$receiver$iv2);
                SerializationFactory serializationFactory$iv$iv = SerializationFactory.Companion.getDefaultFactory();
                SerializationContext context$iv$iv = serializationFactory$iv$iv.getDefaultContext();
                byte[] byArray = $receiver$iv$iv2;
                byte[] byArray2 = byArray;
                boolean bl2 = bl = !(byArray2.length == 0);
                if (!bl) {
                    String string = "Empty bytes";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                ByteSequence $receiver$iv$iv$iv2 = ByteArrays.sequence$default((byte[])$receiver$iv$iv2, (int)0, (int)0, (int)3, null);
                NodeInfo nodeInfo = ((SignedNodeInfo)serializationFactory$iv$iv.deserialize($receiver$iv$iv$iv2, SignedNodeInfo.class, context$iv$iv)).verified();
                notaryInfo2 = new NotaryInfo(this.notaryIdentity(nodeInfo), validating);
            } else {
                notaryInfo2 = null;
            }
            if (notaryInfo2 == null) continue;
            NotaryInfo it$iv$iv = notaryInfo = notaryInfo2;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final NetworkParameters loadNetworkParameters(List<? extends Path> nodeDirs) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)nodeDirs;
        Object destination$iv$iv = new ArrayList();
        Iterator $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Path path;
            Object element$iv$iv$iv = iterator2.next();
            Object element$iv$iv = element$iv$iv$iv;
            Path it = (Path)element$iv$iv;
            Path netParamsFile = PathUtilsKt.div((Path)it, (String)"network-parameters");
            Path path2 = PathUtilsKt.exists((Path)netParamsFile, (LinkOption[])new LinkOption[0]) ? netParamsFile : null;
            if (path2 == null) continue;
            Path it$iv$iv = path = path2;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        $receiver$iv$iv$iv = $receiver$iv$iv.iterator();
        while ($receiver$iv$iv$iv.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv2 = destination$iv$iv;
            Object element$iv$iv = $receiver$iv$iv$iv.next();
            Path it = (Path)element$iv$iv;
            SerializedBytes key$iv$iv = new SerializedBytes(PathUtilsKt.readAll((Path)it));
            Object value$iv$iv$iv = $receiver$iv$iv$iv2.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object netParamsFilesGrouped = destination$iv$iv;
        switch (netParamsFilesGrouped.size()) {
            case 0: {
                return null;
            }
            case 1: {
                $receiver$iv = (SerializedBytes)CollectionsKt.first((Iterable)netParamsFilesGrouped.keySet());
                SerializationFactory serializationFactory$iv = SerializationFactory.Companion.getDefaultFactory();
                SerializationContext context$iv = serializationFactory$iv.getDefaultContext();
                return (NetworkParameters)NetworkMapKt.verifiedNetworkParametersCert((SignedDataWithCert)serializationFactory$iv.deserialize((ByteSequence)$receiver$iv, SignedDataWithCert.class, context$iv), KeyStoreConfigHelpersKt.getDEV_ROOT_CA().getCertificate());
            }
        }
        StringBuilder msg = new StringBuilder("Differing sets of network parameters were found. Make sure all the nodes have the same network parameters by copying the correct network-parameters file across.\n\n");
        netParamsFilesGrouped.forEach((BiConsumer)new BiConsumer<SerializedBytes<SignedDataWithCert<NetworkParameters>>, List<? extends Path>>(msg){
            final /* synthetic */ StringBuilder $msg;

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull SerializedBytes<SignedDataWithCert<NetworkParameters>> bytes, @NotNull List<? extends Path> netParamsFiles) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull(bytes, (String)"bytes");
                Intrinsics.checkParameterIsNotNull(netParamsFiles, (String)"netParamsFiles");
                Iterable $receiver$iv = netParamsFiles;
                Object object = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    Path path2 = it.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"it.parent");
                    Path path3 = path2.getFileName();
                    collection.add(path3);
                }
                CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)this.$msg, (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
                this.$msg.append(":\n");
                try {
                    SerializedBytes<SignedDataWithCert<NetworkParameters>> $receiver$iv2 = bytes;
                    SerializationFactory serializationFactory$iv = SerializationFactory.Companion.getDefaultFactory();
                    SerializationContext context$iv = serializationFactory$iv.getDefaultContext();
                    object = ((NetworkParameters)NetworkMapKt.verifiedNetworkParametersCert((SignedDataWithCert)serializationFactory$iv.deserialize((ByteSequence)$receiver$iv2, SignedDataWithCert.class, context$iv), KeyStoreConfigHelpersKt.getDEV_ROOT_CA().getCertificate())).toString();
                }
                catch (Exception e) {
                    object = "Invalid network parameters file: " + e;
                }
                Object netParamsString = object;
                this.$msg.append((String)netParamsString);
                this.$msg.append("\n\n");
            }
            {
                this.$msg = stringBuilder;
            }
        });
        throw (Throwable)new IllegalStateException(msg.toString());
    }

    private final NetworkParameters defaultNetworkParametersWith(List<NotaryInfo> notaryInfos, Map<String, ? extends List<? extends SecureHash>> whitelist) {
        Instant instant = Instant.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
        Duration duration = KotlinUtilsKt.getDays((int)30);
        int n = 1;
        Map map = MapsKt.emptyMap();
        Map<String, ? extends List<? extends SecureHash>> map2 = whitelist;
        int n2 = 524288000;
        int n3 = 0xA00000;
        Instant instant2 = instant;
        return new NetworkParameters(4, notaryInfos, n3, n2, instant2, n, map2, duration, map);
    }

    /*
     * WARNING - void declaration
     */
    private final NetworkParameters installNetworkParameters(List<NotaryInfo> notaryInfos, Map<String, ? extends List<? extends SecureHash>> whitelist, NetworkParameters existingNetParams, List<? extends Path> nodeDirs, NetworkParametersOverrides networkParametersOverrides) {
        void $receiver$iv;
        NetworkParameters networkParameters;
        if (existingNetParams != null) {
            NetworkParameters newNetParams = NetworkBootstrapperKt.overrideWith(NetworkParameters.copy$default((NetworkParameters)existingNetParams, (int)0, notaryInfos, (int)0, (int)0, null, (int)0, whitelist, null, null, (int)445, null), networkParametersOverrides);
            if (Intrinsics.areEqual((Object)newNetParams, (Object)existingNetParams) ^ true) {
                Instant instant = Instant.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
                networkParameters = NetworkParameters.copy$default((NetworkParameters)newNetParams, (int)0, null, (int)0, (int)0, (Instant)instant, (int)(existingNetParams.getEpoch() + 1), null, null, null, (int)463, null);
            } else {
                networkParameters = existingNetParams;
            }
        } else {
            networkParameters = NetworkBootstrapperKt.overrideWith(this.defaultNetworkParametersWith(notaryInfos, whitelist), networkParametersOverrides);
        }
        NetworkParameters netParams = networkParameters;
        NetworkParametersCopier copier = new NetworkParametersCopier(netParams, null, true, false, 10, null);
        Iterable iterable = nodeDirs;
        NetworkParametersCopier networkParametersCopier = copier;
        for (Object element$iv : $receiver$iv) {
            Path p1 = (Path)element$iv;
            networkParametersCopier.install(p1);
        }
        return netParams;
    }

    private final Party notaryIdentity(@NotNull NodeInfo $receiver) {
        Party party;
        switch ($receiver.getLegalIdentities().size()) {
            case 1: {
                party = (Party)$receiver.getLegalIdentities().get(0);
                break;
            }
            case 2: {
                party = (Party)$receiver.getLegalIdentities().get(1);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Not sure how to get the notary identity in this scenario: " + $receiver);
            }
        }
        return party;
    }

    private final void initialiseSerialization() {
        SerializationFactoryImpl serializationFactoryImpl = new SerializationFactoryImpl();
        SerializationEnvironment.Companion companion = SerializationEnvironment.Companion;
        ThreadLocalToggleField threadLocalToggleField = SerializationEnvironmentKt.get_contextSerializationEnv();
        SerializationFactoryImpl $receiver = serializationFactoryImpl;
        $receiver.registerScheme((SerializationScheme)AMQPParametersSerializationScheme.INSTANCE);
        SerializationFactoryImpl serializationFactoryImpl2 = serializationFactoryImpl;
        threadLocalToggleField.set((Object)SerializationEnvironment.Companion.with$default((SerializationEnvironment.Companion)companion, (SerializationFactory)((SerializationFactory)serializationFactoryImpl2), (SerializationContext)((SerializationContext)SharedContexts.getAMQP_P2P_CONTEXT()), null, null, null, null, null, (int)124, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean isSigned(Path file) {
        boolean bl;
        void $receiver$iv;
        Path path = file;
        OpenOption[] options$iv = new OpenOption[]{};
        Closeable closeable = PathUtilsKt.inputStream((Path)$receiver$iv, (OpenOption[])Arrays.copyOf(options$iv, options$iv.length));
        Throwable throwable = null;
        try {
            boolean bl2;
            InputStream it = (InputStream)closeable;
            Closeable closeable2 = new JarInputStream(it);
            Throwable throwable2 = null;
            try {
                JarInputStream it2 = (JarInputStream)closeable2;
                Collection collection = JarSignatureCollector.INSTANCE.collectSigningParties(it2);
                bl2 = !collection.isEmpty();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            bl = bl2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    public NetworkBootstrapper(boolean initSerEnv, @NotNull Function0<? extends InputStream> embeddedCordaJar, @NotNull Function1<? super List<? extends Path>, ? extends List<? extends Path>> nodeInfosGenerator, @NotNull Function1<? super Path, ? extends ContractsJar> contractsJarConverter) {
        Intrinsics.checkParameterIsNotNull(embeddedCordaJar, (String)"embeddedCordaJar");
        Intrinsics.checkParameterIsNotNull(nodeInfosGenerator, (String)"nodeInfosGenerator");
        Intrinsics.checkParameterIsNotNull(contractsJarConverter, (String)"contractsJarConverter");
        this.initSerEnv = initSerEnv;
        this.embeddedCordaJar = embeddedCordaJar;
        this.nodeInfosGenerator = nodeInfosGenerator;
        this.contractsJarConverter = contractsJarConverter;
    }

    public NetworkBootstrapper() {
        this(true, (Function0<? extends InputStream>)((Function0)new Function0<InputStream>(Companion){

            @NotNull
            public final InputStream invoke() {
                return ((Companion)this.receiver).extractEmbeddedCordaJar();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Companion.class);
            }

            public final String getName() {
                return "extractEmbeddedCordaJar";
            }

            public final String getSignature() {
                return "extractEmbeddedCordaJar()Ljava/io/InputStream;";
            }
        }), (Function1<? super List<? extends Path>, ? extends List<? extends Path>>)((Function1)new Function1<List<? extends Path>, List<? extends Path>>(Companion){

            @NotNull
            public final List<Path> invoke(@NotNull List<? extends Path> p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                return ((Companion)this.receiver).generateNodeInfos(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Companion.class);
            }

            public final String getName() {
                return "generateNodeInfos";
            }

            public final String getSignature() {
                return "generateNodeInfos(Ljava/util/List;)Ljava/util/List;";
            }
        }), (Function1<? super Path, ? extends ContractsJar>)((Function1)3.INSTANCE));
    }

    static {
        Companion = new Companion(null);
        nodeInfoGenCmd = CollectionsKt.listOf((Object[])new String[]{"java", "-jar", "corda.jar", "generate-node-info"});
        jarsThatArentCordapps = SetsKt.setOf((Object[])new String[]{"corda.jar", "runnodes.jar"});
    }

    @NotNull
    public static final /* synthetic */ Set access$getJarsThatArentCordapps$cp() {
        return jarsThatArentCordapps;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$NotaryCluster;", "", "()V", "BFT", "CFT", "Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$NotaryCluster$BFT;", "Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$NotaryCluster$CFT;", "node-api"})
    public static abstract class NotaryCluster {
        private NotaryCluster() {
        }

        public /* synthetic */ NotaryCluster(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$NotaryCluster$BFT;", "Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$NotaryCluster;", "name", "Lnet/corda/core/identity/CordaX500Name;", "(Lnet/corda/core/identity/CordaX500Name;)V", "getName", "()Lnet/corda/core/identity/CordaX500Name;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "node-api"})
        public static final class BFT
        extends NotaryCluster {
            @NotNull
            private final CordaX500Name name;

            @NotNull
            public final CordaX500Name getName() {
                return this.name;
            }

            public BFT(@NotNull CordaX500Name name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                super(null);
                this.name = name;
            }

            @NotNull
            public final CordaX500Name component1() {
                return this.name;
            }

            @NotNull
            public final BFT copy(@NotNull CordaX500Name name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return new BFT(name);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ BFT copy$default(BFT bFT, CordaX500Name cordaX500Name, int n, Object object) {
                if ((n & 1) != 0) {
                    cordaX500Name = bFT.name;
                }
                return bFT.copy(cordaX500Name);
            }

            @NotNull
            public String toString() {
                return "BFT(name=" + this.name + ")";
            }

            public int hashCode() {
                CordaX500Name cordaX500Name = this.name;
                return cordaX500Name != null ? cordaX500Name.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof BFT)) break block3;
                        BFT bFT = (BFT)object;
                        if (!Intrinsics.areEqual((Object)this.name, (Object)bFT.name)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$NotaryCluster$CFT;", "Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$NotaryCluster;", "name", "Lnet/corda/core/identity/CordaX500Name;", "(Lnet/corda/core/identity/CordaX500Name;)V", "getName", "()Lnet/corda/core/identity/CordaX500Name;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "node-api"})
        public static final class CFT
        extends NotaryCluster {
            @NotNull
            private final CordaX500Name name;

            @NotNull
            public final CordaX500Name getName() {
                return this.name;
            }

            public CFT(@NotNull CordaX500Name name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                super(null);
                this.name = name;
            }

            @NotNull
            public final CordaX500Name component1() {
                return this.name;
            }

            @NotNull
            public final CFT copy(@NotNull CordaX500Name name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return new CFT(name);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CFT copy$default(CFT cFT, CordaX500Name cordaX500Name, int n, Object object) {
                if ((n & 1) != 0) {
                    cordaX500Name = cFT.name;
                }
                return cFT.copy(cordaX500Name);
            }

            @NotNull
            public String toString() {
                return "CFT(name=" + this.name + ")";
            }

            public int hashCode() {
                CordaX500Name cordaX500Name = this.name;
                return cordaX500Name != null ? cordaX500Name.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CFT)) break block3;
                        CFT cFT = (CFT)object;
                        if (!Intrinsics.areEqual((Object)this.name, (Object)cFT.name)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$DirectoryAndConfig;", "", "directory", "Ljava/nio/file/Path;", "config", "Lcom/typesafe/config/Config;", "(Ljava/nio/file/Path;Lcom/typesafe/config/Config;)V", "getConfig", "()Lcom/typesafe/config/Config;", "getDirectory", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "node-api"})
    public static final class DirectoryAndConfig {
        @NotNull
        private final Path directory;
        @NotNull
        private final Config config;

        @NotNull
        public final Path getDirectory() {
            return this.directory;
        }

        @NotNull
        public final Config getConfig() {
            return this.config;
        }

        public DirectoryAndConfig(@NotNull Path directory, @NotNull Config config) {
            Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            this.directory = directory;
            this.config = config;
        }

        @NotNull
        public final Path component1() {
            return this.directory;
        }

        @NotNull
        public final Config component2() {
            return this.config;
        }

        @NotNull
        public final DirectoryAndConfig copy(@NotNull Path directory, @NotNull Config config) {
            Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            return new DirectoryAndConfig(directory, config);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DirectoryAndConfig copy$default(DirectoryAndConfig directoryAndConfig, Path path, Config config, int n, Object object) {
            if ((n & 1) != 0) {
                path = directoryAndConfig.directory;
            }
            if ((n & 2) != 0) {
                config = directoryAndConfig.config;
            }
            return directoryAndConfig.copy(path, config);
        }

        @NotNull
        public String toString() {
            return "DirectoryAndConfig(directory=" + this.directory + ", config=" + this.config + ")";
        }

        public int hashCode() {
            Path path = this.directory;
            Config config = this.config;
            return (path != null ? ((Object)path).hashCode() : 0) * 31 + (config != null ? config.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DirectoryAndConfig)) break block3;
                    DirectoryAndConfig directoryAndConfig = (DirectoryAndConfig)object;
                    if (!Intrinsics.areEqual((Object)this.directory, (Object)directoryAndConfig.directory) || !Intrinsics.areEqual((Object)this.config, (Object)directoryAndConfig.config)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$AMQPParametersSerializationScheme;", "Lnet/corda/serialization/internal/amqp/AbstractAMQPSerializationScheme;", "()V", "canDeserializeVersion", "", "magic", "Lnet/corda/serialization/internal/CordaSerializationMagic;", "target", "Lnet/corda/core/serialization/SerializationContext$UseCase;", "rpcClientSerializerFactory", "", "context", "Lnet/corda/core/serialization/SerializationContext;", "rpcServerSerializerFactory", "node-api"})
    private static final class AMQPParametersSerializationScheme
    extends AbstractAMQPSerializationScheme {
        public static final AMQPParametersSerializationScheme INSTANCE;

        @NotNull
        protected Void rpcClientSerializerFactory(@NotNull SerializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            throw (Throwable)new UnsupportedOperationException();
        }

        @NotNull
        protected Void rpcServerSerializerFactory(@NotNull SerializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            throw (Throwable)new UnsupportedOperationException();
        }

        public boolean canDeserializeVersion(@NotNull CordaSerializationMagic magic, @NotNull SerializationContext.UseCase target) {
            Intrinsics.checkParameterIsNotNull((Object)magic, (String)"magic");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            return Intrinsics.areEqual((Object)magic, (Object)SchemaKt.getAmqpMagic()) && target == SerializationContext.UseCase.P2P;
        }

        private AMQPParametersSerializationScheme() {
            super(CollectionsKt.emptyList());
        }

        static {
            AMQPParametersSerializationScheme aMQPParametersSerializationScheme;
            INSTANCE = aMQPParametersSerializationScheme = new AMQPParametersSerializationScheme();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkBootstrapper$Companion;", "", "()V", "DEFAULT_MAX_MESSAGE_SIZE", "", "DEFAULT_MAX_TRANSACTION_SIZE", "LOGS_DIR_NAME", "", "jarsThatArentCordapps", "", "nodeInfoGenCmd", "", "extractEmbeddedCordaJar", "Ljava/io/InputStream;", "generateNodeInfo", "Ljava/nio/file/Path;", "nodeDir", "generateNodeInfos", "nodeDirs", "printNodeInfoGenLogToConsole", "", "nodeInfoGenFile", "Ljava/io/File;", "check", "Lkotlin/Function0;", "", "node-api"})
    public static final class Companion {
        private final InputStream extractEmbeddedCordaJar() {
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            InputStream inputStream = thread.getContextClassLoader().getResourceAsStream("corda.jar");
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Thread.currentThread().c\u2026urceAsStream(\"corda.jar\")");
            return inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final List<Path> generateNodeInfos(List<? extends Path> nodeDirs) {
            List list2;
            int numParallelProcesses = Runtime.getRuntime().availableProcessors();
            Duration timePerNode = KotlinUtilsKt.getSeconds((int)40);
            Duration tExpected = (Duration)ComparisonsKt.maxOf((Comparable)timePerNode, (Comparable)InternalUtils.div((Duration)InternalUtils.times((Duration)timePerNode, (long)nodeDirs.size()), (long)numParallelProcesses));
            Timer timer = new Timer("WarnOnSlowMachines", true);
            long l = tExpected.toMillis();
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    TimerTask $receiver = this;
                    String string = "... still waiting. If this is taking longer than usual, check the node logs.";
                    System.out.println((Object)string);
                }
            };
            timer.schedule(timerTask, l);
            TimerTask warningTimer = timerTask;
            ExecutorService executor = Executors.newFixedThreadPool(numParallelProcesses);
            try {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)nodeDirs;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    ExecutorService executorService = executor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
                    CordaFuture cordaFuture = CordaFutureImplKt.fork((Executor)executorService, (Function0)((Function0)new Function0<Path>((Path)it){
                        final /* synthetic */ Path $it;

                        @NotNull
                        public final Path invoke() {
                            return net.corda.nodeapi.internal.network.NetworkBootstrapper$Companion.access$generateNodeInfo(NetworkBootstrapper.Companion, this.$it);
                        }
                        {
                            this.$it = path;
                            super(0);
                        }
                    }));
                    collection.add(cordaFuture);
                }
                list2 = (List)KotlinUtilsKt.getOrThrow$default((Future)((Future)CordaFutureImplKt.transpose((Collection)((List)destination$iv$iv))), null, (int)1, null);
            }
            finally {
                warningTimer.cancel();
                executor.shutdownNow();
            }
            return list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Path generateNodeInfo(Path nodeDir) {
            Object object;
            ProcessBuilder processBuilder;
            Path logsDir = PathUtilsKt.createDirectories((Path)PathUtilsKt.div((Path)nodeDir, (String)NetworkBootstrapper.LOGS_DIR_NAME), (FileAttribute[])new FileAttribute[0]);
            File nodeInfoGenFile = PathUtilsKt.div((Path)logsDir, (String)"node-info-gen.log").toFile();
            ProcessBuilder $receiver = processBuilder = new ProcessBuilder(nodeInfoGenCmd).directory(nodeDir.toFile()).redirectErrorStream(true).redirectOutput(nodeInfoGenFile);
            Map<String, String> map = $receiver.environment();
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"environment()");
            Object object2 = map;
            Object object3 = "CAPSULE_CACHE_DIR";
            String string = "../.cache";
            object2.put((String)object3, (String)string);
            Process process = processBuilder.start();
            if (!process.waitFor(3L, TimeUnit.MINUTES)) {
                process.destroyForcibly();
                File file = nodeInfoGenFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"nodeInfoGenFile");
                net.corda.nodeapi.internal.network.NetworkBootstrapper$Companion.printNodeInfoGenLogToConsole$default(this, file, null, 2, null);
            }
            File file = nodeInfoGenFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"nodeInfoGenFile");
            this.printNodeInfoGenLogToConsole(file, (Function0<Boolean>)((Function0)new Function0<Boolean>(process){
                final /* synthetic */ Process $process;

                public final boolean invoke() {
                    return this.$process.exitValue() == 0;
                }
                {
                    this.$process = process;
                    super(0);
                }
            }));
            Path $receiver$iv = nodeDir;
            AutoCloseable autoCloseable = Files.list($receiver$iv);
            object2 = null;
            try {
                Stream paths = (Stream)autoCloseable;
                Object t = paths.filter(generateNodeInfo.2.1.INSTANCE).findFirst().get();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"paths.filter { it.fileNa\u2026EFIX) }.findFirst().get()");
                object3 = (Path)t;
                object = object3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object2);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeDir.list { paths ->\n\u2026rst().get()\n            }");
            return object;
        }

        private final void printNodeInfoGenLogToConsole(File nodeInfoGenFile, Function0<Boolean> check) {
            if (!((Boolean)check.invoke()).booleanValue()) {
                Object object;
                String nodeDir = nodeInfoGenFile.getParent();
                try {
                    String string = nodeDir;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nodeDir");
                    object = ConfigFactory.parseFile((File)PathUtilsKt.div((String)string, (String)"node.conf").toFile()).getString("myLegalName");
                }
                catch (ConfigException e) {
                    object = nodeDir;
                }
                String nodeIdentifier = object;
                System.err.println("#### Error while generating node info file " + nodeIdentifier + " ####");
                object = nodeInfoGenFile;
                InputStream inputStream = new FileInputStream((File)object);
                PrintStream printStream = System.err;
                Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.err");
                ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)printStream, (int)0, (int)2, null);
                throw (Throwable)new IllegalStateException("Error while generating node info file. Please check the logs in " + nodeDir + '.');
            }
        }

        static /* bridge */ /* synthetic */ void printNodeInfoGenLogToConsole$default(Companion companion, File file, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                function0 = printNodeInfoGenLogToConsole.1.INSTANCE;
            }
            companion.printNodeInfoGenLogToConsole(file, (Function0<Boolean>)function0);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Path access$generateNodeInfo(Companion $this, @NotNull Path nodeDir) {
            return $this.generateNodeInfo(nodeDir);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

