/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.core.crypto.SecureHash;
import net.corda.core.serialization.CordaSerializable;
import net.corda.nodeapi.internal.network.ParametersUpdate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J/\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lnet/corda/nodeapi/internal/network/NetworkMap;", "", "nodeInfoHashes", "", "Lnet/corda/core/crypto/SecureHash;", "networkParameterHash", "parametersUpdate", "Lnet/corda/nodeapi/internal/network/ParametersUpdate;", "(Ljava/util/List;Lnet/corda/core/crypto/SecureHash;Lnet/corda/nodeapi/internal/network/ParametersUpdate;)V", "getNetworkParameterHash", "()Lnet/corda/core/crypto/SecureHash;", "getNodeInfoHashes", "()Ljava/util/List;", "getParametersUpdate", "()Lnet/corda/nodeapi/internal/network/ParametersUpdate;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "node-api"})
public final class NetworkMap {
    @NotNull
    private final List<SecureHash> nodeInfoHashes;
    @NotNull
    private final SecureHash networkParameterHash;
    @Nullable
    private final ParametersUpdate parametersUpdate;

    @NotNull
    public String toString() {
        return "NetworkMap {\n  nodeInfoHashes {\n    " + SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)this.nodeInfoHashes), (int)10), (CharSequence)"\n    ", null, null, (int)0, null, null, (int)62, null) + "\n    " + (this.nodeInfoHashes.size() > 10 ? "... " + (this.nodeInfoHashes.size() - 10) + " more" : "") + "\n  }\n  networkParameterHash=" + this.networkParameterHash + "\n  parametersUpdate=" + this.parametersUpdate + "\n}";
    }

    @NotNull
    public final List<SecureHash> getNodeInfoHashes() {
        return this.nodeInfoHashes;
    }

    @NotNull
    public final SecureHash getNetworkParameterHash() {
        return this.networkParameterHash;
    }

    @Nullable
    public final ParametersUpdate getParametersUpdate() {
        return this.parametersUpdate;
    }

    public NetworkMap(@NotNull List<? extends SecureHash> nodeInfoHashes, @NotNull SecureHash networkParameterHash, @Nullable ParametersUpdate parametersUpdate) {
        Intrinsics.checkParameterIsNotNull(nodeInfoHashes, (String)"nodeInfoHashes");
        Intrinsics.checkParameterIsNotNull((Object)networkParameterHash, (String)"networkParameterHash");
        this.nodeInfoHashes = nodeInfoHashes;
        this.networkParameterHash = networkParameterHash;
        this.parametersUpdate = parametersUpdate;
    }

    @NotNull
    public final List<SecureHash> component1() {
        return this.nodeInfoHashes;
    }

    @NotNull
    public final SecureHash component2() {
        return this.networkParameterHash;
    }

    @Nullable
    public final ParametersUpdate component3() {
        return this.parametersUpdate;
    }

    @NotNull
    public final NetworkMap copy(@NotNull List<? extends SecureHash> nodeInfoHashes, @NotNull SecureHash networkParameterHash, @Nullable ParametersUpdate parametersUpdate) {
        Intrinsics.checkParameterIsNotNull(nodeInfoHashes, (String)"nodeInfoHashes");
        Intrinsics.checkParameterIsNotNull((Object)networkParameterHash, (String)"networkParameterHash");
        return new NetworkMap(nodeInfoHashes, networkParameterHash, parametersUpdate);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ NetworkMap copy$default(NetworkMap networkMap, List list2, SecureHash secureHash, ParametersUpdate parametersUpdate, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = networkMap.nodeInfoHashes;
        }
        if ((n & 2) != 0) {
            secureHash = networkMap.networkParameterHash;
        }
        if ((n & 4) != 0) {
            parametersUpdate = networkMap.parametersUpdate;
        }
        return networkMap.copy(list2, secureHash, parametersUpdate);
    }

    public int hashCode() {
        List<SecureHash> list2 = this.nodeInfoHashes;
        SecureHash secureHash = this.networkParameterHash;
        ParametersUpdate parametersUpdate = this.parametersUpdate;
        return ((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (secureHash != null ? secureHash.hashCode() : 0)) * 31 + (parametersUpdate != null ? ((Object)parametersUpdate).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof NetworkMap)) break block3;
                NetworkMap networkMap = (NetworkMap)object;
                if (!Intrinsics.areEqual(this.nodeInfoHashes, networkMap.nodeInfoHashes) || !Intrinsics.areEqual((Object)this.networkParameterHash, (Object)networkMap.networkParameterHash) || !Intrinsics.areEqual((Object)this.parametersUpdate, (Object)networkMap.parametersUpdate)) break block3;
            }
            return true;
        }
        return false;
    }
}

