/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.CertRole;
import net.corda.core.internal.SignedDataWithCert;
import net.corda.nodeapi.internal.crypto.X509Utilities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a;\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a'\u0010\r\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000e\u001a'\u0010\u000f\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000*\u0016\u0010\u0010\"\b\u0012\u0004\u0012\u00020\u00110\u00062\b\u0012\u0004\u0012\u00020\u00110\u0006*\u0016\u0010\u0012\"\b\u0012\u0004\u0012\u00020\u00130\u00062\b\u0012\u0004\u0012\u00020\u00130\u0006\u00a8\u0006\u0014"}, d2={"NETWORK_PARAMS_FILE_NAME", "", "NETWORK_PARAMS_UPDATE_FILE_NAME", "verifiedCertWithRole", "T", "", "Lnet/corda/core/internal/SignedDataWithCert;", "rootCert", "Ljava/security/cert/X509Certificate;", "certRoles", "", "Lnet/corda/core/internal/CertRole;", "(Lnet/corda/core/internal/SignedDataWithCert;Ljava/security/cert/X509Certificate;[Lnet/corda/core/internal/CertRole;)Ljava/lang/Object;", "verifiedNetworkMapCert", "(Lnet/corda/core/internal/SignedDataWithCert;Ljava/security/cert/X509Certificate;)Ljava/lang/Object;", "verifiedNetworkParametersCert", "SignedNetworkMap", "Lnet/corda/nodeapi/internal/network/NetworkMap;", "SignedNetworkParameters", "Lnet/corda/core/node/NetworkParameters;", "node-api"})
public final class NetworkMapKt {
    @NotNull
    public static final String NETWORK_PARAMS_FILE_NAME = "network-parameters";
    @NotNull
    public static final String NETWORK_PARAMS_UPDATE_FILE_NAME = "network-parameters-update";

    @NotNull
    public static final <T> T verifiedCertWithRole(@NotNull SignedDataWithCert<T> $receiver, @NotNull X509Certificate rootCert, CertRole ... certRoles) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)rootCert, (String)"rootCert");
        Intrinsics.checkParameterIsNotNull((Object)certRoles, (String)"certRoles");
        boolean bl = ArraysKt.contains((Object[])certRoles, (Object)CertRole.Companion.extract($receiver.getSig().getBy()));
        if (!bl) {
            String string = "Incorrect cert role: " + CertRole.Companion.extract($receiver.getSig().getBy());
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List path = $receiver.getSig().getParentCertsChain().isEmpty() ? CollectionsKt.listOf((Object[])new X509Certificate[]{$receiver.getSig().getBy(), rootCert}) : $receiver.getSig().getFullCertChain();
        X509Utilities.INSTANCE.validateCertificateChain(rootCert, path);
        return (T)$receiver.verified();
    }

    @NotNull
    public static final <T> T verifiedNetworkMapCert(@NotNull SignedDataWithCert<T> $receiver, @NotNull X509Certificate rootCert) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)rootCert, (String)"rootCert");
        return NetworkMapKt.verifiedCertWithRole($receiver, rootCert, CertRole.NETWORK_MAP);
    }

    @NotNull
    public static final <T> T verifiedNetworkParametersCert(@NotNull SignedDataWithCert<T> $receiver, @NotNull X509Certificate rootCert) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)rootCert, (String)"rootCert");
        return NetworkMapKt.verifiedCertWithRole($receiver, rootCert, CertRole.NETWORK_PARAMETERS, CertRole.NETWORK_MAP);
    }
}

