/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.network;

import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.corda.core.crypto.SecureHash;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.node.NetworkParameters;
import net.corda.nodeapi.internal.ContractsJar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aJ\u0010\u0005\u001a\u001c\u0012\b\u0012\u00060\u0001j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u00070\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"EXCLUDE_WHITELIST_FILE_NAME", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "generateWhitelist", "", "Lnet/corda/core/contracts/ContractClassName;", "", "Lnet/corda/core/crypto/SecureHash;", "Lnet/corda/core/node/services/AttachmentId;", "networkParameters", "Lnet/corda/core/node/NetworkParameters;", "excludeContracts", "cordappJars", "Lnet/corda/nodeapi/internal/ContractsJar;", "readExcludeWhitelist", "directory", "Ljava/nio/file/Path;", "node-api"})
public final class WhitelistGeneratorKt {
    private static final String EXCLUDE_WHITELIST_FILE_NAME = "exclude_whitelist.txt";
    private static final Logger logger = LoggerFactory.getLogger((String)"net.corda.nodeapi.internal.network.WhitelistGenerator");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<SecureHash>> generateWhitelist(@Nullable NetworkParameters networkParameters, @NotNull List<String> excludeContracts, @NotNull List<? extends ContractsJar> cordappJars) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Object element$iv2;
        Intrinsics.checkParameterIsNotNull(excludeContracts, (String)"excludeContracts");
        Intrinsics.checkParameterIsNotNull(cordappJars, (String)"cordappJars");
        Object object = networkParameters;
        if (object == null || (object = object.getWhitelistedContractImplementations()) == null) {
            object = MapsKt.emptyMap();
        }
        Object existingWhitelist = object;
        Collection collection = excludeContracts;
        if (!collection.isEmpty()) {
            logger.info("Exclude contracts from whitelist: " + CollectionsKt.joinToString$default((Iterable)excludeContracts, null, null, null, (int)0, null, null, (int)63, null));
            Iterable $receiver$iv3 = existingWhitelist.keySet();
            for (Object element$iv2 : $receiver$iv3) {
                String it = (String)element$iv2;
                boolean bl = !excludeContracts.contains(it);
                if (bl) continue;
                String string = it + " is already part of the existing whitelist and cannot be excluded.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        Iterable iterable = cordappJars;
        element$iv2 = $receiver$iv2;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            void $receiver$iv$iv3;
            ContractsJar jar = (ContractsJar)element$iv$iv;
            $receiver$iv = CollectionsKt.minus((Iterable)jar.scan(), (Iterable)excludeContracts);
            Iterable $i$f$forEach = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv3) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                Pair pair = TuplesKt.to((Object)it, (Object)jar.getHash());
                collection2.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Map newWhiteList = InternalUtils.toMultiMap((Iterable)((List)destination$iv$iv));
        $receiver$iv2 = SetsKt.plus(newWhiteList.keySet(), (Iterable)existingWhitelist.keySet());
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            List list2;
            List existingHashes;
            String it;
            $receiver$iv = (String)element$iv$iv;
            Map map = destination$iv$iv3;
            void var27_24 = it;
            it = (String)element$iv$iv;
            List list3 = (List)existingWhitelist.get(it);
            if (list3 == null) {
                list3 = existingHashes = CollectionsKt.emptyList();
            }
            if ((list2 = (List)newWhiteList.get(it)) == null) {
                list2 = CollectionsKt.emptyList();
            }
            List newHashes = list2;
            List list4 = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)existingHashes, (Iterable)newHashes));
            map.put(var27_24, list4);
        }
        return destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> readExcludeWhitelist(@NotNull Path directory) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Path file = PathUtilsKt.div((Path)directory, (String)EXCLUDE_WHITELIST_FILE_NAME);
        if (PathUtilsKt.exists((Path)file, (LinkOption[])new LinkOption[0])) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)PathUtilsKt.readAllLines$default((Path)file, null, (int)1, null);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                void var8_8;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v0 = var8_8 = p1;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                collection.add(string2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }
}

