/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.MigrationHelpers;
import net.corda.nodeapi.internal.cordapp.CordappLoader;
import net.corda.nodeapi.internal.persistence.CheckpointsException;
import net.corda.nodeapi.internal.persistence.DatabaseConfig;
import net.corda.nodeapi.internal.persistence.MissingMigrationException;
import net.corda.nodeapi.internal.persistence.OutstandingDatabaseChangesException;
import net.corda.nodeapi.internal.persistence.SchemaMigration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0002&'BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J)\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001bJ\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001bH\u0002R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lnet/corda/nodeapi/internal/persistence/SchemaMigration;", "", "schemas", "", "Lnet/corda/core/schemas/MappedSchema;", "dataSource", "Ljavax/sql/DataSource;", "databaseConfig", "Lnet/corda/nodeapi/internal/persistence/DatabaseConfig;", "cordappLoader", "Lnet/corda/nodeapi/internal/cordapp/CordappLoader;", "currentDirectory", "Ljava/nio/file/Path;", "ourName", "Lnet/corda/core/identity/CordaX500Name;", "(Ljava/util/Set;Ljavax/sql/DataSource;Lnet/corda/nodeapi/internal/persistence/DatabaseConfig;Lnet/corda/nodeapi/internal/cordapp/CordappLoader;Ljava/nio/file/Path;Lnet/corda/core/identity/CordaX500Name;)V", "classLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "getDataSource", "()Ljavax/sql/DataSource;", "getSchemas", "()Ljava/util/Set;", "checkState", "", "doRunMigration", "run", "", "check", "existingCheckpoints", "(ZZLjava/lang/Boolean;)V", "getLiquibaseDatabase", "Lliquibase/database/Database;", "conn", "Lliquibase/database/jvm/JdbcConnection;", "migrateOlderDatabaseToUseLiquibase", "nodeStartup", "runMigration", "Companion", "CustomResourceAccessor", "node-api"})
public final class SchemaMigration {
    private final ClassLoader classLoader;
    @NotNull
    private final Set<MappedSchema> schemas;
    @NotNull
    private final DataSource dataSource;
    private final DatabaseConfig databaseConfig;
    private final Path currentDirectory;
    private final CordaX500Name ourName;
    private static final Logger logger;
    @NotNull
    public static final String NODE_BASE_DIR_KEY = "liquibase.nodeDaseDir";
    @NotNull
    public static final String NODE_X500_NAME = "liquibase.nodeName";
    @NotNull
    private static final ThreadLocal<CordappLoader> loader;
    public static final Companion Companion;

    public final void nodeStartup(boolean existingCheckpoints) {
        if (this.databaseConfig.getInitialiseSchema()) {
            this.migrateOlderDatabaseToUseLiquibase(existingCheckpoints);
            this.runMigration(existingCheckpoints);
        } else {
            this.checkState();
        }
    }

    private final void runMigration(boolean existingCheckpoints) {
        this.doRunMigration(true, false, existingCheckpoints);
    }

    private final void checkState() {
        SchemaMigration.doRunMigration$default(this, false, true, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doRunMigration(boolean run, boolean check, Boolean existingCheckpoints) {
        String dynamicInclude = "master.changelog.json";
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Collection collection;
            String path;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Connection connection2 = (Connection)autoCloseable;
            Iterable iterable = $receiver$iv = (Iterable)this.schemas;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string;
                void mappedSchema;
                MappedSchema mappedSchema2 = (MappedSchema)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                ClassLoader classLoader = this.classLoader;
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"classLoader");
                String resource = MigrationHelpers.INSTANCE.getMigrationResource((MappedSchema)mappedSchema, classLoader);
                if (resource != null) {
                    string = resource;
                } else if ((Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(mappedSchema.getClass()).getQualifiedName(), (Object)"net.corda.finance.schemas.CashSchemaV1") || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(mappedSchema.getClass()).getQualifiedName(), (Object)"net.corda.finance.schemas.CommercialPaperSchemaV1")) && mappedSchema.getMigrationResource() == null) {
                    string = null;
                } else {
                    throw (Throwable)new MissingMigrationException((MappedSchema)mappedSchema);
                }
                String string2 = string;
                collection2.add(string2);
            }
            List changelogList = (List)destination$iv$iv;
            Path path2 = this.currentDirectory;
            String string = path = path2 != null ? ((Object)path2).toString() : null;
            if (path != null) {
                System.setProperty(NODE_BASE_DIR_KEY, path);
            }
            System.setProperty(NODE_X500_NAME, this.ourName.toString());
            ClassLoader classLoader = this.classLoader;
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"classLoader");
            CustomResourceAccessor customResourceAccessor = new CustomResourceAccessor(dynamicInclude, changelogList, classLoader);
            Liquibase liquibase = new Liquibase(dynamicInclude, (ResourceAccessor)customResourceAccessor, this.getLiquibaseDatabase(new JdbcConnection(connection2)));
            List unRunChanges = liquibase.listUnrunChangeSets(new Contexts(), new LabelExpression());
            if (run && !check) {
                List list2 = unRunChanges;
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"unRunChanges");
                collection = list2;
                if (!collection.isEmpty()) {
                    Boolean bl = existingCheckpoints;
                    if (bl == null) {
                        Intrinsics.throwNpe();
                    }
                    if (bl.booleanValue()) {
                        throw (Throwable)new CheckpointsException();
                    }
                }
            }
            if (run && !check) {
                liquibase.update(new Contexts());
            } else {
                if (check && !run) {
                    List list3 = unRunChanges;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"unRunChanges");
                    collection = list3;
                    if (!collection.isEmpty()) {
                        throw (Throwable)new OutstandingDatabaseChangesException(unRunChanges.size());
                    }
                }
                if (!check || run) {
                    throw (Throwable)new IllegalStateException("Invalid usage.");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static /* bridge */ /* synthetic */ void doRunMigration$default(SchemaMigration schemaMigration, boolean bl, boolean bl2, Boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl3 = null;
        }
        schemaMigration.doRunMigration(bl, bl2, bl3);
    }

    private final Database getLiquibaseDatabase(JdbcConnection conn) {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)conn);
        Intrinsics.checkExpressionValueIsNotNull((Object)database, (String)"DatabaseFactory.getInsta\u2026abaseImplementation(conn)");
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean migrateOlderDatabaseToUseLiquibase(boolean existingCheckpoints) {
        block37: {
            $receiver$iv = this.schemas;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $receiver$iv) {
                    schema /* !! */  = (MappedSchema)element$iv;
                    if (!((Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(schema /* !! */ .getClass()).getQualifiedName(), (Object)"net.corda.finance.schemas.CashSchemaV1") != false || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(schema /* !! */ .getClass()).getQualifiedName(), (Object)"net.corda.finance.schemas.CommercialPaperSchemaV1") != false) && schema /* !! */ .getMigrationResource() != null)) continue;
                    v0 = true;
                    break block37;
                }
                v0 = false;
            }
        }
        isFinanceAppWithLiquibase = v0;
        noLiquibaseEntryLogForFinanceApp = migrateOlderDatabaseToUseLiquibase.noLiquibaseEntryLogForFinanceApp.1.INSTANCE;
        $i$a$1$any = this.dataSource.getConnection();
        var8_10 = null;
        try {
            v1 = it = (Connection)$i$a$1$any;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            existingDatabase = v1.getMetaData().getTables(null, null, "NODE%", null).next();
            hasLiquibase = it.getMetaData().getTables(null, null, "DATABASECHANGELOG%", null).next();
            if (!isFinanceAppWithLiquibase || !existingDatabase) ** GOTO lbl-1000
            if (!hasLiquibase) ** GOTO lbl-1000
            if (hasLiquibase) {
                var12_23 = it.createStatement();
                var13_24 = null;
                try {
                    v2 = it = (Statement)var12_23;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    var14_26 = (Boolean)noLiquibaseEntryLogForFinanceApp.invoke((Object)v2);
                }
                catch (Throwable var14_27) {
                    var13_24 = var14_27;
                    throw var14_27;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)var12_23, (Throwable)var13_24);
                }
                ** if (!var14_26) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v3 = true;
                ** GOTO lbl45
            }
lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
lbl45:
            // 2 sources

            isFinanceAppWithLiquibaseNotMigrated = v3;
            it = new Pair((Object)(existingDatabase != false && hasLiquibase == false), (Object)isFinanceAppWithLiquibaseNotMigrated);
        }
        catch (Throwable it) {
            var8_10 = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$i$a$1$any, (Throwable)var8_10);
        }
        schema /* !! */  = it;
        var4_4 = (Boolean)schema /* !! */ .component1();
        isFinanceAppWithLiquibaseNotMigrated = (Boolean)schema /* !! */ .component2();
        if (isExistingDBWithoutLiquibase != false && existingCheckpoints) {
            throw (Throwable)new CheckpointsException();
        }
        preV4Baseline = new ArrayList<E>();
        if (isExistingDBWithoutLiquibase != false) {
            block42: {
                block41: {
                    block40: {
                        preV4Baseline.addAll(CollectionsKt.listOf((Object[])new String[]{"migration/common.changelog-init.xml", "migration/node-info.changelog-init.xml", "migration/node-info.changelog-v1.xml", "migration/node-info.changelog-v2.xml", "migration/node-core.changelog-init.xml", "migration/node-core.changelog-v3.xml", "migration/node-core.changelog-v4.xml", "migration/node-core.changelog-v5.xml", "migration/node-core.changelog-pkey.xml", "migration/vault-schema.changelog-init.xml", "migration/vault-schema.changelog-v3.xml", "migration/vault-schema.changelog-v4.xml", "migration/vault-schema.changelog-pkey.xml"}));
                        $receiver$iv = this.schemas;
                        if ($receiver$iv instanceof Collection && $receiver$iv.isEmpty()) {
                            v4 = false;
                        } else {
                            for (E element$iv : $receiver$iv) {
                                schema = (MappedSchema)element$iv;
                                if (!Intrinsics.areEqual((Object)schema.getMigrationResource(), (Object)"node-notary.changelog-master")) continue;
                                v4 = true;
                                break block40;
                            }
                            v4 = false;
                        }
                    }
                    if (v4) {
                        preV4Baseline.addAll(CollectionsKt.listOf((Object[])new String[]{"migration/node-notary.changelog-init.xml", "migration/node-notary.changelog-v1.xml"}));
                    }
                    if (($receiver$iv = (Iterable)this.schemas) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        v5 = false;
                    } else {
                        for (E element$iv : $receiver$iv) {
                            schema = (MappedSchema)element$iv;
                            if (!Intrinsics.areEqual((Object)schema.getMigrationResource(), (Object)"notary-raft.changelog-master")) continue;
                            v5 = true;
                            break block41;
                        }
                        v5 = false;
                    }
                }
                if (v5) {
                    preV4Baseline.addAll(CollectionsKt.listOf((Object[])new String[]{"migration/notary-raft.changelog-init.xml", "migration/notary-raft.changelog-v1.xml"}));
                }
                if (($receiver$iv = (Iterable)this.schemas) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v6 = false;
                } else {
                    for (E element$iv : $receiver$iv) {
                        schema = (MappedSchema)element$iv;
                        if (!Intrinsics.areEqual((Object)schema.getMigrationResource(), (Object)"notary-bft-smart.changelog-master")) continue;
                        v6 = true;
                        break block42;
                    }
                    v6 = false;
                }
            }
            if (v6) {
                preV4Baseline.addAll(CollectionsKt.listOf((Object[])new String[]{"migration/notary-bft-smart.changelog-init.xml", "migration/notary-bft-smart.changelog-v1.xml"}));
            }
        }
        if (isFinanceAppWithLiquibaseNotMigrated) {
            preV4Baseline.addAll(CollectionsKt.listOf((Object[])new String[]{"migration/cash.changelog-init.xml", "migration/cash.changelog-v1.xml", "migration/commercial-paper.changelog-init.xml", "migration/commercial-paper.changelog-v1.xml"}));
        }
        if (($receiver$iv = (Collection)preV4Baseline).isEmpty() == false) {
            dynamicInclude = "master.changelog.json";
            var8_10 = this.dataSource.getConnection();
            var9_11 = null;
            try {
                connection = (Connection)var8_10;
                v7 = this.classLoader;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"classLoader");
                customResourceAccessor = new CustomResourceAccessor(dynamicInclude, preV4Baseline, v7);
                liquibase = new Liquibase(dynamicInclude, (ResourceAccessor)customResourceAccessor, this.getLiquibaseDatabase(new JdbcConnection(connection)));
                liquibase.changeLogSync(new Contexts(), new LabelExpression());
                var10_18 = Unit.INSTANCE;
            }
            catch (Throwable var10_19) {
                var9_11 = var10_19;
                throw var10_19;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)var8_10, (Throwable)var9_11);
            }
        }
        return isExistingDBWithoutLiquibase != false || isFinanceAppWithLiquibaseNotMigrated != false;
    }

    @NotNull
    public final Set<MappedSchema> getSchemas() {
        return this.schemas;
    }

    @NotNull
    public final DataSource getDataSource() {
        return this.dataSource;
    }

    public SchemaMigration(@NotNull Set<? extends MappedSchema> schemas, @NotNull DataSource dataSource, @NotNull DatabaseConfig databaseConfig, @Nullable CordappLoader cordappLoader, @Nullable Path currentDirectory, @NotNull CordaX500Name ourName) {
        Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)databaseConfig, (String)"databaseConfig");
        Intrinsics.checkParameterIsNotNull((Object)ourName, (String)"ourName");
        this.schemas = schemas;
        this.dataSource = dataSource;
        this.databaseConfig = databaseConfig;
        this.currentDirectory = currentDirectory;
        this.ourName = ourName;
        loader.set(cordappLoader);
        Object object = cordappLoader;
        if (object == null || (object = object.getAppClassLoader()) == null) {
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            object = thread.getContextClassLoader();
        }
        this.classLoader = object;
    }

    public /* synthetic */ SchemaMigration(Set set2, DataSource dataSource, DatabaseConfig databaseConfig, CordappLoader cordappLoader, Path path, CordaX500Name cordaX500Name, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            cordappLoader = null;
        }
        this(set2, dataSource, databaseConfig, cordappLoader, path, cordaX500Name);
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
        loader = new ThreadLocal();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/persistence/SchemaMigration$CustomResourceAccessor;", "Lliquibase/resource/ClassLoaderResourceAccessor;", "dynamicInclude", "", "changelogList", "", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/ClassLoader;)V", "getChangelogList", "()Ljava/util/List;", "getDynamicInclude", "()Ljava/lang/String;", "getResourcesAsStream", "", "Ljava/io/InputStream;", "path", "node-api"})
    private static final class CustomResourceAccessor
    extends ClassLoaderResourceAccessor {
        @NotNull
        private final String dynamicInclude;
        @NotNull
        private final List<String> changelogList;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Set<InputStream> getResourcesAsStream(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            if (Intrinsics.areEqual((Object)path, (Object)this.dynamicInclude)) {
                String it;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = this.changelogList;
                String string = "databaseChangeLog";
                void var4_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    it = (String)element$iv$iv;
                    if (!(it != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<Map> collection = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv = (Iterable)collection;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void file;
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"include", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"file", (Object)file))));
                    collection.add(map);
                }
                collection = (List)destination$iv$iv;
                Map includeAllFiles = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)collection));
                byte[] includeAllFilesJson = new ObjectMapper().writeValueAsBytes((Object)includeAllFiles);
                return SetsKt.setOf((Object)new ByteArrayInputStream(includeAllFilesJson));
            }
            Collection collection = super.getResourcesAsStream(path);
            if (collection == null || (collection = CollectionsKt.take((Iterable)collection, (int)1)) == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
                collection = SetsKt.emptySet();
            }
            return collection;
        }

        @NotNull
        public final String getDynamicInclude() {
            return this.dynamicInclude;
        }

        @NotNull
        public final List<String> getChangelogList() {
            return this.changelogList;
        }

        public CustomResourceAccessor(@NotNull String dynamicInclude, @NotNull List<String> changelogList, @NotNull ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)dynamicInclude, (String)"dynamicInclude");
            Intrinsics.checkParameterIsNotNull(changelogList, (String)"changelogList");
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            super(classLoader);
            this.dynamicInclude = dynamicInclude;
            this.changelogList = changelogList;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/corda/nodeapi/internal/persistence/SchemaMigration$Companion;", "", "()V", "NODE_BASE_DIR_KEY", "", "NODE_X500_NAME", "loader", "Ljava/lang/ThreadLocal;", "Lnet/corda/nodeapi/internal/cordapp/CordappLoader;", "getLoader", "()Ljava/lang/ThreadLocal;", "logger", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        @NotNull
        public final ThreadLocal<CordappLoader> getLoader() {
            return loader;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

