/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.engine;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.protonwrapper.engine.ConnectionStateMachine;
import net.corda.nodeapi.internal.protonwrapper.engine.EventProcessor;
import net.corda.nodeapi.internal.protonwrapper.messages.MessageStatus;
import net.corda.nodeapi.internal.protonwrapper.messages.impl.ReceivedMessageImpl;
import net.corda.nodeapi.internal.protonwrapper.messages.impl.SendableMessageImpl;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.reactor.FlowController;
import org.apache.qpid.proton.reactor.Handshaker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070%H\u0002J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0006\u0010(\u001a\u00020\u001fJ\u0006\u0010)\u001a\u00020\u001fJ\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u001f2\u0006\u0010$\u001a\u000201J\u0016\u00102\u001a\u00020\u001f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f0%H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/engine/EventProcessor;", "Lorg/apache/qpid/proton/engine/BaseHandler;", "channel", "Lio/netty/channel/Channel;", "serverMode", "", "localLegalName", "", "remoteLegalName", "userName", "password", "(Lio/netty/channel/Channel;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "collector", "Lorg/apache/qpid/proton/engine/impl/CollectorImpl;", "connection", "Lorg/apache/qpid/proton/engine/Connection;", "getConnection", "()Lorg/apache/qpid/proton/engine/Connection;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "handlers", "", "Lorg/apache/qpid/proton/engine/Handler;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "pendingExecute", "stateMachine", "Lnet/corda/nodeapi/internal/protonwrapper/engine/ConnectionStateMachine;", "addHandler", "handler", "close", "", "complete", "completer", "Lnet/corda/nodeapi/internal/protonwrapper/messages/impl/ReceivedMessageImpl$MessageCompleter;", "logDebugWithMDC", "msg", "Lkotlin/Function0;", "popEvent", "Lorg/apache/qpid/proton/engine/Event;", "processEvents", "processEventsAsync", "tick", "transportProcessInput", "Lio/netty/buffer/ByteBuf;", "transportProcessOutput", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "transportWriteMessage", "Lnet/corda/nodeapi/internal/protonwrapper/messages/impl/SendableMessageImpl;", "withMDC", "block", "Companion", "node-api"})
public final class EventProcessor
extends BaseHandler {
    private final ReentrantLock lock;
    private boolean pendingExecute;
    private final ScheduledExecutorService executor;
    private final CollectorImpl collector;
    private final List<Handler> handlers;
    private final ConnectionStateMachine stateMachine;
    @NotNull
    private final Connection connection;
    private final boolean serverMode;
    private final String localLegalName;
    private final String remoteLegalName;
    private static final int FLOW_WINDOW_SIZE = 10;
    private static final Logger log;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withMDC(Function0<Unit> block) {
        Map oldMDC = MDC.getCopyOfContextMap();
        try {
            MDC.put((String)"serverMode", (String)String.valueOf(this.serverMode));
            MDC.put((String)"localLegalName", (String)this.localLegalName);
            MDC.put((String)"remoteLegalName", (String)this.remoteLegalName);
            block.invoke();
        }
        finally {
            MDC.setContextMap((Map)oldMDC);
        }
    }

    private final void logDebugWithMDC(Function0<String> msg) {
        if (log.isDebugEnabled()) {
            this.withMDC((Function0<Unit>)((Function0)new Function0<Unit>(msg){
                final /* synthetic */ Function0 $msg;

                public final void invoke() {
                    EventProcessor.access$getLog$cp().debug((String)this.$msg.invoke());
                }
                {
                    this.$msg = function0;
                    super(0);
                }
            }));
        }
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    public final boolean addHandler(@NotNull Handler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        return this.handlers.add(handler);
    }

    private final Event popEvent() {
        Event ev = this.collector.peek();
        if (ev != null) {
            ev = ev.copy();
            this.collector.pop();
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tick(Connection connection2) {
        Lock lock = this.lock;
        lock.lock();
        try {
            try {
                if (connection2.getLocalState() != EndpointState.CLOSED) {
                    Transport transport = connection2.getTransport();
                    Intrinsics.checkExpressionValueIsNotNull((Object)transport, (String)"connection.transport");
                    if (!transport.isClosed()) {
                        long now = System.currentTimeMillis();
                        long tickDelay = Math.max(0L, connection2.getTransport().tick(now) - now);
                        this.executor.schedule(new Runnable(this, connection2){
                            final /* synthetic */ EventProcessor this$0;
                            final /* synthetic */ Connection $connection$inlined;
                            {
                                this.this$0 = eventProcessor;
                                this.$connection$inlined = connection2;
                            }

                            public final void run() {
                                EventProcessor.access$tick(this.this$0, this.$connection$inlined);
                                this.this$0.processEvents();
                            }
                        }, tickDelay, TimeUnit.MILLISECONDS);
                    }
                }
            }
            catch (Exception ex) {
                connection2.getTransport().close();
                connection2.setCondition(new ErrorCondition());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processEvents() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            this.pendingExecute = false;
            this.logDebugWithMDC((Function0<String>)((Function0)processEvents.1.1.INSTANCE));
            block3: while (this.popEvent() != null) {
                Event ev;
                this.logDebugWithMDC((Function0<String>)((Function0)new Function0<String>(ev){
                    final /* synthetic */ Event $ev;

                    @NotNull
                    public final String invoke() {
                        return "Process event: " + this.$ev;
                    }
                    {
                        this.$ev = event;
                        super(0);
                    }
                }));
                object = this.handlers.iterator();
                while (true) {
                    if (!object.hasNext()) continue block3;
                    Handler handler = (Handler)object.next();
                    handler.handle(ev);
                }
                break;
            }
            this.stateMachine.processTransport();
            this.logDebugWithMDC((Function0<String>)((Function0)processEvents.1.3.INSTANCE));
            object = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processEventsAsync() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (!this.pendingExecute) {
                this.pendingExecute = true;
                this.executor.execute(new Runnable(this){
                    final /* synthetic */ EventProcessor this$0;
                    {
                        this.this$0 = eventProcessor;
                    }

                    public final void run() {
                        this.this$0.processEvents();
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void close() {
        if (this.connection.getLocalState() != EndpointState.CLOSED) {
            this.connection.close();
            this.processEvents();
            this.connection.free();
            this.processEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void transportProcessInput(@NotNull ByteBuf msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Lock lock = this.lock;
        lock.lock();
        try {
            this.stateMachine.transportProcessInput(msg);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void transportProcessOutput(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Lock lock = this.lock;
        lock.lock();
        try {
            this.stateMachine.transportProcessOutput(ctx);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void transportWriteMessage(@NotNull SendableMessageImpl msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Lock lock = this.lock;
        lock.lock();
        try {
            this.stateMachine.transportWriteMessage(msg);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void complete(@NotNull ReceivedMessageImpl.MessageCompleter completer) {
        Intrinsics.checkParameterIsNotNull((Object)completer, (String)"completer");
        Lock lock = this.lock;
        lock.lock();
        try {
            DeliveryState deliveryState;
            if (completer.getStatus() == MessageStatus.Acknowledged) {
                Accepted accepted = Accepted.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)accepted, (String)"Accepted.getInstance()");
                deliveryState = (DeliveryState)accepted;
            } else {
                deliveryState = (DeliveryState)new Rejected();
            }
            DeliveryState status = deliveryState;
            completer.getDelivery().disposition(status);
            completer.getDelivery().settle();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public EventProcessor(@NotNull Channel channel, boolean serverMode, @NotNull String localLegalName, @NotNull String remoteLegalName, @Nullable String userName, @Nullable String password) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)localLegalName, (String)"localLegalName");
        Intrinsics.checkParameterIsNotNull((Object)remoteLegalName, (String)"remoteLegalName");
        this.serverMode = serverMode;
        this.localLegalName = localLegalName;
        this.remoteLegalName = remoteLegalName;
        this.lock = new ReentrantLock();
        EventLoop eventLoop = channel.eventLoop();
        Intrinsics.checkExpressionValueIsNotNull((Object)eventLoop, (String)"channel.eventLoop()");
        this.executor = (ScheduledExecutorService)eventLoop;
        Collector collector = Proton.collector();
        if (collector == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.qpid.proton.engine.impl.CollectorImpl");
        }
        this.collector = (CollectorImpl)collector;
        EventProcessor eventProcessor = this;
        eventProcessor.handlers = list2 = (List)new ArrayList();
        this.stateMachine = new ConnectionStateMachine(this.serverMode, (Collector)this.collector, this.localLegalName, this.remoteLegalName, userName, password);
        this.connection = this.stateMachine.getConnection();
        this.addHandler((Handler)new Handshaker());
        this.addHandler((Handler)new FlowController(10));
        this.addHandler((Handler)this.stateMachine);
        this.connection.setContext((Object)channel);
        this.tick(this.stateMachine.getConnection());
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$tick(EventProcessor $this, @NotNull Connection connection2) {
        $this.tick(connection2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/engine/EventProcessor$Companion;", "", "()V", "FLOW_WINDOW_SIZE", "", "log", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

