/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.messages.impl;

import io.netty.channel.Channel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.protonwrapper.messages.MessageStatus;
import net.corda.nodeapi.internal.protonwrapper.messages.ReceivedMessage;
import org.apache.qpid.proton.engine.Delivery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001#B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016R\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016\u00a8\u0006$"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/messages/impl/ReceivedMessageImpl;", "Lnet/corda/nodeapi/internal/protonwrapper/messages/ReceivedMessage;", "payload", "", "topic", "", "sourceLegalName", "sourceLink", "Lnet/corda/core/utilities/NetworkHostAndPort;", "destinationLegalName", "destinationLink", "applicationProperties", "", "", "channel", "Lio/netty/channel/Channel;", "delivery", "Lorg/apache/qpid/proton/engine/Delivery;", "([BLjava/lang/String;Ljava/lang/String;Lnet/corda/core/utilities/NetworkHostAndPort;Ljava/lang/String;Lnet/corda/core/utilities/NetworkHostAndPort;Ljava/util/Map;Lio/netty/channel/Channel;Lorg/apache/qpid/proton/engine/Delivery;)V", "getApplicationProperties", "()Ljava/util/Map;", "getDestinationLegalName", "()Ljava/lang/String;", "getDestinationLink", "()Lnet/corda/core/utilities/NetworkHostAndPort;", "getPayload", "()[B", "getSourceLegalName", "getSourceLink", "getTopic", "complete", "", "accepted", "", "toString", "MessageCompleter", "node-api"})
public final class ReceivedMessageImpl
implements ReceivedMessage {
    @NotNull
    private final byte[] payload;
    @NotNull
    private final String topic;
    @NotNull
    private final String sourceLegalName;
    @NotNull
    private final NetworkHostAndPort sourceLink;
    @NotNull
    private final String destinationLegalName;
    @NotNull
    private final NetworkHostAndPort destinationLink;
    @NotNull
    private final Map<String, Object> applicationProperties;
    private final Channel channel;
    private final Delivery delivery;

    @Override
    public void complete(boolean accepted) {
        MessageStatus status = accepted ? MessageStatus.Acknowledged : MessageStatus.Rejected;
        this.channel.writeAndFlush((Object)new MessageCompleter(status, this.delivery));
    }

    @NotNull
    public String toString() {
        byte[] byArray = this.getPayload();
        StringBuilder stringBuilder = new StringBuilder().append("Received ");
        String string = new String(byArray, Charsets.UTF_8);
        return stringBuilder.append(string).append(' ').append(this.getTopic()).toString();
    }

    @Override
    @NotNull
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    @NotNull
    public String getTopic() {
        return this.topic;
    }

    @Override
    @NotNull
    public String getSourceLegalName() {
        return this.sourceLegalName;
    }

    @Override
    @NotNull
    public NetworkHostAndPort getSourceLink() {
        return this.sourceLink;
    }

    @Override
    @NotNull
    public String getDestinationLegalName() {
        return this.destinationLegalName;
    }

    @Override
    @NotNull
    public NetworkHostAndPort getDestinationLink() {
        return this.destinationLink;
    }

    @Override
    @NotNull
    public Map<String, Object> getApplicationProperties() {
        return this.applicationProperties;
    }

    public ReceivedMessageImpl(@NotNull byte[] payload, @NotNull String topic, @NotNull String sourceLegalName, @NotNull NetworkHostAndPort sourceLink, @NotNull String destinationLegalName, @NotNull NetworkHostAndPort destinationLink, @NotNull Map<String, ? extends Object> applicationProperties, @NotNull Channel channel, @NotNull Delivery delivery) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)sourceLegalName, (String)"sourceLegalName");
        Intrinsics.checkParameterIsNotNull((Object)sourceLink, (String)"sourceLink");
        Intrinsics.checkParameterIsNotNull((Object)destinationLegalName, (String)"destinationLegalName");
        Intrinsics.checkParameterIsNotNull((Object)destinationLink, (String)"destinationLink");
        Intrinsics.checkParameterIsNotNull(applicationProperties, (String)"applicationProperties");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)delivery, (String)"delivery");
        this.payload = payload;
        this.topic = topic;
        this.sourceLegalName = sourceLegalName;
        this.sourceLink = sourceLink;
        this.destinationLegalName = destinationLegalName;
        this.destinationLink = destinationLink;
        this.applicationProperties = applicationProperties;
        this.channel = channel;
        this.delivery = delivery;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/messages/impl/ReceivedMessageImpl$MessageCompleter;", "", "status", "Lnet/corda/nodeapi/internal/protonwrapper/messages/MessageStatus;", "delivery", "Lorg/apache/qpid/proton/engine/Delivery;", "(Lnet/corda/nodeapi/internal/protonwrapper/messages/MessageStatus;Lorg/apache/qpid/proton/engine/Delivery;)V", "getDelivery", "()Lorg/apache/qpid/proton/engine/Delivery;", "getStatus", "()Lnet/corda/nodeapi/internal/protonwrapper/messages/MessageStatus;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "node-api"})
    public static final class MessageCompleter {
        @NotNull
        private final MessageStatus status;
        @NotNull
        private final Delivery delivery;

        @NotNull
        public final MessageStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final Delivery getDelivery() {
            return this.delivery;
        }

        public MessageCompleter(@NotNull MessageStatus status, @NotNull Delivery delivery) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)delivery, (String)"delivery");
            this.status = status;
            this.delivery = delivery;
        }

        @NotNull
        public final MessageStatus component1() {
            return this.status;
        }

        @NotNull
        public final Delivery component2() {
            return this.delivery;
        }

        @NotNull
        public final MessageCompleter copy(@NotNull MessageStatus status, @NotNull Delivery delivery) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)delivery, (String)"delivery");
            return new MessageCompleter(status, delivery);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ MessageCompleter copy$default(MessageCompleter messageCompleter, MessageStatus messageStatus, Delivery delivery, int n, Object object) {
            if ((n & 1) != 0) {
                messageStatus = messageCompleter.status;
            }
            if ((n & 2) != 0) {
                delivery = messageCompleter.delivery;
            }
            return messageCompleter.copy(messageStatus, delivery);
        }

        @NotNull
        public String toString() {
            return "MessageCompleter(status=" + (Object)((Object)this.status) + ", delivery=" + this.delivery + ")";
        }

        public int hashCode() {
            MessageStatus messageStatus = this.status;
            Delivery delivery = this.delivery;
            return (messageStatus != null ? ((Object)((Object)messageStatus)).hashCode() : 0) * 31 + (delivery != null ? delivery.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MessageCompleter)) break block3;
                    MessageCompleter messageCompleter = (MessageCompleter)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.status), (Object)((Object)messageCompleter.status)) || !Intrinsics.areEqual((Object)this.delivery, (Object)messageCompleter.delivery)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

