/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.ArtemisUtils;
import net.corda.nodeapi.internal.protonwrapper.messages.ReceivedMessage;
import net.corda.nodeapi.internal.protonwrapper.messages.SendableMessage;
import net.corda.nodeapi.internal.protonwrapper.messages.impl.SendableMessageImpl;
import net.corda.nodeapi.internal.protonwrapper.netty.AMQPChannelHandler;
import net.corda.nodeapi.internal.protonwrapper.netty.AMQPClient;
import net.corda.nodeapi.internal.protonwrapper.netty.AMQPConfiguration;
import net.corda.nodeapi.internal.protonwrapper.netty.ConnectionChange;
import net.corda.nodeapi.internal.protonwrapper.netty.SSLHelperKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t*\u0001\u001c\u0018\u0000 F2\u00020\u0001:\u0002EFB5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u00103\u001a\u000204H\u0016J4\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0006\u0012\u0004\u0018\u00010>0=J\b\u0010?\u001a\u000204H\u0002J\b\u0010@\u001a\u000204H\u0002J\u0006\u0010A\u001a\u000204J\u0006\u0010B\u001a\u000204J\u000e\u0010C\u001a\u0002042\u0006\u0010D\u001a\u000206RN\u0010\r\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0011\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00120\u0012 \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120&8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u00020\u001f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient;", "Ljava/lang/AutoCloseable;", "targets", "", "Lnet/corda/core/utilities/NetworkHostAndPort;", "allowedRemoteLegalNames", "", "Lnet/corda/core/identity/CordaX500Name;", "configuration", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;", "sharedThreadPool", "Lio/netty/channel/EventLoopGroup;", "(Ljava/util/List;Ljava/util/Set;Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;Lio/netty/channel/EventLoopGroup;)V", "_onConnection", "Lrx/subjects/SerializedSubject;", "Lnet/corda/nodeapi/internal/protonwrapper/netty/ConnectionChange;", "kotlin.jvm.PlatformType", "_onReceive", "Lnet/corda/nodeapi/internal/protonwrapper/messages/ReceivedMessage;", "getAllowedRemoteLegalNames", "()Ljava/util/Set;", "badCertTargets", "", "clientChannel", "Lio/netty/channel/Channel;", "closeListener", "Lio/netty/channel/ChannelFutureListener;", "connectListener", "net/corda/nodeapi/internal/protonwrapper/netty/AMQPClient$connectListener$1", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient$connectListener$1;", "connected", "", "getConnected", "()Z", "currentTarget", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "onConnection", "Lrx/Observable;", "getOnConnection", "()Lrx/Observable;", "onReceive", "getOnReceive", "retryInterval", "", "stopping", "targetIndex", "", "getTargets", "()Ljava/util/List;", "workerGroup", "close", "", "createMessage", "Lnet/corda/nodeapi/internal/protonwrapper/messages/SendableMessage;", "payload", "", "topic", "", "destinationLegalName", "properties", "", "", "nextTarget", "restart", "start", "stop", "write", "msg", "ClientChannelInitializer", "Companion", "node-api"})
public final class AMQPClient
implements AutoCloseable {
    private final ReentrantLock lock;
    private volatile boolean stopping;
    private EventLoopGroup workerGroup;
    private volatile Channel clientChannel;
    private int targetIndex;
    private NetworkHostAndPort currentTarget;
    private long retryInterval;
    private final Set<NetworkHostAndPort> badCertTargets;
    private final connectListener.1 connectListener;
    private final ChannelFutureListener closeListener;
    private final SerializedSubject<ReceivedMessage, ReceivedMessage> _onReceive;
    private final SerializedSubject<ConnectionChange, ConnectionChange> _onConnection;
    @NotNull
    private final List<NetworkHostAndPort> targets;
    @NotNull
    private final Set<CordaX500Name> allowedRemoteLegalNames;
    private final AMQPConfiguration configuration;
    private final EventLoopGroup sharedThreadPool;
    @NotNull
    private static final Logger log;
    public static final long MIN_RETRY_INTERVAL = 1000L;
    public static final long MAX_RETRY_INTERVAL = 60000L;
    public static final long BACKOFF_MULTIPLIER = 2L;
    public static final int NUM_CLIENT_THREADS = 2;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final void nextTarget() {
        int origIndex = this.targetIndex;
        this.targetIndex = -1;
        int n = 1;
        int n2 = this.targets.size();
        if (n <= n2) {
            while (true) {
                void offset;
                int newTargetIndex;
                if (!this.badCertTargets.contains(this.targets.get(newTargetIndex = (origIndex + offset) % this.targets.size()))) {
                    this.targetIndex = newTargetIndex;
                    break;
                }
                if (offset == n2) break;
                ++offset;
            }
        }
        if (this.targetIndex == -1) {
            log.error("No targets have presented acceptable certificates for " + this.allowedRemoteLegalNames + ". Halting retries");
            return;
        }
        log.info("Retry connect to " + this.targets.get(this.targetIndex));
        this.retryInterval = Long.min(60000L, this.retryInterval * 2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Lock lock = this.lock;
        lock.lock();
        try {
            log.info("connect to: " + this.currentTarget);
            EventLoopGroup eventLoopGroup = this.sharedThreadPool;
            if (eventLoopGroup == null) {
                eventLoopGroup = (EventLoopGroup)new NioEventLoopGroup(2);
            }
            this.workerGroup = eventLoopGroup;
            this.restart();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void restart() {
        if (this.targetIndex == -1) {
            return;
        }
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ClientChannelInitializer(this));
        this.currentTarget = this.targets.get(this.targetIndex);
        ChannelFuture clientFuture = bootstrap.connect(this.currentTarget.getHost(), this.currentTarget.getPort());
        clientFuture.addListener((GenericFutureListener)this.connectListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Lock lock = this.lock;
        lock.lock();
        try {
            log.info("disconnect from: " + this.currentTarget);
            this.stopping = true;
            try {
                if (this.sharedThreadPool == null) {
                    EventLoopGroup eventLoopGroup;
                    EventLoopGroup eventLoopGroup2 = this.workerGroup;
                    if (eventLoopGroup2 != null) {
                        eventLoopGroup2.shutdownGracefully();
                    }
                    if ((eventLoopGroup = this.workerGroup) != null && (eventLoopGroup = eventLoopGroup.terminationFuture()) != null) {
                        eventLoopGroup.sync();
                    }
                } else {
                    Channel channel = this.clientChannel;
                    if (channel != null && (channel = channel.close()) != null) {
                        channel.sync();
                    }
                }
                this.clientChannel = null;
                this.workerGroup = null;
            }
            finally {
                this.stopping = false;
            }
            log.info("stopped connection to " + this.currentTarget);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getConnected() {
        Channel channel;
        Channel channel2;
        Lock lock = this.lock;
        lock.lock();
        try {
            channel2 = this.clientChannel;
        }
        finally {
            lock.unlock();
        }
        Channel channel3 = channel = channel2;
        return channel3 != null ? channel3.isActive() : false;
    }

    @NotNull
    public final SendableMessage createMessage(@NotNull byte[] payload, @NotNull String topic, @NotNull String destinationLegalName, @NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)destinationLegalName, (String)"destinationLegalName");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        ArtemisUtils.requireMessageSize(payload.length, this.configuration.getMaxMessageSize());
        return new SendableMessageImpl(payload, topic, destinationLegalName, this.currentTarget, properties);
    }

    public final void write(@NotNull SendableMessage msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Channel channel = this.clientChannel;
        if (channel == null) {
            throw (Throwable)new IllegalStateException("Connection to " + this.targets + " not active");
        }
        channel.writeAndFlush((Object)msg);
    }

    @NotNull
    public final Observable<ReceivedMessage> getOnReceive() {
        SerializedSubject<ReceivedMessage, ReceivedMessage> serializedSubject = this._onReceive;
        Intrinsics.checkExpressionValueIsNotNull(serializedSubject, (String)"_onReceive");
        return (Observable)serializedSubject;
    }

    @NotNull
    public final Observable<ConnectionChange> getOnConnection() {
        SerializedSubject<ConnectionChange, ConnectionChange> serializedSubject = this._onConnection;
        Intrinsics.checkExpressionValueIsNotNull(serializedSubject, (String)"_onConnection");
        return (Observable)serializedSubject;
    }

    @NotNull
    public final List<NetworkHostAndPort> getTargets() {
        return this.targets;
    }

    @NotNull
    public final Set<CordaX500Name> getAllowedRemoteLegalNames() {
        return this.allowedRemoteLegalNames;
    }

    public AMQPClient(@NotNull List<NetworkHostAndPort> targets, @NotNull Set<CordaX500Name> allowedRemoteLegalNames, @NotNull AMQPConfiguration configuration, @Nullable EventLoopGroup sharedThreadPool) {
        Set set2;
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Intrinsics.checkParameterIsNotNull(allowedRemoteLegalNames, (String)"allowedRemoteLegalNames");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.targets = targets;
        this.allowedRemoteLegalNames = allowedRemoteLegalNames;
        this.configuration = configuration;
        this.sharedThreadPool = sharedThreadPool;
        this.lock = new ReentrantLock();
        this.currentTarget = (NetworkHostAndPort)CollectionsKt.first(this.targets);
        this.retryInterval = 1000L;
        AMQPClient aMQPClient = this;
        aMQPClient.badCertTargets = set2 = (Set)new LinkedHashSet();
        this.connectListener = new ChannelFutureListener(this){
            final /* synthetic */ AMQPClient this$0;

            public void operationComplete(@NotNull ChannelFuture future) {
                block2: {
                    block1: {
                        Intrinsics.checkParameterIsNotNull((Object)future, (String)"future");
                        if (future.isSuccess()) break block1;
                        AMQPClient.Companion.getLog().info("Failed to connect to " + AMQPClient.access$getCurrentTarget$p(this.this$0));
                        if (AMQPClient.access$getStopping$p(this.this$0)) break block2;
                        EventLoopGroup eventLoopGroup = AMQPClient.access$getWorkerGroup$p(this.this$0);
                        if (eventLoopGroup != null) {
                            eventLoopGroup.schedule(new Runnable(this){
                                final /* synthetic */ connectListener.1 this$0;

                                public final void run() {
                                    AMQPClient.access$nextTarget(this.this$0.this$0);
                                    AMQPClient.access$restart(this.this$0.this$0);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }, AMQPClient.access$getRetryInterval$p(this.this$0), TimeUnit.MILLISECONDS);
                        }
                        break block2;
                    }
                    AMQPClient.Companion.getLog().info("Connected to " + AMQPClient.access$getCurrentTarget$p(this.this$0));
                    AMQPClient.access$setClientChannel$p(this.this$0, future.channel());
                    Channel channel = AMQPClient.access$getClientChannel$p(this.this$0);
                    if (channel == null || (channel = channel.closeFuture()) == null) break block2;
                    channel.addListener((GenericFutureListener)AMQPClient.access$getCloseListener$p(this.this$0));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.closeListener = new ChannelFutureListener(this){
            final /* synthetic */ AMQPClient this$0;

            public final void operationComplete(ChannelFuture future) {
                block2: {
                    AMQPClient.Companion.getLog().info("Disconnected from " + AMQPClient.access$getCurrentTarget$p(this.this$0));
                    Channel channel = future.channel();
                    if (channel != null) {
                        channel.disconnect();
                    }
                    AMQPClient.access$setClientChannel$p(this.this$0, null);
                    if (AMQPClient.access$getStopping$p(this.this$0)) break block2;
                    EventLoopGroup eventLoopGroup = AMQPClient.access$getWorkerGroup$p(this.this$0);
                    if (eventLoopGroup != null) {
                        eventLoopGroup.schedule(new Runnable(this){
                            final /* synthetic */ closeListener.1 this$0;

                            public final void run() {
                                AMQPClient.access$nextTarget(this.this$0.this$0);
                                AMQPClient.access$restart(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, AMQPClient.access$getRetryInterval$p(this.this$0), TimeUnit.MILLISECONDS);
                    }
                }
            }
            {
                this.this$0 = aMQPClient;
            }
        };
        this._onReceive = PublishSubject.create().toSerialized();
        this._onConnection = PublishSubject.create().toSerialized();
    }

    public /* synthetic */ AMQPClient(List list2, Set set2, AMQPConfiguration aMQPConfiguration, EventLoopGroup eventLoopGroup, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            eventLoopGroup = null;
        }
        this(list2, set2, aMQPConfiguration, eventLoopGroup);
    }

    static {
        Companion = new Companion(null);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    public static final /* synthetic */ void access$setCurrentTarget$p(AMQPClient $this, @NotNull NetworkHostAndPort networkHostAndPort) {
        $this.currentTarget = networkHostAndPort;
    }

    public static final /* synthetic */ long access$getRetryInterval$p(AMQPClient $this) {
        return $this.retryInterval;
    }

    public static final /* synthetic */ void access$setRetryInterval$p(AMQPClient $this, long l) {
        $this.retryInterval = l;
    }

    public static final /* synthetic */ SerializedSubject access$get_onConnection$p(AMQPClient $this) {
        return $this._onConnection;
    }

    @NotNull
    public static final /* synthetic */ Set access$getBadCertTargets$p(AMQPClient $this) {
        return $this.badCertTargets;
    }

    public static final /* synthetic */ SerializedSubject access$get_onReceive$p(AMQPClient $this) {
        return $this._onReceive;
    }

    public static final /* synthetic */ boolean access$getStopping$p(AMQPClient $this) {
        return $this.stopping;
    }

    public static final /* synthetic */ void access$setStopping$p(AMQPClient $this, boolean bl) {
        $this.stopping = bl;
    }

    @Nullable
    public static final /* synthetic */ EventLoopGroup access$getWorkerGroup$p(AMQPClient $this) {
        return $this.workerGroup;
    }

    public static final /* synthetic */ void access$setWorkerGroup$p(AMQPClient $this, @Nullable EventLoopGroup eventLoopGroup) {
        $this.workerGroup = eventLoopGroup;
    }

    public static final /* synthetic */ void access$nextTarget(AMQPClient $this) {
        $this.nextTarget();
    }

    public static final /* synthetic */ void access$restart(AMQPClient $this) {
        $this.restart();
    }

    @Nullable
    public static final /* synthetic */ Channel access$getClientChannel$p(AMQPClient $this) {
        return $this.clientChannel;
    }

    public static final /* synthetic */ void access$setClientChannel$p(AMQPClient $this, @Nullable Channel channel) {
        $this.clientChannel = channel;
    }

    @NotNull
    public static final /* synthetic */ ChannelFutureListener access$getCloseListener$p(AMQPClient $this) {
        return $this.closeListener;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient$ClientChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "parent", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient;", "(Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient;)V", "conf", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;", "keyManagerFactory", "Ljavax/net/ssl/KeyManagerFactory;", "kotlin.jvm.PlatformType", "getParent", "()Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient;", "trustManagerFactory", "Ljavax/net/ssl/TrustManagerFactory;", "initChannel", "", "ch", "node-api"})
    private static final class ClientChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final KeyManagerFactory keyManagerFactory;
        private final TrustManagerFactory trustManagerFactory;
        private final AMQPConfiguration conf;
        @NotNull
        private final AMQPClient parent;

        protected void initChannel(@NotNull SocketChannel ch) {
            Intrinsics.checkParameterIsNotNull((Object)ch, (String)"ch");
            ChannelPipeline pipeline = ch.pipeline();
            NetworkHostAndPort target = this.parent.currentTarget;
            Set<CordaX500Name> set2 = this.parent.getAllowedRemoteLegalNames();
            KeyManagerFactory keyManagerFactory = this.keyManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyManagerFactory, (String)"keyManagerFactory");
            TrustManagerFactory trustManagerFactory = this.trustManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerFactory, (String)"trustManagerFactory");
            SslHandler handler = SSLHelperKt.createClientSslHelper(target, set2, keyManagerFactory, trustManagerFactory);
            pipeline.addLast("sslHandler", (ChannelHandler)handler);
            if (this.conf.getTrace()) {
                pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(LogLevel.INFO));
            }
            pipeline.addLast(new ChannelHandler[]{(ChannelHandler)new AMQPChannelHandler(false, this.parent.getAllowedRemoteLegalNames(), this.conf.getUserName(), this.conf.getPassword(), this.conf.getTrace(), (Function1<? super Pair<? extends SocketChannel, ConnectionChange>, Unit>)((Function1)new Function1<Pair<? extends SocketChannel, ? extends ConnectionChange>, Unit>(this){
                final /* synthetic */ ClientChannelInitializer this$0;

                public final void invoke(@NotNull Pair<? extends SocketChannel, ConnectionChange> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    AMQPClient.access$setRetryInterval$p(this.this$0.getParent(), 1000L);
                    AMQPClient.access$get_onConnection$p(this.this$0.getParent()).onNext(it.getSecond());
                }
                {
                    this.this$0 = clientChannelInitializer;
                    super(1);
                }
            }), (Function1<? super Pair<? extends SocketChannel, ConnectionChange>, Unit>)((Function1)new Function1<Pair<? extends SocketChannel, ? extends ConnectionChange>, Unit>(this, target){
                final /* synthetic */ ClientChannelInitializer this$0;
                final /* synthetic */ NetworkHostAndPort $target;

                public final void invoke(@NotNull Pair<? extends SocketChannel, ConnectionChange> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    AMQPClient.access$get_onConnection$p(this.this$0.getParent()).onNext(it.getSecond());
                    if (((ConnectionChange)it.getSecond()).getBadCert()) {
                        AMQPClient.Companion.getLog().error("Blocking future connection attempts to " + this.$target + " due to bad certificate on endpoint");
                        Collection collection = AMQPClient.access$getBadCertTargets$p(this.this$0.getParent());
                        NetworkHostAndPort networkHostAndPort = this.$target;
                        collection.add(networkHostAndPort);
                    }
                }
                {
                    this.this$0 = clientChannelInitializer;
                    this.$target = networkHostAndPort;
                    super(1);
                }
            }), (Function1<? super ReceivedMessage, Unit>)((Function1)new Function1<ReceivedMessage, Unit>(this){
                final /* synthetic */ ClientChannelInitializer this$0;

                public final void invoke(@NotNull ReceivedMessage rcv) {
                    Intrinsics.checkParameterIsNotNull((Object)rcv, (String)"rcv");
                    AMQPClient.access$get_onReceive$p(this.this$0.getParent()).onNext((Object)rcv);
                }
                {
                    this.this$0 = clientChannelInitializer;
                    super(1);
                }
            }))});
        }

        @NotNull
        public final AMQPClient getParent() {
            return this.parent;
        }

        public ClientChannelInitializer(@NotNull AMQPClient parent) {
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            this.parent = parent;
            this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.conf = this.parent.configuration;
            KeyManagerFactory keyManagerFactory = this.keyManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyManagerFactory, (String)"keyManagerFactory");
            SSLHelperKt.init(keyManagerFactory, this.conf.getKeyStore());
            this.trustManagerFactory.init(SSLHelperKt.initialiseTrustStoreAndEnableCrlChecking(this.conf.getTrustStore(), this.conf.getCrlCheckSoftFail()));
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPClient$Companion;", "", "()V", "BACKOFF_MULTIPLIER", "", "MAX_RETRY_INTERVAL", "MIN_RETRY_INTERVAL", "NUM_CLIENT_THREADS", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        @NotNull
        public final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

