/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.ArtemisUtils;
import net.corda.nodeapi.internal.protonwrapper.messages.ReceivedMessage;
import net.corda.nodeapi.internal.protonwrapper.messages.SendableMessage;
import net.corda.nodeapi.internal.protonwrapper.messages.impl.SendableMessageImpl;
import net.corda.nodeapi.internal.protonwrapper.netty.AMQPChannelHandler;
import net.corda.nodeapi.internal.protonwrapper.netty.AMQPConfiguration;
import net.corda.nodeapi.internal.protonwrapper.netty.ConnectionChange;
import net.corda.nodeapi.internal.protonwrapper.netty.SSLHelperKt;
import org.apache.qpid.proton.engine.Delivery;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u0000 @2\u00020\u0001:\u0002@AB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010)\u001a\u00020*H\u0016J\u0016\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0013J<\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u0002062\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010908J\u000e\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020\u0013J\u0006\u0010<\u001a\u00020*J\u0006\u0010=\u001a\u00020*J\u000e\u0010>\u001a\u00020*2\u0006\u0010?\u001a\u000200RN\u0010\t\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\r\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00020\u00188\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPServer;", "Ljava/lang/AutoCloseable;", "hostName", "", "port", "", "configuration", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;", "(Ljava/lang/String;ILnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;)V", "_onConnection", "Lrx/subjects/SerializedSubject;", "Lnet/corda/nodeapi/internal/protonwrapper/netty/ConnectionChange;", "kotlin.jvm.PlatformType", "_onReceive", "Lnet/corda/nodeapi/internal/protonwrapper/messages/ReceivedMessage;", "bossGroup", "Lio/netty/channel/EventLoopGroup;", "clientChannels", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/net/InetSocketAddress;", "Lio/netty/channel/socket/SocketChannel;", "getHostName", "()Ljava/lang/String;", "listening", "", "getListening", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "onConnection", "Lrx/Observable;", "getOnConnection", "()Lrx/Observable;", "onReceive", "getOnReceive", "getPort", "()I", "serverChannel", "Lio/netty/channel/Channel;", "stopping", "workerGroup", "close", "", "complete", "delivery", "Lorg/apache/qpid/proton/engine/Delivery;", "target", "createMessage", "Lnet/corda/nodeapi/internal/protonwrapper/messages/SendableMessage;", "payload", "", "topic", "destinationLegalName", "destinationLink", "Lnet/corda/core/utilities/NetworkHostAndPort;", "properties", "", "", "dropConnection", "connectionRemoteHost", "start", "stop", "write", "msg", "Companion", "ServerChannelInitializer", "node-api"})
public final class AMQPServer
implements AutoCloseable {
    private final ReentrantLock lock;
    private volatile boolean stopping;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel serverChannel;
    private final ConcurrentHashMap<InetSocketAddress, SocketChannel> clientChannels;
    private final SerializedSubject<ReceivedMessage, ReceivedMessage> _onReceive;
    private final SerializedSubject<ConnectionChange, ConnectionChange> _onConnection;
    @NotNull
    private final String hostName;
    private final int port;
    private final AMQPConfiguration configuration;
    private static final Logger log;
    public static final int NUM_SERVER_THREADS = 4;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Lock lock = this.lock;
        lock.lock();
        try {
            ChannelFuture channelFuture;
            this.stop();
            this.bossGroup = (EventLoopGroup)new NioEventLoopGroup(1);
            this.workerGroup = (EventLoopGroup)new NioEventLoopGroup(4);
            ServerBootstrap server = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)server.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerChannelInitializer(this));
            log.info("Try to bind " + this.port);
            ChannelFuture channelFuture2 = channelFuture = server.bind(this.hostName, this.port).sync();
            Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture2, (String)"channelFuture");
            if (!channelFuture2.isDone() || !channelFuture.isSuccess()) {
                throw (Throwable)new BindException("Failed to bind port " + this.port);
            }
            log.info("Listening on port " + this.port);
            this.serverChannel = channelFuture.channel();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Lock lock = this.lock;
        lock.lock();
        try {
            try {
                EventLoopGroup eventLoopGroup;
                EventLoopGroup eventLoopGroup2;
                this.stopping = true;
                Channel channel = this.serverChannel;
                if (channel != null) {
                    Channel channel2;
                    Channel $receiver = channel2 = channel;
                    $receiver.close();
                }
                this.serverChannel = null;
                EventLoopGroup eventLoopGroup3 = this.workerGroup;
                if (eventLoopGroup3 != null) {
                    eventLoopGroup3.shutdownGracefully();
                }
                if ((eventLoopGroup2 = this.workerGroup) != null && (eventLoopGroup2 = eventLoopGroup2.terminationFuture()) != null) {
                    eventLoopGroup2.sync();
                }
                EventLoopGroup eventLoopGroup4 = this.bossGroup;
                if (eventLoopGroup4 != null) {
                    eventLoopGroup4.shutdownGracefully();
                }
                if ((eventLoopGroup = this.bossGroup) != null && (eventLoopGroup = eventLoopGroup.terminationFuture()) != null) {
                    eventLoopGroup.sync();
                }
                this.workerGroup = null;
                this.bossGroup = null;
            }
            finally {
                this.stopping = false;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getListening() {
        Channel channel;
        Channel channel2;
        Lock lock = this.lock;
        lock.lock();
        try {
            channel2 = this.serverChannel;
        }
        finally {
            lock.unlock();
        }
        Channel channel3 = channel = channel2;
        return channel3 != null ? channel3.isActive() : false;
    }

    @NotNull
    public final SendableMessage createMessage(@NotNull byte[] payload, @NotNull String topic, @NotNull String destinationLegalName, @NotNull NetworkHostAndPort destinationLink, @NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)destinationLegalName, (String)"destinationLegalName");
        Intrinsics.checkParameterIsNotNull((Object)destinationLink, (String)"destinationLink");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        ArtemisUtils.requireMessageSize(payload.length, this.configuration.getMaxMessageSize());
        InetSocketAddress dest = new InetSocketAddress(destinationLink.getHost(), destinationLink.getPort());
        boolean bl = ((ConcurrentHashMap.KeySetView)this.clientChannels.keySet()).contains(dest);
        if (!bl) {
            String string = "Destination not available";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new SendableMessageImpl(payload, topic, destinationLegalName, destinationLink, properties);
    }

    public final void write(@NotNull SendableMessage msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        InetSocketAddress dest = new InetSocketAddress(msg.getDestinationLink().getHost(), msg.getDestinationLink().getPort());
        SocketChannel channel = this.clientChannels.get(dest);
        if (channel == null) {
            throw (Throwable)new IllegalStateException("Connection to " + msg.getDestinationLink() + " not active");
        }
        channel.writeAndFlush((Object)msg);
    }

    public final void dropConnection(@NotNull InetSocketAddress connectionRemoteHost) {
        Intrinsics.checkParameterIsNotNull((Object)connectionRemoteHost, (String)"connectionRemoteHost");
        SocketChannel channel = this.clientChannels.get(connectionRemoteHost);
        if (channel != null) {
            channel.close();
        }
    }

    public final void complete(@NotNull Delivery delivery, @NotNull InetSocketAddress target) {
        block0: {
            SocketChannel socketChannel;
            SocketChannel channel;
            Intrinsics.checkParameterIsNotNull((Object)delivery, (String)"delivery");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            SocketChannel socketChannel2 = channel = this.clientChannels.get(target);
            if (socketChannel2 == null) break block0;
            SocketChannel $receiver = socketChannel = socketChannel2;
            $receiver.writeAndFlush((Object)delivery);
        }
    }

    @NotNull
    public final Observable<ReceivedMessage> getOnReceive() {
        SerializedSubject<ReceivedMessage, ReceivedMessage> serializedSubject = this._onReceive;
        Intrinsics.checkExpressionValueIsNotNull(serializedSubject, (String)"_onReceive");
        return (Observable)serializedSubject;
    }

    @NotNull
    public final Observable<ConnectionChange> getOnConnection() {
        SerializedSubject<ConnectionChange, ConnectionChange> serializedSubject = this._onConnection;
        Intrinsics.checkExpressionValueIsNotNull(serializedSubject, (String)"_onConnection");
        return (Observable)serializedSubject;
    }

    @NotNull
    public final String getHostName() {
        return this.hostName;
    }

    public final int getPort() {
        return this.port;
    }

    public AMQPServer(@NotNull String hostName, int port, @NotNull AMQPConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)hostName, (String)"hostName");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.hostName = hostName;
        this.port = port;
        this.configuration = configuration;
        this.lock = new ReentrantLock();
        this.clientChannels = new ConcurrentHashMap();
        this._onReceive = PublishSubject.create().toSerialized();
        this._onConnection = PublishSubject.create().toSerialized();
    }

    static {
        Companion = new Companion(null);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getClientChannels$p(AMQPServer $this) {
        return $this.clientChannels;
    }

    public static final /* synthetic */ SerializedSubject access$get_onConnection$p(AMQPServer $this) {
        return $this._onConnection;
    }

    public static final /* synthetic */ SerializedSubject access$get_onReceive$p(AMQPServer $this) {
        return $this._onReceive;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPServer$ServerChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "parent", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPServer;", "(Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPServer;)V", "conf", "Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPConfiguration;", "keyManagerFactory", "Ljavax/net/ssl/KeyManagerFactory;", "kotlin.jvm.PlatformType", "getParent", "()Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPServer;", "trustManagerFactory", "Ljavax/net/ssl/TrustManagerFactory;", "initChannel", "", "ch", "node-api"})
    private static final class ServerChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final KeyManagerFactory keyManagerFactory;
        private final TrustManagerFactory trustManagerFactory;
        private final AMQPConfiguration conf;
        @NotNull
        private final AMQPServer parent;

        protected void initChannel(@NotNull SocketChannel ch) {
            Intrinsics.checkParameterIsNotNull((Object)ch, (String)"ch");
            ChannelPipeline pipeline = ch.pipeline();
            KeyManagerFactory keyManagerFactory = this.keyManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyManagerFactory, (String)"keyManagerFactory");
            TrustManagerFactory trustManagerFactory = this.trustManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerFactory, (String)"trustManagerFactory");
            SslHandler handler = SSLHelperKt.createServerSslHelper(keyManagerFactory, trustManagerFactory);
            pipeline.addLast("sslHandler", (ChannelHandler)handler);
            if (this.conf.getTrace()) {
                pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(LogLevel.INFO));
            }
            pipeline.addLast(new ChannelHandler[]{(ChannelHandler)new AMQPChannelHandler(true, null, this.conf.getUserName(), this.conf.getPassword(), this.conf.getTrace(), (Function1<? super Pair<? extends SocketChannel, ConnectionChange>, Unit>)((Function1)new Function1<Pair<? extends SocketChannel, ? extends ConnectionChange>, Unit>(this){
                final /* synthetic */ ServerChannelInitializer this$0;

                public final void invoke(@NotNull Pair<? extends SocketChannel, ConnectionChange> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Map map = AMQPServer.access$getClientChannels$p(this.this$0.getParent());
                    InetSocketAddress inetSocketAddress = ((SocketChannel)it.getFirst()).remoteAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inetSocketAddress, (String)"it.first.remoteAddress()");
                    InetSocketAddress inetSocketAddress2 = inetSocketAddress;
                    Object object = it.getFirst();
                    map.put(inetSocketAddress2, object);
                    AMQPServer.access$get_onConnection$p(this.this$0.getParent()).onNext(it.getSecond());
                }
                {
                    this.this$0 = serverChannelInitializer;
                    super(1);
                }
            }), (Function1<? super Pair<? extends SocketChannel, ConnectionChange>, Unit>)((Function1)new Function1<Pair<? extends SocketChannel, ? extends ConnectionChange>, Unit>(this){
                final /* synthetic */ ServerChannelInitializer this$0;

                public final void invoke(@NotNull Pair<? extends SocketChannel, ConnectionChange> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    AMQPServer.access$getClientChannels$p(this.this$0.getParent()).remove(((SocketChannel)it.getFirst()).remoteAddress());
                    AMQPServer.access$get_onConnection$p(this.this$0.getParent()).onNext(it.getSecond());
                }
                {
                    this.this$0 = serverChannelInitializer;
                    super(1);
                }
            }), (Function1<? super ReceivedMessage, Unit>)((Function1)new Function1<ReceivedMessage, Unit>(this){
                final /* synthetic */ ServerChannelInitializer this$0;

                public final void invoke(@NotNull ReceivedMessage rcv) {
                    Intrinsics.checkParameterIsNotNull((Object)rcv, (String)"rcv");
                    AMQPServer.access$get_onReceive$p(this.this$0.getParent()).onNext((Object)rcv);
                }
                {
                    this.this$0 = serverChannelInitializer;
                    super(1);
                }
            }))});
        }

        @NotNull
        public final AMQPServer getParent() {
            return this.parent;
        }

        public ServerChannelInitializer(@NotNull AMQPServer parent) {
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            this.parent = parent;
            this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.conf = this.parent.configuration;
            KeyManagerFactory keyManagerFactory = this.keyManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyManagerFactory, (String)"keyManagerFactory");
            SSLHelperKt.init(keyManagerFactory, this.conf.getKeyStore());
            this.trustManagerFactory.init(SSLHelperKt.initialiseTrustStoreAndEnableCrlChecking(this.conf.getTrustStore(), this.conf.getCrlCheckSoftFail()));
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/AMQPServer$Companion;", "", "()V", "NUM_SERVER_THREADS", "", "log", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

