/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.netty;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.utilities.EncodingUtils;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.nodeapi.internal.crypto.X509UtilitiesKt;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u00020\u00072\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ)\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u0011J3\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J3\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u00020\u000f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u0011J3\u0010\u0018\u001a\u00020\u000f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J3\u0010\u0018\u001a\u00020\u000f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u000f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006 "}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/LoggingTrustManagerWrapper;", "Ljavax/net/ssl/X509ExtendedTrustManager;", "wrapped", "(Ljavax/net/ssl/X509ExtendedTrustManager;)V", "getWrapped", "()Ljavax/net/ssl/X509ExtendedTrustManager;", "certPathToString", "", "certPath", "", "Ljava/security/cert/X509Certificate;", "([Ljava/security/cert/X509Certificate;)Ljava/lang/String;", "certPathToStringFull", "chain", "checkClientTrusted", "", "authType", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "socket", "Ljava/net/Socket;", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljava/net/Socket;)V", "engine", "Ljavax/net/ssl/SSLEngine;", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljavax/net/ssl/SSLEngine;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "logErrors", "block", "Lkotlin/Function0;", "([Ljava/security/cert/X509Certificate;Lkotlin/jvm/functions/Function0;)V", "Companion", "node-api"})
public final class LoggingTrustManagerWrapper
extends X509ExtendedTrustManager {
    @NotNull
    private final X509ExtendedTrustManager wrapped;
    @NotNull
    private static final Logger log;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final String certPathToString(X509Certificate[] certPath) {
        void $receiver$iv$iv;
        X509Certificate[] $receiver$iv;
        if (certPath == null) {
            return "<empty certpath>";
        }
        X509Certificate[] x509CertificateArray = $receiver$iv = certPath;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int n = ((void)$receiver$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String string;
            String string2;
            void it;
            void item$iv$iv;
            void var9_8 = item$iv$iv = $receiver$iv$iv[j];
            Collection collection = destination$iv$iv;
            X509CertificateHolder bcCert = X509UtilitiesKt.toBc((X509Certificate)it);
            String subject = bcCert.getSubject().toString();
            String issuer = bcCert.getIssuer().toString();
            try {
                Extension extension = bcCert.getExtension(Extension.subjectKeyIdentifier);
                Intrinsics.checkExpressionValueIsNotNull((Object)extension, (String)"bcCert.getExtension(Exte\u2026ion.subjectKeyIdentifier)");
                SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance((Object)extension.getParsedValue());
                Intrinsics.checkExpressionValueIsNotNull((Object)subjectKeyIdentifier, (String)"SubjectKeyIdentifier.get\u2026yIdentifier).parsedValue)");
                byte[] byArray = subjectKeyIdentifier.getKeyIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"SubjectKeyIdentifier.get\u2026arsedValue).keyIdentifier");
                string2 = EncodingUtils.toHex((byte[])byArray);
            }
            catch (Exception ex) {
                string2 = "null";
            }
            String keyIdentifier = string2;
            try {
                Extension extension = bcCert.getExtension(Extension.authorityKeyIdentifier);
                Intrinsics.checkExpressionValueIsNotNull((Object)extension, (String)"bcCert.getExtension(Exte\u2026n.authorityKeyIdentifier)");
                AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)extension.getParsedValue());
                Intrinsics.checkExpressionValueIsNotNull((Object)authorityKeyIdentifier, (String)"AuthorityKeyIdentifier.g\u2026yIdentifier).parsedValue)");
                byte[] byArray = authorityKeyIdentifier.getKeyIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"AuthorityKeyIdentifier.g\u2026arsedValue).keyIdentifier");
                string = EncodingUtils.toHex((byte[])byArray);
            }
            catch (Exception ex) {
                string = "null";
            }
            String authorityKeyIdentifier = string;
            String string3 = "  " + subject + '[' + keyIdentifier + "] issued by " + issuer + '[' + authorityKeyIdentifier + ']';
            collection.add(string3);
        }
        List certs = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)certs, (CharSequence)"\r\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String certPathToStringFull(X509Certificate[] chain) {
        void $receiver$iv$iv;
        X509Certificate[] $receiver$iv;
        if (chain == null) {
            return "<empty certpath>";
        }
        X509Certificate[] x509CertificateArray = $receiver$iv = chain;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int n = ((void)$receiver$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = $receiver$iv$iv[j];
            Collection collection = destination$iv$iv;
            String string = it.toString();
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final void logErrors(X509Certificate[] chain, Function0<Unit> block) {
        try {
            block.invoke();
        }
        catch (CertificateException ex) {
            log.error("Bad certificate path " + ex.getMessage() + ":\r\n" + this.certPathToStringFull(chain));
            throw (Throwable)ex;
        }
    }

    @Override
    public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType, @Nullable Socket socket) throws CertificateException {
        log.info("Check Client Certpath:\r\n" + this.certPathToString(chain));
        this.logErrors(chain, (Function0<Unit>)((Function0)new Function0<Unit>(this, chain, authType, socket){
            final /* synthetic */ LoggingTrustManagerWrapper this$0;
            final /* synthetic */ X509Certificate[] $chain;
            final /* synthetic */ String $authType;
            final /* synthetic */ Socket $socket;

            public final void invoke() {
                this.this$0.getWrapped().checkClientTrusted(this.$chain, this.$authType, this.$socket);
            }
            {
                this.this$0 = loggingTrustManagerWrapper;
                this.$chain = x509CertificateArray;
                this.$authType = string;
                this.$socket = socket;
                super(0);
            }
        }));
    }

    @Override
    public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType, @Nullable SSLEngine engine) throws CertificateException {
        log.info("Check Client Certpath:\r\n" + this.certPathToString(chain));
        this.logErrors(chain, (Function0<Unit>)((Function0)new Function0<Unit>(this, chain, authType, engine){
            final /* synthetic */ LoggingTrustManagerWrapper this$0;
            final /* synthetic */ X509Certificate[] $chain;
            final /* synthetic */ String $authType;
            final /* synthetic */ SSLEngine $engine;

            public final void invoke() {
                this.this$0.getWrapped().checkClientTrusted(this.$chain, this.$authType, this.$engine);
            }
            {
                this.this$0 = loggingTrustManagerWrapper;
                this.$chain = x509CertificateArray;
                this.$authType = string;
                this.$engine = sSLEngine;
                super(0);
            }
        }));
    }

    @Override
    public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) throws CertificateException {
        log.info("Check Client Certpath:\r\n" + this.certPathToString(chain));
        this.logErrors(chain, (Function0<Unit>)((Function0)new Function0<Unit>(this, chain, authType){
            final /* synthetic */ LoggingTrustManagerWrapper this$0;
            final /* synthetic */ X509Certificate[] $chain;
            final /* synthetic */ String $authType;

            public final void invoke() {
                this.this$0.getWrapped().checkClientTrusted(this.$chain, this.$authType);
            }
            {
                this.this$0 = loggingTrustManagerWrapper;
                this.$chain = x509CertificateArray;
                this.$authType = string;
                super(0);
            }
        }));
    }

    @Override
    public void checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType, @Nullable Socket socket) throws CertificateException {
        log.info("Check Server Certpath:\r\n" + this.certPathToString(chain));
        this.logErrors(chain, (Function0<Unit>)((Function0)new Function0<Unit>(this, chain, authType, socket){
            final /* synthetic */ LoggingTrustManagerWrapper this$0;
            final /* synthetic */ X509Certificate[] $chain;
            final /* synthetic */ String $authType;
            final /* synthetic */ Socket $socket;

            public final void invoke() {
                this.this$0.getWrapped().checkServerTrusted(this.$chain, this.$authType, this.$socket);
            }
            {
                this.this$0 = loggingTrustManagerWrapper;
                this.$chain = x509CertificateArray;
                this.$authType = string;
                this.$socket = socket;
                super(0);
            }
        }));
    }

    @Override
    public void checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType, @Nullable SSLEngine engine) throws CertificateException {
        log.info("Check Server Certpath:\r\n" + this.certPathToString(chain));
        this.logErrors(chain, (Function0<Unit>)((Function0)new Function0<Unit>(this, chain, authType, engine){
            final /* synthetic */ LoggingTrustManagerWrapper this$0;
            final /* synthetic */ X509Certificate[] $chain;
            final /* synthetic */ String $authType;
            final /* synthetic */ SSLEngine $engine;

            public final void invoke() {
                this.this$0.getWrapped().checkServerTrusted(this.$chain, this.$authType, this.$engine);
            }
            {
                this.this$0 = loggingTrustManagerWrapper;
                this.$chain = x509CertificateArray;
                this.$authType = string;
                this.$engine = sSLEngine;
                super(0);
            }
        }));
    }

    @Override
    public void checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) throws CertificateException {
        log.info("Check Server Certpath:\r\n" + this.certPathToString(chain));
        this.logErrors(chain, (Function0<Unit>)((Function0)new Function0<Unit>(this, chain, authType){
            final /* synthetic */ LoggingTrustManagerWrapper this$0;
            final /* synthetic */ X509Certificate[] $chain;
            final /* synthetic */ String $authType;

            public final void invoke() {
                this.this$0.getWrapped().checkServerTrusted(this.$chain, this.$authType);
            }
            {
                this.this$0 = loggingTrustManagerWrapper;
                this.$chain = x509CertificateArray;
                this.$authType = string;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = this.wrapped.getAcceptedIssuers();
        Intrinsics.checkExpressionValueIsNotNull((Object)x509CertificateArray, (String)"wrapped.acceptedIssuers");
        return x509CertificateArray;
    }

    @NotNull
    public final X509ExtendedTrustManager getWrapped() {
        return this.wrapped;
    }

    public LoggingTrustManagerWrapper(@NotNull X509ExtendedTrustManager wrapped) {
        Intrinsics.checkParameterIsNotNull((Object)wrapped, (String)"wrapped");
        this.wrapped = wrapped;
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/internal/protonwrapper/netty/LoggingTrustManagerWrapper$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        @NotNull
        public final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

