/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.protonwrapper.netty;

import io.netty.handler.ssl.SslHandler;
import java.security.KeyStore;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathChecker;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.SecureHash;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.ArtemisTcpTransport;
import net.corda.nodeapi.internal.config.CertificateStore;
import net.corda.nodeapi.internal.protonwrapper.netty.LoggingTrustManagerWrapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a.\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\bH\u0000\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0011\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"HOSTNAME_FORMAT", "", "createClientSslHelper", "Lio/netty/handler/ssl/SslHandler;", "target", "Lnet/corda/core/utilities/NetworkHostAndPort;", "expectedRemoteLegalNames", "", "Lnet/corda/core/identity/CordaX500Name;", "keyManagerFactory", "Ljavax/net/ssl/KeyManagerFactory;", "trustManagerFactory", "Ljavax/net/ssl/TrustManagerFactory;", "createServerSslHelper", "initialiseTrustStoreAndEnableCrlChecking", "Ljavax/net/ssl/ManagerFactoryParameters;", "trustStore", "Lnet/corda/nodeapi/internal/config/CertificateStore;", "crlCheckSoftFail", "", "x500toHostName", "x500Name", "init", "", "keyStore", "node-api"})
public final class SSLHelperKt {
    private static final String HOSTNAME_FORMAT = "%s.corda.net";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SslHandler createClientSslHelper(@NotNull NetworkHostAndPort target, @NotNull Set<CordaX500Name> expectedRemoteLegalNames, @NotNull KeyManagerFactory keyManagerFactory, @NotNull TrustManagerFactory trustManagerFactory) {
        Collection $receiver$iv;
        SSLEngine sslEngine;
        String[] stringArray;
        Object object;
        void $receiver$iv$iv;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(expectedRemoteLegalNames, (String)"expectedRemoteLegalNames");
        Intrinsics.checkParameterIsNotNull((Object)keyManagerFactory, (String)"keyManagerFactory");
        Intrinsics.checkParameterIsNotNull((Object)trustManagerFactory, (String)"trustManagerFactory");
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        Object[] objectArray = trustManagerFactory.getTrustManagers();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"trustManagerFactory.trustManagers");
        Iterable iterable = $receiver$iv2 = (Iterable)ArraysKt.filterIsInstance((Object[])objectArray, X509ExtendedTrustManager.class);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            X509ExtendedTrustManager x509ExtendedTrustManager = (X509ExtendedTrustManager)item$iv$iv;
            object = destination$iv$iv;
            stringArray = new LoggingTrustManagerWrapper((X509ExtendedTrustManager)it);
            object.add(stringArray);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv2;
        LoggingTrustManagerWrapper[] loggingTrustManagerWrapperArray = thisCollection$iv.toArray(new LoggingTrustManagerWrapper[0]);
        if (loggingTrustManagerWrapperArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        LoggingTrustManagerWrapper[] trustManagers = loggingTrustManagerWrapperArray;
        sslContext.init(keyManagers, trustManagers, CryptoUtils.newSecureRandom());
        SSLEngine sSLEngine = sslEngine = sslContext.createSSLEngine(target.getHost(), target.getPort());
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLEngine, (String)"sslEngine");
        sSLEngine.setUseClientMode(true);
        thisCollection$iv = ArtemisTcpTransport.Companion.getTLS_VERSIONS();
        object = sslEngine;
        void v3 = $receiver$iv;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv2 = v3;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        stringArray = stringArray2;
        ((SSLEngine)object).setEnabledProtocols(stringArray);
        $receiver$iv = ArtemisTcpTransport.Companion.getCIPHER_SUITES();
        object = sslEngine;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv2 = collection;
        String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        stringArray = stringArray3;
        ((SSLEngine)object).setEnabledCipherSuites(stringArray);
        sslEngine.setEnableSessionCreation(true);
        if (expectedRemoteLegalNames.size() == 1) {
            SSLParameters sslParameters;
            SSLParameters sSLParameters = sslParameters = sslEngine.getSSLParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLParameters, (String)"sslParameters");
            sSLParameters.setServerNames(CollectionsKt.listOf((Object)new SNIHostName(SSLHelperKt.x500toHostName((CordaX500Name)CollectionsKt.single((Iterable)expectedRemoteLegalNames)))));
            sslEngine.setSSLParameters(sslParameters);
        }
        return new SslHandler(sslEngine);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SslHandler createServerSslHelper(@NotNull KeyManagerFactory keyManagerFactory, @NotNull TrustManagerFactory trustManagerFactory) {
        Collection $receiver$iv;
        SSLEngine sslEngine;
        String[] stringArray;
        Object object;
        void $receiver$iv$iv;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)keyManagerFactory, (String)"keyManagerFactory");
        Intrinsics.checkParameterIsNotNull((Object)trustManagerFactory, (String)"trustManagerFactory");
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        Object[] objectArray = trustManagerFactory.getTrustManagers();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"trustManagerFactory.trustManagers");
        Iterable iterable = $receiver$iv2 = (Iterable)ArraysKt.filterIsInstance((Object[])objectArray, X509ExtendedTrustManager.class);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            X509ExtendedTrustManager x509ExtendedTrustManager = (X509ExtendedTrustManager)item$iv$iv;
            object = destination$iv$iv;
            stringArray = new LoggingTrustManagerWrapper((X509ExtendedTrustManager)it);
            object.add(stringArray);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv2;
        LoggingTrustManagerWrapper[] loggingTrustManagerWrapperArray = thisCollection$iv.toArray(new LoggingTrustManagerWrapper[0]);
        if (loggingTrustManagerWrapperArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        LoggingTrustManagerWrapper[] trustManagers = loggingTrustManagerWrapperArray;
        sslContext.init(keyManagers, trustManagers, CryptoUtils.newSecureRandom());
        SSLEngine sSLEngine = sslEngine = sslContext.createSSLEngine();
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLEngine, (String)"sslEngine");
        sSLEngine.setUseClientMode(false);
        sslEngine.setNeedClientAuth(true);
        thisCollection$iv = ArtemisTcpTransport.Companion.getTLS_VERSIONS();
        object = sslEngine;
        void v3 = $receiver$iv;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv2 = v3;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        stringArray = stringArray2;
        ((SSLEngine)object).setEnabledProtocols(stringArray);
        $receiver$iv = ArtemisTcpTransport.Companion.getCIPHER_SUITES();
        object = sslEngine;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv2 = collection;
        String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        stringArray = stringArray3;
        ((SSLEngine)object).setEnabledCipherSuites(stringArray);
        sslEngine.setEnableSessionCreation(true);
        return new SslHandler(sslEngine);
    }

    @NotNull
    public static final ManagerFactoryParameters initialiseTrustStoreAndEnableCrlChecking(@NotNull CertificateStore trustStore, boolean crlCheckSoftFail) {
        CertPathBuilder certPathBuilder;
        Intrinsics.checkParameterIsNotNull((Object)trustStore, (String)"trustStore");
        CertPathBuilder certPathBuilder2 = certPathBuilder = CertPathBuilder.getInstance("PKIX");
        Intrinsics.checkExpressionValueIsNotNull((Object)certPathBuilder2, (String)"certPathBuilder");
        CertPathChecker certPathChecker = certPathBuilder2.getRevocationChecker();
        if (certPathChecker == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.cert.PKIXRevocationChecker");
        }
        PKIXRevocationChecker revocationChecker = (PKIXRevocationChecker)certPathChecker;
        revocationChecker.setOptions((Set<PKIXRevocationChecker.Option>)EnumSet.of((Enum)PKIXRevocationChecker.Option.PREFER_CRLS, (Enum)PKIXRevocationChecker.Option.NO_FALLBACK));
        if (crlCheckSoftFail) {
            Set<PKIXRevocationChecker.Option> set2 = revocationChecker.getOptions();
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"revocationChecker.options");
            revocationChecker.setOptions(SetsKt.plus(set2, (Object)((Object)PKIXRevocationChecker.Option.SOFT_FAIL)));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustStore.getValue().getInternal(), (CertSelector)new X509CertSelector());
        pkixParams.addCertPathChecker(revocationChecker);
        return new CertPathTrustManagerParameters(pkixParams);
    }

    public static final void init(@NotNull KeyManagerFactory $receiver, @NotNull CertificateStore keyStore) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)keyStore, (String)"keyStore");
        String string = keyStore.getEntryPassword();
        KeyStore keyStore2 = keyStore.getValue().getInternal();
        KeyManagerFactory keyManagerFactory = $receiver;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        keyManagerFactory.init(keyStore2, cArray2);
    }

    public static final void init(@NotNull TrustManagerFactory $receiver, @NotNull CertificateStore trustStore) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)trustStore, (String)"trustStore");
        $receiver.init(trustStore.getValue().getInternal());
    }

    @NotNull
    public static final String x500toHostName(@NotNull CordaX500Name x500Name) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)x500Name, (String)"x500Name");
        SecureHash.SHA256 secureHash = SecureHash.Companion.sha256(x500Name.toString());
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = HOSTNAME_FORMAT;
        Object[] objectArray2 = StringsKt.take((String)secureHash.toString(), (int)32);
        int n = 0;
        Object[] objectArray3 = objectArray = new Object[1];
        if (objectArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = objectArray2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        objectArray[n] = string3;
        objectArray2 = objectArray3;
        String string4 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }
}

