/*
 * Decompiled with CFR 0.152.
 */
package net.corda.webserver;

import com.google.common.base.Throwables;
import com.typesafe.config.ConfigException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.InternalUtilsKt;
import net.corda.webserver.ArgsParser;
import net.corda.webserver.CmdLineOptions;
import net.corda.webserver.WebServerConfig;
import net.corda.webserver.internal.NodeWebServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "webserver_main"})
@JvmName(name="WebServer")
public final class WebServer {
    public static final void main(@NotNull String[] args) {
        WebServerConfig webServerConfig;
        CmdLineOptions cmdLineOptions;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        long startTime = System.currentTimeMillis();
        ArgsParser argsParser = new ArgsParser();
        try {
            cmdLineOptions = argsParser.parse(Arrays.copyOf(args, args.length));
        }
        catch (Exception ex) {
            String string = "Unknown command line arguments: " + ex.getMessage();
            System.out.println((Object)string);
            int n = 1;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        CmdLineOptions cmdlineOptions = cmdLineOptions;
        if (cmdlineOptions.getHelp()) {
            PrintStream printStream = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
            argsParser.printHelp(printStream);
            int n = 0;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (cmdlineOptions.getLogToConsole()) {
            System.setProperty("consoleLogLevel", "info");
        }
        System.setProperty("log-path", ((Object)InternalUtilsKt.div((Path)cmdlineOptions.getBaseDirectory(), (String)"logs/web")).toString());
        Logger log = LoggerFactory.getLogger((String)"Main");
        String ex = "Logs can be found in " + System.getProperty("log-path");
        System.out.println((Object)ex);
        try {
            webServerConfig = new WebServerConfig(cmdlineOptions.getBaseDirectory(), CmdLineOptions.loadConfig$default(cmdlineOptions, false, null, 3, null));
        }
        catch (ConfigException e) {
            String $receiver$iv22;
            Throwable throwable = e;
            StringBuilder stringBuilder = new StringBuilder().append("Unable to load the configuration file: ");
            Throwable throwable2 = Throwables.getRootCause((Throwable)((Object)$receiver$iv22));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable2, (String)"Throwables.getRootCause(this)");
            Throwable throwable3 = throwable2;
            $receiver$iv22 = stringBuilder.append(throwable3.getMessage()).toString();
            System.out.println((Object)$receiver$iv22);
            int $receiver$iv22 = 2;
            System.exit($receiver$iv22);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        WebServerConfig conf = webServerConfig;
        log.info("Main class: " + WebServerConfig.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        RuntimeMXBean info = ManagementFactory.getRuntimeMXBean();
        log.info("CommandLine Args: " + CollectionsKt.joinToString$default((Iterable)info.getInputArguments(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        log.info("Application Args: " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        log.info("bootclasspath: " + info.getBootClassPath());
        log.info("classpath: " + info.getClassPath());
        log.info("VM " + info.getVmName() + " " + info.getVmVendor() + " " + info.getVmVersion());
        log.info("Machine: " + InetAddress.getLocalHost().getHostName());
        log.info("Working Directory: " + cmdlineOptions.getBaseDirectory());
        log.info("Starting as webserver on " + conf.getWebAddress());
        try {
            NodeWebServer server = new NodeWebServer(conf);
            server.start();
            double elapsed = (double)((System.currentTimeMillis() - startTime) / (long)10) / 100.0;
            String string = "Webserver started up in " + elapsed + " sec";
            System.out.println((Object)string);
            server.run();
        }
        catch (Exception e) {
            log.error("Exception during node startup", (Throwable)e);
            int n = 1;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }
}

