/*
 * Decompiled with CFR 0.152.
 */
package net.corda.webserver.internal;

import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.node.NodeInfo;
import net.corda.webserver.api.APIServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lnet/corda/webserver/internal/APIServerImpl;", "Lnet/corda/webserver/api/APIServer;", "rpcOps", "Lnet/corda/core/messaging/CordaRPCOps;", "(Lnet/corda/core/messaging/CordaRPCOps;)V", "getRpcOps", "()Lnet/corda/core/messaging/CordaRPCOps;", "info", "Lnet/corda/core/node/NodeInfo;", "serverTime", "Ljava/time/LocalDateTime;", "status", "Ljavax/ws/rs/core/Response;", "webserver_main"})
public final class APIServerImpl
implements APIServer {
    @NotNull
    private final CordaRPCOps rpcOps;

    @Override
    @NotNull
    public LocalDateTime serverTime() {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(this.rpcOps.currentNodeTime(), ZoneId.of("UTC"));
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.ofInstant(\u2026Time(), ZoneId.of(\"UTC\"))");
        return localDateTime;
    }

    @Override
    @NotNull
    public Response status() {
        Response response = Response.ok((Object)"started").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(\"started\").build()");
        return response;
    }

    @Override
    @NotNull
    public NodeInfo info() {
        return this.rpcOps.nodeIdentity();
    }

    @NotNull
    public final CordaRPCOps getRpcOps() {
        return this.rpcOps;
    }

    public APIServerImpl(@NotNull CordaRPCOps rpcOps) {
        Intrinsics.checkParameterIsNotNull((Object)rpcOps, (String)"rpcOps");
        this.rpcOps = rpcOps;
    }
}

