/*
 * Decompiled with CFR 0.152.
 */
package net.corda.webserver.servlets;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.contracts.StructuresKt;
import net.corda.core.crypto.SecureHash;
import net.corda.core.messaging.CordaRPCOps;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/corda/webserver/servlets/AttachmentDownloadServlet;", "Ljavax/servlet/http/HttpServlet;", "()V", "log", "Lorg/slf4j/Logger;", "doGet", "", "req", "Ljavax/servlet/http/HttpServletRequest;", "resp", "Ljavax/servlet/http/HttpServletResponse;", "webserver_main"})
public final class AttachmentDownloadServlet
extends HttpServlet {
    private final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(@NotNull HttpServletRequest req, @NotNull HttpServletResponse resp) throws IOException {
        String reqPath;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
        Intrinsics.checkParameterIsNotNull((Object)resp, (String)"resp");
        String string2 = req.getPathInfo();
        if (string2 != null) {
            String string3 = string2;
            int n = 1;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = reqPath = null;
        }
        if (reqPath == null) {
            resp.sendError(400);
            return;
        }
        try {
            SecureHash.SHA256 hash = SecureHash.Companion.parse(StringsKt.substringBefore$default((String)reqPath, (char)'/', null, (int)2, null));
            Object object = this.getServletContext().getAttribute("rpc");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.core.messaging.CordaRPCOps");
            }
            CordaRPCOps rpc = (CordaRPCOps)object;
            InputStream attachment = rpc.openAttachment((SecureHash)hash);
            Object object2 = StringsKt.substringAfter((String)reqPath, (char)'/', (String)"");
            String string6 = object2;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
            String subPath = string7;
            resp.setContentType("application/octet-stream");
            object2 = subPath;
            if (object2.length() == 0) {
                resp.addHeader("Content-Disposition", "attachment; filename=" + "\"" + hash + ".zip" + "\"");
                object2 = attachment;
                boolean bl = false;
                try {
                    InputStream it = (InputStream)object2;
                    ServletOutputStream servletOutputStream = resp.getOutputStream();
                    Intrinsics.checkExpressionValueIsNotNull((Object)servletOutputStream, (String)"resp.outputStream");
                    Long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)servletOutputStream), (int)0, (int)2, null);
                }
                catch (Exception exception) {
                    bl = true;
                    try {
                        Object object3 = object2;
                        if (object3 != null) {
                            object3.close();
                        }
                    }
                    catch (Exception $i$a$1$use) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                finally {
                    if (!bl) {
                        Object object4 = object2;
                        if (object4 != null) {
                            object4.close();
                        }
                    }
                }
            }
            String filename = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)subPath, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null));
            resp.addHeader("Content-Disposition", "attachment; filename=" + "\"" + filename + "\"");
            Closeable closeable = new JarInputStream(attachment);
            boolean bl = false;
            try {
                JarInputStream it = (JarInputStream)closeable;
                ServletOutputStream servletOutputStream = resp.getOutputStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)servletOutputStream, (String)"resp.outputStream");
                StructuresKt.extractFile((JarInputStream)it, (String)subPath, (OutputStream)((OutputStream)servletOutputStream));
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    closeable.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    closeable.close();
                }
            }
            resp.getOutputStream().close();
        }
        catch (FileNotFoundException e) {
            this.log.warn("404 Not Found whilst trying to handle attachment download request for " + this.getServletContext().getContextPath() + "/" + reqPath);
            resp.sendError(404);
            return;
        }
    }

    public AttachmentDownloadServlet() {
        Logger logger;
        AttachmentDownloadServlet attachmentDownloadServlet = this;
        Logger logger2 = LoggerFactory.getLogger(AttachmentDownloadServlet.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LoggerFactory.getLogger(T::class.java)");
        attachmentDownloadServlet.log = logger = logger2;
    }
}

