/*
 * Decompiled with CFR 0.152.
 */
package net.corda.webserver.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.messaging.CordaRPCOps;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/corda/webserver/servlets/DataUploadServlet;", "Ljavax/servlet/http/HttpServlet;", "()V", "log", "Lorg/slf4j/Logger;", "doPost", "", "req", "Ljavax/servlet/http/HttpServletRequest;", "resp", "Ljavax/servlet/http/HttpServletResponse;", "webserver_main"})
public final class DataUploadServlet
extends HttpServlet {
    private final Logger log;

    protected void doPost(@NotNull HttpServletRequest req, @NotNull HttpServletResponse resp) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
        Intrinsics.checkParameterIsNotNull((Object)resp, (String)"resp");
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        Object object = this.getServletContext().getAttribute("rpc");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.core.messaging.CordaRPCOps");
        }
        CordaRPCOps rpc = (CordaRPCOps)object;
        if (!isMultipart) {
            resp.sendError(400, "This end point is for data uploads only.");
            return;
        }
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator iterator = upload.getItemIterator(req);
        ArrayList messages = new ArrayList();
        if (!iterator.hasNext()) {
            resp.sendError(400, "Got an upload request with no files");
            return;
        }
        while (iterator.hasNext()) {
            FileItemStream item = iterator.next();
            this.log.info("Receiving " + item.getName());
            try {
                Object object2 = req.getPathInfo();
                int n = 1;
                Object object3 = object2;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object3).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                String dataType = StringsKt.substringBefore$default((String)string, (char)'/', null, (int)2, null);
                object2 = messages;
                String string2 = item.getName();
                InputStream inputStream = item.openStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"item.openStream()");
                String string3 = rpc.uploadFile(dataType, string2, inputStream);
                object2.add(string3);
                this.log.info(item.getName() + " successfully accepted: " + (String)CollectionsKt.last((List)messages));
            }
            catch (RuntimeException e) {
                System.out.println(e);
                resp.sendError(400, "Got a file upload request for an unknown data type");
            }
        }
        PrintWriter writer = resp.getWriter();
        Iterable $receiver$iv = messages;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            writer.println(it);
        }
    }

    public DataUploadServlet() {
        Logger logger;
        DataUploadServlet dataUploadServlet = this;
        Logger logger2 = LoggerFactory.getLogger(DataUploadServlet.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LoggerFactory.getLogger(T::class.java)");
        dataUploadServlet.log = logger = logger2;
    }
}

