/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.collections;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.csdn.common.exception.ArgumentErrorException;
import net.csdn.common.reflect.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WowCollections {
    public static final Map EMPTY_MAP = WowCollections.map(new Object[0]);
    public static final List EMPTY_LIST = WowCollections.list(new Object[0]);

    public static <T> Set<T> newHashSet(T ... arrays) {
        HashSet<T> sets = new HashSet<T>(arrays.length);
        for (T t : arrays) {
            sets.add(t);
        }
        return sets;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static Map selectMap(Map map, String ... keys) {
        HashMap temp = new HashMap();
        for (String key : keys) {
            temp.put(key, map.get(key));
        }
        return temp;
    }

    public static Map selectMapWithAliasName(Map map, String ... keys) {
        HashMap temp = new HashMap();
        temp.putAll(map);
        for (int i = 0; i < keys.length; ++i) {
            String oldKey = keys[i];
            String newKey = keys[++i];
            if (!map.containsKey(oldKey)) continue;
            temp.put(newKey, map.get(oldKey));
            temp.remove(oldKey);
        }
        return temp;
    }

    public static Map selectMapWithAliasNameInclude(Map map, String ... keys) {
        HashMap temp = new HashMap();
        for (int i = 0; i < keys.length; ++i) {
            String oldKey = keys[i];
            String newKey = keys[++i];
            if (!map.containsKey(oldKey)) continue;
            temp.put(newKey, map.get(oldKey));
        }
        return temp;
    }

    public static Map map(Object ... arrays) {
        HashMap<Object, Object> maps = new HashMap<Object, Object>();
        if (arrays.length % 2 != 0) {
            throw new ArgumentErrorException("arrays \u957f\u5ea6 \u5fc5\u987b\u4e3a\u5076\u6570");
        }
        for (int i = 0; i < arrays.length; ++i) {
            maps.put(arrays[i], arrays[++i]);
        }
        return maps;
    }

    public static <T> List<T> list(T ... arrays) {
        ArrayList<T> list = new ArrayList<T>(arrays.length);
        for (T t : arrays) {
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> projectionColumn(List<Map> maps, String column) {
        ArrayList lists = new ArrayList(maps.size());
        for (Map temp : maps) {
            lists.add(temp.get(column));
        }
        return lists;
    }

    public static String join(Collection collection, String split) {
        if (collection.size() == 0) {
            return "";
        }
        if (split.isEmpty()) {
            return WowCollections.join(collection);
        }
        Iterator ite = collection.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (ite.hasNext()) {
            stringBuffer.append(ite.next() + split);
        }
        return stringBuffer.substring(0, stringBuffer.length() - split.length());
    }

    public static String join(Collection collection) {
        if (collection.size() == 0) {
            return null;
        }
        Iterator ite = collection.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (ite.hasNext()) {
            stringBuffer.append(ite.next());
        }
        return stringBuffer.toString();
    }

    public static List<List> splitList(List list, int size) {
        return Lists.partition((List)list, (int)size);
    }

    public static List project(List<Map> list, String key) {
        ArrayList list1 = new ArrayList(list.size());
        for (Map map : list) {
            list1.add(map.get(key));
        }
        return list1;
    }

    public static List projectByMethod(List list, String method, Object ... params) {
        ArrayList<Object> list1 = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            list1.add(ReflectHelper.method(obj, method, params));
        }
        return list1;
    }

    public static Map doubleListToMap(List keys, List values) {
        HashMap map = new HashMap();
        int keys_size = keys.size();
        int values_size = values.size();
        assert (keys_size == values_size);
        for (int i = 0; i < keys_size; ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    public static String join(Collection collection, String split, String wrapper) {
        if (collection.size() == 0) {
            return null;
        }
        Iterator ite = collection.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (ite.hasNext()) {
            stringBuffer.append(wrapper + ite.next() + wrapper + split);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static String join(Object[] collection, String split, String wrapper) {
        if (collection.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object obj : collection) {
            stringBuffer.append(wrapper + obj + wrapper + split);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static String getString(Map map, String key) {
        return (String)map.get(key);
    }

    public static String getStringNoNull(Map map, String key) {
        String s = (String)map.get(key);
        if (s == null) {
            return "";
        }
        return s;
    }

    public static Date getDate(Map map, String key) {
        return new Date(((Timestamp)map.get(key)).getTime());
    }

    public static long getDateAsLong(Map map, String key) {
        return ((Timestamp)map.get(key)).getTime();
    }

    public static int getInt(Map map, String key) {
        return (Integer)map.get(key);
    }

    public static long getLong(Map map, String key) {
        return (Long)map.get(key);
    }

    public static Map getMap(Map map, String key) {
        return (Map)map.get(key);
    }

    public static Boolean getBoolean(Map map, String key) {
        return (Boolean)map.get(key);
    }

    public static Set hashSet(Object[] array) {
        HashSet<Object> sets = new HashSet<Object>();
        for (Object obj : array) {
            sets.add(obj);
        }
        return sets;
    }

    public static List toList(Object[] array) {
        ArrayList<Object> lists = new ArrayList<Object>();
        for (Object obj : array) {
            lists.add(obj);
        }
        return lists;
    }

    public static Set hashSet(int[] array) {
        HashSet<Integer> sets = new HashSet<Integer>();
        for (int obj : array) {
            sets.add(obj);
        }
        return sets;
    }

    public static String join(Object[] arrays, String split) {
        if (arrays == null || arrays.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object obj : arrays) {
            stringBuffer.append(obj + split);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static String join(int[] arrays, String split) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int obj : arrays) {
            stringBuffer.append(obj + split);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static Iterable<String> split(String s, String seperator) {
        return Splitter.on((String)seperator).split((CharSequence)s);
    }

    public static List<String> split2(String s, String seperator) {
        if (WowCollections.isEmpty(s)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)Splitter.on((String)seperator).split((CharSequence)s));
    }

    public static List<String> split2SkipEmpty(String s, String seperator) {
        if (WowCollections.isEmpty(s)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        for (String temp : Splitter.on((String)seperator).split((CharSequence)s)) {
            if (WowCollections.isEmpty(temp)) continue;
            list.add(temp);
        }
        return list;
    }

    public static List<Integer> split2IntoInt(String s, String seperator) {
        if (WowCollections.isEmpty(s)) {
            return Lists.newArrayList();
        }
        ArrayList ids = Lists.newArrayList();
        for (String temp : Splitter.on((String)seperator).split((CharSequence)s)) {
            try {
                ids.add(Integer.parseInt(temp));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ids;
    }

    public static List<Integer> split2IntoDouble(String s, String seperator) {
        if (WowCollections.isEmpty(s)) {
            return Lists.newArrayList();
        }
        ArrayList ids = Lists.newArrayList();
        for (String temp : Splitter.on((String)seperator).split((CharSequence)s)) {
            try {
                ids.add(Double.parseDouble(temp));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ids;
    }

    public static List<Integer> split2IntoLong(String s, String seperator) {
        if (WowCollections.isEmpty(s)) {
            return Lists.newArrayList();
        }
        ArrayList ids = Lists.newArrayList();
        for (String temp : Splitter.on((String)seperator).split((CharSequence)s)) {
            try {
                ids.add(Long.parseLong(temp));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ids;
    }

    public static Iterable<String> splitWithRegex(String s, String seperatorPattern) {
        if (WowCollections.isEmpty(s)) {
            return Lists.newArrayList();
        }
        return Splitter.onPattern((String)seperatorPattern).split((CharSequence)s);
    }

    public static <K, V> List iterateMap(Map<K, V> map, MapIterator mapIterator) {
        List<Object> list = WowCollections.list(new Object[0]);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Object t = mapIterator.iterate(entry.getKey(), entry.getValue());
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    public static <K, V> List iterate_map(Map<K, V> map, MapIterator mapIterator) {
        return WowCollections.iterateMap(map, mapIterator);
    }

    public static List subList(List temp, int size) {
        return temp.subList(0, size > temp.size() ? temp.size() : size);
    }

    public static List subList(List temp, int start, int size) {
        if (start > temp.size() - 1) {
            return Lists.newArrayList();
        }
        int tempSize = start + size;
        return temp.subList(start, tempSize > temp.size() ? temp.size() : tempSize);
    }

    public static void uniqList(List list) {
    }

    public static <K> List iterateList(List<K> list, ListIterator<K> listIterator) {
        List<Object> result = WowCollections.list(new Object[0]);
        for (K obj : list) {
            Object t = listIterator.iterate(obj);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <K> List iterate_list(List<K> list, ListIterator<K> listIterator) {
        return WowCollections.iterateList(list, listIterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ListIterator<K> {
        public Object iterate(K var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapIterator<K, V> {
        public Object iterate(K var1, V var2);
    }
}

