/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.logging.log4j;

import net.csdn.common.logging.log4j.Log4jFactory;
import net.csdn.common.logging.support.AbstractCSLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jCSLogger
extends AbstractCSLogger {
    private final Logger logger;

    public Log4jCSLogger(String prefix, Logger logger) {
        super(prefix);
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isHadooEnabled() {
        return this.logger.isEnabledFor((Priority)Log4jFactory.CSLogLevel.HADOO_LEVEL);
    }

    protected void internalHadoo(String msg) {
        this.logger.log((Priority)Log4jFactory.CSLogLevel.HADOO_LEVEL, (Object)msg);
    }

    protected void internalHadoo(String msg, Throwable cause) {
        this.logger.log((Priority)Log4jFactory.CSLogLevel.HADOO_LEVEL, (Object)msg, cause);
    }

    protected void internalTrace(String msg) {
        this.logger.trace((Object)msg);
    }

    protected void internalTrace(String msg, Throwable cause) {
        this.logger.trace((Object)msg, cause);
    }

    protected void internalDebug(String msg) {
        this.logger.debug((Object)msg);
    }

    protected void internalDebug(String msg, Throwable cause) {
        this.logger.debug((Object)msg, cause);
    }

    protected void internalInfo(String msg) {
        this.logger.info((Object)msg);
    }

    protected void internalInfo(String msg, Throwable cause) {
        this.logger.info((Object)msg, cause);
    }

    protected void internalWarn(String msg) {
        this.logger.warn((Object)msg);
    }

    protected void internalWarn(String msg, Throwable cause) {
        this.logger.warn((Object)msg, cause);
    }

    protected void internalError(String msg) {
        this.logger.error((Object)msg);
    }

    protected void internalError(String msg, Throwable cause) {
        this.logger.error((Object)msg, cause);
    }
}

