/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.path;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.csdn.common.collect.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Url {
    private String schema = "http";
    private String host;
    private List<String> path = Lists.newArrayList();
    private int port = 80;
    private List<Tuple> query = Lists.newArrayList();

    public Url() {
    }

    public Url(URI uri) {
        this.schema = uri.getScheme();
        this.host = uri.getHost();
        this.parsePath(uri.getPath());
        this.parseQuery(uri.getQuery());
        this.port = uri.getPort() == -1 ? 80 : uri.getPort();
    }

    public static List<Url> urls(String[] hosts, String path, String ... queries) {
        ArrayList<Url> urls = new ArrayList<Url>(hosts.length);
        for (String host : hosts) {
            Url url = new Url();
            url.hostAndPort(host);
            url.path(path);
            if (queries != null) {
                for (String query : queries) {
                    url.query(query);
                }
            }
            urls.add(url);
        }
        return urls;
    }

    public static List<Url> urls(String[] hosts, String path, Map params, String ... queries) {
        ArrayList<Url> urls = new ArrayList<Url>(hosts.length);
        for (String host : hosts) {
            Url url = new Url();
            url.hostAndPort(host);
            url.path(path);
            if (params != null) {
                url.query(params);
            }
            if (queries != null) {
                for (String query : queries) {
                    url.query(query);
                }
            }
            urls.add(url);
        }
        return urls;
    }

    private void parsePath(String _path) {
        String[] paths;
        if (_path == null) {
            return;
        }
        for (String temp : paths = _path.split("/")) {
            if (temp.isEmpty()) continue;
            this.path.add(temp);
        }
    }

    private void parseQuery(String _query) {
        String[] queries;
        if (_query == null) {
            return;
        }
        for (String temp : queries = _query.split("&")) {
            if (temp.isEmpty() || !temp.contains("=")) continue;
            String[] key_pair = temp.split("=");
            this.query.add(new Tuple<String, String>(key_pair[0], key_pair[1]));
        }
    }

    public Url hostAndPort(String hostAndPort) {
        String[] hostAndPortArray = hostAndPort.split(":");
        this.host = hostAndPortArray[0];
        this.port = Integer.parseInt(hostAndPortArray[1]);
        return this;
    }

    public String hostAndPort() {
        return this.host + ":" + this.port;
    }

    public Url query(String query) {
        this.parseQuery(query);
        return this;
    }

    public Url query(Map _query) {
        for (Object key : _query.keySet()) {
            this.addParam(key.toString(), _query.get(key).toString());
        }
        return this;
    }

    public Url path(String path) {
        this.parsePath(path);
        return this;
    }

    public Url(String url) {
        this(URI.create(url));
    }

    public Url addParam(String key, String value) {
        this.query.add(new Tuple<String, String>(key, value));
        return this;
    }

    public String getPath() {
        String result = "";
        for (String temp : this.path) {
            result = result + "/" + temp;
        }
        return result;
    }

    public String getQuery() {
        String result = "";
        for (Tuple temp : this.query) {
            result = result + "&" + (String)temp.v1() + "=" + (String)temp.v2();
        }
        if (result.isEmpty()) {
            return result;
        }
        return result.substring(1);
    }

    public String toString() {
        String url = this.schema + "://" + this.host + ":" + this.port + this.getPath();
        String query = this.getQuery();
        if (query != null && !query.isEmpty()) {
            url = url + "?" + query;
        }
        return url;
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

