/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.scan.component;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import net.csdn.common.scan.component.DirectoryIteratorFactory;
import net.csdn.common.scan.component.FileProtocolIteratorFactory;
import net.csdn.common.scan.component.Filter;
import net.csdn.common.scan.component.JarIterator;
import net.csdn.common.scan.component.StreamIterator;

public class IteratorFactory {
    private static final ConcurrentHashMap<String, DirectoryIteratorFactory> registry = new ConcurrentHashMap();

    public static StreamIterator create(URL url, Filter filter) throws IOException {
        String urlString = url.toString();
        if (urlString.endsWith("!/")) {
            urlString = urlString.substring(4);
            urlString = urlString.substring(0, urlString.length() - 2);
            url = new URL(urlString);
        }
        if (!urlString.endsWith("/")) {
            return new JarIterator(url.openStream(), filter);
        }
        DirectoryIteratorFactory factory = registry.get(url.getProtocol());
        if (factory == null) {
            throw new IOException("Unable to scan directory of protocol: " + url.getProtocol());
        }
        return factory.create(url, filter);
    }

    static {
        registry.put("file", new FileProtocolIteratorFactory());
    }
}

