/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.settings;

import java.io.InputStream;
import net.csdn.common.Strings;
import net.csdn.common.collect.Tuple;
import net.csdn.common.env.Environment;
import net.csdn.common.settings.ImmutableSettings;
import net.csdn.common.settings.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalSettingsPreparer {
    public static Tuple<Settings, Environment> prepareSettings(Settings pSettings) {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder().put(pSettings);
        if (settingsBuilder.get("cluster.name") == null) {
            settingsBuilder.put("cluster.name", "csdn_search");
        }
        Environment environment = new Environment(settingsBuilder.build());
        settingsBuilder.loadFromUrl(environment.resolveConfig("application.yml"));
        Settings v1 = settingsBuilder.build();
        environment = new Environment(v1);
        settingsBuilder = ImmutableSettings.settingsBuilder().put(v1);
        settingsBuilder.put("path.home", Strings.cleanPath(environment.homeFile().getAbsolutePath()));
        settingsBuilder.put("path.work", Strings.cleanPath(environment.workFile().getAbsolutePath()));
        settingsBuilder.put("path.work_with_cluster", Strings.cleanPath(environment.workWithClusterFile().getAbsolutePath()));
        settingsBuilder.put("path.data", Strings.cleanPath(environment.dataFile().getAbsolutePath()));
        settingsBuilder.put("path.data_with_cluster", Strings.cleanPath(environment.dataWithClusterFile().getAbsolutePath()));
        settingsBuilder.put("path.logs", Strings.cleanPath(environment.logsFile().getAbsolutePath()));
        return new Tuple<Settings, Environment>(settingsBuilder.build(), environment);
    }

    public static Settings simplePrepareSettings(Settings pSettings, InputStream inputStream) {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder().put(pSettings);
        settingsBuilder.loadFromStream("", inputStream);
        return settingsBuilder.build();
    }
}

