/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ByteSizeUnit {
    BYTES{

        public long toBytes(long size) {
            return size;
        }

        public long toKB(long size) {
            return size / 1024L;
        }

        public long toMB(long size) {
            return size / 0x100000L;
        }

        public long toGB(long size) {
            return size / 0x40000000L;
        }
    }
    ,
    KB{

        public long toBytes(long size) {
            return 2.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        public long toKB(long size) {
            return size;
        }

        public long toMB(long size) {
            return size / 1024L;
        }

        public long toGB(long size) {
            return size / 0x100000L;
        }
    }
    ,
    MB{

        public long toBytes(long size) {
            return 3.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        public long toKB(long size) {
            return 3.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        public long toMB(long size) {
            return size;
        }

        public long toGB(long size) {
            return size / 1024L;
        }
    }
    ,
    GB{

        public long toBytes(long size) {
            return 4.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        public long toKB(long size) {
            return 4.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        public long toMB(long size) {
            return 4.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        public long toGB(long size) {
            return size;
        }
    };

    static final long C0 = 1L;
    static final long C1 = 1024L;
    static final long C2 = 0x100000L;
    static final long C3 = 0x40000000L;
    static final long MAX = Long.MAX_VALUE;

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public long toBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toKB(long size) {
        throw new AbstractMethodError();
    }

    public long toMB(long size) {
        throw new AbstractMethodError();
    }

    public long toGB(long size) {
        throw new AbstractMethodError();
    }
}

