/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.collect;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBuilder<K, V> {
    private Map<K, V> map = Maps.newHashMap();

    public static <K, V> MapBuilder<K, V> newMapBuilder() {
        return new MapBuilder<K, V>();
    }

    public static <K, V> MapBuilder<K, V> newLinkedHashMap() {
        return new MapBuilder<K, V>(Maps.newLinkedHashMap());
    }

    public static <K, V> MapBuilder<K, V> newMapBuilder(Map<K, V> map) {
        return new MapBuilder<K, V>().putAll(map);
    }

    public MapBuilder() {
        this.map = Maps.newHashMap();
    }

    public MapBuilder(Map map) {
        this.map = map;
    }

    public MapBuilder<K, V> putAll(Map<K, V> map) {
        this.map.putAll(map);
        return this;
    }

    public MapBuilder<K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> remove(K key) {
        this.map.remove(key);
        return this;
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public Map<K, V> map() {
        return this.map;
    }

    public ImmutableMap<K, V> immutableMap() {
        return ImmutableMap.copyOf(this.map);
    }
}

