/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.env;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import net.csdn.common.Classes;
import net.csdn.common.Strings;
import net.csdn.common.exception.FailedToResolveConfigException;
import net.csdn.common.io.Streams;
import net.csdn.common.settings.ImmutableSettings;
import net.csdn.common.settings.Settings;

public class Environment {
    private final File homeFile;
    private final File workFile;
    private final File workWithClusterFile;
    private final File dataFile;
    private final File dataWithClusterFile;
    private final File configFile;
    private final File pluginsFile;
    private final File logsFile;
    private final File dictionariesFile;
    private final File gatewayFile;
    private final File fingerprintFile;
    private final File templateDirFile;

    public Environment() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public Environment(Settings settings) {
        this.homeFile = settings.get("path.home") != null ? new File(Strings.cleanPath(settings.get("path.home"))) : new File(System.getProperty("user.dir"));
        this.configFile = settings.get("path.conf") != null ? new File(Strings.cleanPath(settings.get("path.conf"))) : new File(this.homeFile, "config");
        this.pluginsFile = settings.get("path.plugins") != null ? new File(Strings.cleanPath(settings.get("path.plugins"))) : new File(this.homeFile, "plugins");
        this.workFile = settings.get("path.work") != null ? new File(Strings.cleanPath(settings.get("path.work"))) : new File(this.homeFile, "work");
        this.workWithClusterFile = new File(this.workFile, settings.get("cluster.name", "csdnsearch"));
        this.dataFile = settings.get("path.data") != null ? new File(Strings.cleanPath(settings.get("path.data"))) : new File(this.homeFile, "data");
        this.templateDirFile = settings.get("path.template") != null ? new File(Strings.cleanPath(settings.get("path.template"))) : new File(this.homeFile, "template");
        this.dataWithClusterFile = new File(this.dataFile, settings.get("cluster.name", "csdnsearch"));
        this.logsFile = settings.get("path.logs") != null ? new File(Strings.cleanPath(settings.get("path.logs"))) : new File(this.homeFile, "logs");
        this.dictionariesFile = settings.get("path.dictionaries") != null ? new File(Strings.cleanPath(settings.get("path.dictionaries"))) : new File(this.homeFile, "dictionaries");
        this.gatewayFile = settings.get("path.gateway") != null ? new File(Strings.cleanPath(settings.get("path.gateway"))) : new File(this.homeFile, "gateway");
        this.fingerprintFile = settings.get("path.fingerprintdic") != null ? new File(Strings.cleanPath(settings.get("path.fingerprintdic"))) : new File(this.homeFile, "fingerprintdic");
    }

    public File homeFile() {
        return this.homeFile;
    }

    public File dictionariesFile() {
        return this.dictionariesFile;
    }

    public File workFile() {
        return this.workFile;
    }

    public File workWithClusterFile() {
        return this.workWithClusterFile;
    }

    public File dataFile() {
        return this.dataFile;
    }

    public File dataWithClusterFile() {
        return this.dataWithClusterFile;
    }

    public File configFile() {
        return this.configFile;
    }

    public File pluginsFile() {
        return this.pluginsFile;
    }

    public File logsFile() {
        return this.logsFile;
    }

    public File gateway() {
        return this.gatewayFile;
    }

    public File fingerprintFile() {
        return this.fingerprintFile;
    }

    public File templateDirFile() {
        return this.templateDirFile;
    }

    public String resolveConfigAndLoadToString(String path) throws FailedToResolveConfigException, IOException {
        return Streams.copyToString(new InputStreamReader(this.resolveConfig(path).openStream(), "UTF-8"));
    }

    public URL resolveConfig(String path) throws FailedToResolveConfigException {
        File f2;
        File f1 = new File(path);
        if (f1.exists()) {
            try {
                return f1.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new FailedToResolveConfigException("Failed to resolve path [" + f1 + "]", e);
            }
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((f2 = new File(this.configFile, path)).exists()) {
            try {
                return f2.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new FailedToResolveConfigException("Failed to resolve path [" + f2 + "]", e);
            }
        }
        URL resource = Classes.getDefaultClassLoader().getResource(path);
        if (resource != null) {
            return resource;
        }
        if (!path.startsWith("config/") && (resource = Classes.getDefaultClassLoader().getResource("config/" + path)) != null) {
            return resource;
        }
        throw new FailedToResolveConfigException("Failed to resolve config path [" + path + "], tried file path [" + f1 + "], path file [" + f2 + "], and classpath");
    }
}

