/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.logging;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import net.csdn.common.Classes;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.CSLoggerFactory;
import net.csdn.common.settings.Settings;

public class Loggers {
    private static final String commonPrefix = System.getProperty("cs.logger.prefix", "");
    public static final String SPACE = " ";
    private static boolean consoleLoggingEnabled = true;

    public static void disableConsoleLogging() {
        consoleLoggingEnabled = false;
    }

    public static void enableConsoleLogging() {
        consoleLoggingEnabled = true;
    }

    public static boolean consoleLoggingEnabled() {
        return consoleLoggingEnabled;
    }

    public static CSLogger getLogger(Class clazz, Settings settings, String ... prefixes) {
        return Loggers.getLogger(Loggers.buildClassLoggerName(clazz), settings, prefixes);
    }

    public static CSLogger getLogger(String loggerName, Settings settings, String ... prefixes) {
        String name;
        ArrayList prefixesList = Lists.newArrayList();
        if (settings.getAsBoolean("logger.logHostAddress", false).booleanValue()) {
            try {
                prefixesList.add(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if (settings.getAsBoolean("logger.logHostName", false).booleanValue()) {
            try {
                prefixesList.add(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if ((name = settings.get("name")) != null) {
            prefixesList.add(name);
        }
        if (prefixes != null && prefixes.length > 0) {
            prefixesList.addAll(Arrays.asList(prefixes));
        }
        return Loggers.getLogger(Loggers.getLoggerName(loggerName), prefixesList.toArray(new String[prefixesList.size()]));
    }

    public static CSLogger getLogger(CSLogger parentLogger, String s) {
        return Loggers.getLogger(parentLogger.getName() + s, parentLogger.getPrefix());
    }

    public static CSLogger getLogger(String s) {
        return CSLoggerFactory.getLogger(s);
    }

    public static CSLogger getLogger(Class clazz) {
        return CSLoggerFactory.getLogger(Loggers.getLoggerName(Loggers.buildClassLoggerName(clazz)));
    }

    public static CSLogger getLogger(Class clazz, String ... prefixes) {
        return Loggers.getLogger(Loggers.buildClassLoggerName(clazz), prefixes);
    }

    public static CSLogger getLogger(String name, String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                sb.append(SPACE);
                prefix = sb.toString();
            }
        }
        return CSLoggerFactory.getLogger(prefix, Loggers.getLoggerName(name));
    }

    private static String buildClassLoggerName(Class clazz) {
        String name = clazz.getName();
        if (name.startsWith("net.csdn.")) {
            name = Classes.getPackageName(clazz);
        }
        return name;
    }

    private static String getLoggerName(String name) {
        if (name.startsWith("net.csdn.")) {
            name = name.substring("net.csdn.".length());
        }
        return commonPrefix + name;
    }
}

