/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.scan;

import com.mysql.jdbc.StringUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.csdn.common.scan.ScanService;
import net.csdn.common.scan.component.ClasspathUrlFinder;
import net.csdn.common.scan.component.Filter;
import net.csdn.common.scan.component.IteratorFactory;
import net.csdn.common.scan.component.StreamIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScanService
implements ScanService {
    private Class loader = DefaultScanService.class;

    @Override
    public Class getLoader() {
        return this.loader;
    }

    @Override
    public void setLoader(Class loader) {
        this.loader = loader;
    }

    @Override
    public URL packagePath(String packageName) {
        URL class_file_base_url = ClasspathUrlFinder.findClassBase(this.loader);
        try {
            return new URL("file:" + class_file_base_url.getPath() + packageName.replaceAll("\\.", "/") + "/");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> classNames(String packageName) {
        return this.classNames(packageName, DefaultScanService.class);
    }

    @Override
    public List<String> classNames(String packageName, Class baseClass) {
        URL class_file_base_url = ClasspathUrlFinder.findClassBase(baseClass);
        String packageNameWithDot = packageName.replace(".", File.separator);
        File packageDir = new File(class_file_base_url.getPath() + packageNameWithDot);
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<File> files = new ArrayList<File>();
        this.iterateDir(packageDir, files);
        for (File f : files) {
            String path = f.getPath();
            int pos = StringUtils.indexOfIgnoreCase((String)path, (String)packageNameWithDot);
            if (pos == -1) {
                pos = 0;
            }
            path = path.substring(pos, path.length() - 6).replace(File.separator, ".");
            classes.add(path);
        }
        return classes;
    }

    private void iterateDir(File file, List<File> files) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.iterateDir(f, files);
            }
        } else {
            files.add(file);
        }
    }

    @Override
    public List<InputStream> scanArchives(String packageName) throws IOException {
        return this.scanArchives(this.packagePath(packageName));
    }

    @Override
    public List<Class> scanArchives(String packageName, ScanService.LoadClassEnhanceCallBack loadClassEnhanceCallBack) throws IOException {
        return this.scanClass(this.scanArchives(this.packagePath(packageName)), loadClassEnhanceCallBack);
    }

    @Override
    public List<InputStream> scanArchives(URL ... urls) throws IOException {
        ArrayList<InputStream> streamList = new ArrayList<InputStream>();
        for (URL url : urls) {
            InputStream stream;
            Filter filter = new Filter(){

                public boolean accepts(String filename) {
                    return filename.endsWith(".class");
                }
            };
            File urlPath = new File(url.getPath());
            if (!urlPath.exists() || urlPath.list().length == 0) {
                return streamList;
            }
            StreamIterator it = IteratorFactory.create(url, filter);
            while ((stream = it.next()) != null) {
                streamList.add(stream);
            }
        }
        return streamList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class scanClass(InputStream bits, ScanService.LoadClassEnhanceCallBack loadClassEnhanceCallBack) throws IOException {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(bits));
        try {
            Class clazz = loadClassEnhanceCallBack.loaded(dstream);
            return clazz;
        }
        catch (Exception e) {
            e.printStackTrace();
            Class clazz = null;
            return clazz;
        }
        finally {
            dstream.close();
            bits.close();
        }
    }

    @Override
    public List<Class> scanClass(List<InputStream> inputStreams, ScanService.LoadClassEnhanceCallBack loadClassEnhanceCallBack) throws IOException {
        ArrayList<Class> classList = new ArrayList<Class>();
        for (InputStream inputStream : inputStreams) {
            classList.add(this.scanClass(inputStream, loadClassEnhanceCallBack));
        }
        return classList;
    }
}

