/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.d3;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.diversionmc.d3.Storage;

public record StoragePath(Storage storage, Object[] path) {
    public static Object[] combine(Object[] a, Object[] b) {
        Object[] res = new Object[a.length + b.length];
        System.arraycopy(a, 0, res, 0, a.length);
        System.arraycopy(b, 0, res, a.length, b.length);
        return res;
    }

    public StoragePath get(Object ... path) {
        return new StoragePath(this.storage, StoragePath.combine(this.path, path));
    }

    public Object last() {
        return this.path.length == 0 ? "" : this.path[this.path.length - 1];
    }

    public List<StoragePath> levels() {
        return this.storage.levels(this.path);
    }

    public List<String> getLevels() {
        return this.storage.getLevels(this.path);
    }

    public void forEachLevel(Consumer<StoragePath> level) {
        this.levels().forEach(level);
    }

    public Map<String, String> getValues() {
        return this.storage.getValues(this.path);
    }

    public void forEachValue(BiConsumer<String, String> values) {
        this.getValues().forEach(values);
    }

    public Map<String, String> getValuesDeep() {
        return this.storage.getValuesDeep(this.path);
    }

    public void forEachValueDeep(BiConsumer<String, String> values) {
        this.getValuesDeep().forEach(values);
    }

    public StoragePath set(Object ... pathAndValue) {
        this.storage.set(StoragePath.combine(this.path, pathAndValue));
        return this;
    }

    public StoragePath remove(Object ... path) {
        this.storage.remove(StoragePath.combine(this.path, path));
        return this;
    }

    public StoragePath removeLevel(Object ... path) {
        this.storage.removeLevel(StoragePath.combine(this.path, path));
        return this;
    }

    public Optional<String> findString() {
        return this.storage.findString(this.path);
    }

    public boolean exists() {
        return this.storage.exists(this.path);
    }

    public String getString() {
        return this.storage.getString(this.path);
    }

    public List<String> getStringList() {
        return this.storage.getStringList(this.path);
    }

    public Optional<Boolean> findBoolean() {
        return this.storage.findBoolean(this.path);
    }

    public Optional<Byte> findByte() {
        return this.storage.findByte(this.path);
    }

    public Optional<Short> findShort() {
        return this.storage.findShort(this.path);
    }

    public Optional<Integer> findInt() {
        return this.storage.findInt(this.path);
    }

    public Optional<Float> findFloat() {
        return this.storage.findFloat(this.path);
    }

    public Optional<Long> findLong() {
        return this.storage.findLong(this.path);
    }

    public Optional<Double> findDouble() {
        return this.storage.findDouble(this.path);
    }

    public boolean getBoolean() {
        return this.storage.getBoolean(this.path);
    }

    public byte getByte() {
        return this.storage.getByte(this.path);
    }

    public short getShort() {
        return this.storage.getShort(this.path);
    }

    public int getInt() {
        return this.storage.getInt(this.path);
    }

    public float getFloat() {
        return this.storage.getFloat(this.path);
    }

    public long getLong() {
        return this.storage.getLong(this.path);
    }

    public double getDouble() {
        return this.storage.getDouble(this.path);
    }

    public List<Boolean> getBooleanList() {
        return this.storage.getBooleanList(this.path);
    }

    public List<Byte> getByteList() {
        return this.storage.getByteList(this.path);
    }

    public List<Short> getShortList() {
        return this.storage.getShortList(this.path);
    }

    public List<Integer> getIntList() {
        return this.storage.getIntList(this.path);
    }

    public List<Float> getFloatList() {
        return this.storage.getFloatList(this.path);
    }

    public List<Long> getLongList() {
        return this.storage.getLongList(this.path);
    }

    public List<Double> getDoubleList() {
        return this.storage.getDoubleList(this.path);
    }

    public Optional<String> findString(Object ... path) {
        return this.get(path).findString();
    }

    public boolean exists(Object ... path) {
        return this.get(path).exists();
    }

    public String getString(Object ... path) {
        return this.get(path).getString();
    }

    public List<String> getStringList(Object ... path) {
        return this.get(path).getStringList();
    }

    public Optional<Boolean> findBoolean(Object ... path) {
        return this.get(path).findBoolean();
    }

    public Optional<Byte> findByte(Object ... path) {
        return this.get(path).findByte();
    }

    public Optional<Short> findShort(Object ... path) {
        return this.get(path).findShort();
    }

    public Optional<Integer> findInt(Object ... path) {
        return this.get(path).findInt();
    }

    public Optional<Float> findFloat(Object ... path) {
        return this.get(path).findFloat();
    }

    public Optional<Long> findLong(Object ... path) {
        return this.get(path).findLong();
    }

    public Optional<Double> findDouble(Object ... path) {
        return this.get(path).findDouble();
    }

    public boolean getBoolean(Object ... path) {
        return this.get(path).getBoolean();
    }

    public byte getByte(Object ... path) {
        return this.get(path).getByte();
    }

    public short getShort(Object ... path) {
        return this.get(path).getShort();
    }

    public int getInt(Object ... path) {
        return this.get(path).getInt();
    }

    public float getFloat(Object ... path) {
        return this.get(path).getFloat();
    }

    public long getLong(Object ... path) {
        return this.get(path).getLong();
    }

    public double getDouble(Object ... path) {
        return this.get(path).getDouble();
    }

    public List<Boolean> getBooleanList(Object ... path) {
        return this.get(path).getBooleanList();
    }

    public List<Byte> getByteList(Object ... path) {
        return this.get(path).getByteList();
    }

    public List<Short> getShortList(Object ... path) {
        return this.get(path).getShortList();
    }

    public List<Integer> getIntList(Object ... path) {
        return this.get(path).getIntList();
    }

    public List<Float> getFloatList(Object ... path) {
        return this.get(path).getFloatList();
    }

    public List<Long> getLongList(Object ... path) {
        return this.get(path).getLongList();
    }

    public List<Double> getDoubleList(Object ... path) {
        return this.get(path).getDoubleList();
    }
}

