/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.d3.operation;

import java.util.Arrays;
import java.util.List;
import java.util.function.BinaryOperator;
import net.diversionmc.d3.operation.OPArithmetic;
import net.diversionmc.d3.operation.Operation;
import net.diversionmc.parser.expression.ExpressionPiece;
import net.diversionmc.parser.expression.NumberPiece;
import net.diversionmc.parser.expression.PieceResult;
import net.diversionmc.parser.pattern.OperationSolver;
import net.diversionmc.parser.util.FilePointer;
import net.diversionmc.parser.util.ParserException;

public class Operator
extends ExpressionPiece {
    private final StringBuilder sb = new StringBuilder();
    private OperatorType type;
    public static final List<OperationSolver<Operation, Operator>> solvers = List.of(new OperationSolver(true, op -> op.type() == OperatorType.POW, (a, b, op) -> new OPArithmetic(a.pointer(), op.type(), (Operation)((Object)a), (Operation)((Object)b))), new OperationSolver(false, op -> op.type() == OperatorType.MUL || op.type() == OperatorType.DIV || op.type() == OperatorType.MOD, (a, b, op) -> new OPArithmetic(a.pointer(), op.type(), (Operation)((Object)a), (Operation)((Object)b))), new OperationSolver(false, op -> op.type() == OperatorType.ADD || op.type() == OperatorType.SUB, (a, b, op) -> new OPArithmetic(a.pointer(), op.type(), (Operation)((Object)a), (Operation)((Object)b))), new OperationSolver(false, op -> op.type() == OperatorType.LES || op.type() == OperatorType.LEQ || op.type() == OperatorType.MOR || op.type() == OperatorType.MEQ, (a, b, op) -> new OPArithmetic(a.pointer(), op.type(), (Operation)((Object)a), (Operation)((Object)b))), new OperationSolver(false, op -> op.type() == OperatorType.EQU || op.type() == OperatorType.NEQ, (a, b, op) -> new OPArithmetic(a.pointer(), op.type(), (Operation)((Object)a), (Operation)((Object)b))), new OperationSolver(false, op -> op.type() == OperatorType.AND || op.type() == OperatorType.IOR, (a, b, op) -> new OPArithmetic(a.pointer(), op.type(), (Operation)((Object)a), (Operation)((Object)b))));

    public Operator(FilePointer ptr) {
        super(ptr);
    }

    public PieceResult read(char c, FilePointer ptr) {
        if (this.sb.isEmpty()) {
            this.type = OperatorType.from("" + this.sb.append(c));
            return PieceResult.CONTINUE;
        }
        OperatorType t = OperatorType.from("" + this.sb.append(c));
        if (t == null) {
            ParserException.ASSERT((this.type != null ? 1 : 0) != 0, () -> ptr, (String)("unknown operator " + this.sb + c));
            return PieceResult.LEAVE;
        }
        this.type = t;
        return PieceResult.CONTINUE;
    }

    public String toString() {
        return "" + this.type;
    }

    public OperatorType type() {
        return this.type;
    }

    public Operator type(OperatorType t) {
        this.type = t;
        return this;
    }

    public static boolean check(char c) {
        return Arrays.stream(OperatorType.values()).anyMatch(v -> v.operator.indexOf(c) >= 0);
    }

    public static enum OperatorType {
        ADD("+", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + (n1 + n2) : a + b;
        }),
        SUB("-", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + (n1 - n2) : a.replace((CharSequence)b, "");
        }),
        MUL("*", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + n1 * n2 : (n2 == null ? null : a.repeat(n2.intValue()));
        }),
        DIV("/", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + n1 / n2 : a.replace((CharSequence)b, "\n");
        }),
        MOD("%", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            if (n1 != null && n2 != null) {
                return "" + n1 % n2;
            }
            int pos = a.indexOf((String)b);
            return pos < 0 ? a : a.substring(0, pos);
        }),
        POW("^", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + Math.pow(n1, n2) : null;
        }),
        LES("<", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + (n1 < n2) : "" + (a.compareTo((String)b) < 0);
        }),
        LEQ("<=", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + (n1 <= n2) : "" + (a.compareTo((String)b) <= 0);
        }),
        MOR(">", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + (n1 > n2) : "" + (a.compareTo((String)b) > 0);
        }),
        MEQ(">=", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + (n1 >= n2) : "" + (a.compareTo((String)b) >= 0);
        }),
        EQU("==", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + (n1.doubleValue() == n2.doubleValue()) : "" + a.equals(b);
        }),
        NEQ("!=", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            Double n2 = NumberPiece.tryNumber((String)b);
            return n1 != null && n2 != null ? "" + (n1.doubleValue() != n2.doubleValue()) : "" + !a.equals(b);
        }),
        AND("&", (a, b) -> "" + (NumberPiece.tryBoolean((String)a) && NumberPiece.tryBoolean((String)b))),
        IOR("|", (a, b) -> "" + (NumberPiece.tryBoolean((String)a) || NumberPiece.tryBoolean((String)b))),
        NOT("!", (a, b) -> "" + !NumberPiece.tryBoolean((String)a)),
        UMS("-", (a, b) -> {
            Double n1 = NumberPiece.tryNumber((String)a);
            return n1 != null ? "" + -n1.doubleValue() : "-" + a;
        });

        private final String operator;
        private final BinaryOperator<String> combiner;

        private OperatorType(String operator, BinaryOperator<String> combiner) {
            this.operator = operator;
            this.combiner = combiner;
        }

        public String toString() {
            return this.operator;
        }

        public static OperatorType from(String s) {
            return Arrays.stream(OperatorType.values()).filter(v -> v.operator.equals(s) || v == AND && s.replace("&", "").isEmpty() || v == IOR && s.replace("|", "").isEmpty()).findFirst().orElse(null);
        }

        public String operate(String a, String b) {
            return (String)this.combiner.apply(a, b);
        }
    }
}

