package net.dongliu.cute.http.jsonb;

import net.dongliu.cute.http.json.JsonMarshaller;
import org.checkerframework.checker.nullness.qual.Nullable;

import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;

/**
 * JsonMarshaller JsonB implementation
 */
public class JsonBJsonMarshaller implements JsonMarshaller {
    private final Jsonb jsonb;

    public JsonBJsonMarshaller() {
        this(JsonbBuilder.create());
    }

    public JsonBJsonMarshaller(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    @Override
    public void marshal(@Nullable Object value, Writer writer) {
        jsonb.toJson(value, writer);
    }

    @Override
    public <T> @Nullable T unmarshal(Reader reader, Type type) {
        return jsonb.fromJson(reader, type);
    }
}
