/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.xhttp.json.jsonb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import net.dongliu.commons.Lazy;
import net.dongliu.xhttp.json.JsonProcessor;

public class JsonBindingJsonProcessor
extends JsonProcessor {
    private final Jsonb jsonb;
    private static final Lazy<Jsonb> defaultJsonb = Lazy.of(JsonbBuilder::create);

    public JsonBindingJsonProcessor() {
        this((Jsonb)defaultJsonb.get());
    }

    public JsonBindingJsonProcessor(Jsonb jsonb) {
        this.jsonb = Objects.requireNonNull(jsonb);
    }

    public void marshal(Object value, OutputStream out, Charset charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        this.jsonb.toJson(value, (Writer)writer);
    }

    public <T> T unmarshal(InputStream in, Charset charset, Type type) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(in, charset);){
            Object object = this.jsonb.fromJson((Reader)reader, type);
            return (T)object;
        }
    }
}

