/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.auth;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.auth.UserPrincipal;

public class UsernamePasswordLoginModule
implements LoginModule {
    CallbackHandler handler;
    Subject subject;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.handler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback name = new NameCallback("username");
        PasswordCallback password = new PasswordCallback("password", false);
        try {
            this.handler.handle(new Callback[]{name, password});
        }
        catch (Exception e) {
            Logger.suppress((Throwable)e);
            throw new LoginException(e.getMessage());
        }
        this.subject.getPrincipals().add(new UserPrincipal(name.getName()));
        this.subject.getPrivateCredentials().add(name);
        this.subject.getPrivateCredentials().add(password);
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

