/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.io.Serializable;
import java.util.Properties;

public class Secret
implements Serializable {
    private static final long serialVersionUID = -5640813231783061396L;
    private Properties properties;
    private String protectedProperties;
    private String encryptedSecret;

    public Secret() {
    }

    public Secret(Secret secret) {
        this.properties = secret.properties;
        this.protectedProperties = secret.protectedProperties;
        this.encryptedSecret = secret.encryptedSecret;
        if (secret.properties != null) {
            this.properties = new Properties();
            for (String key : secret.properties.stringPropertyNames()) {
                this.properties.setProperty(key, secret.properties.getProperty(key));
            }
        }
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProtectedProperties() {
        return this.protectedProperties;
    }

    public void setProtectedProperties(String protectedProperties) {
        this.protectedProperties = protectedProperties;
    }

    public String getSecret() {
        return this.encryptedSecret;
    }

    public void setSecret(String secret) {
        this.encryptedSecret = secret;
    }

    public String keyAlias() {
        String[] components = this.encryptedSecret.split("\\$");
        return components[2];
    }

    public String keyVersion() {
        String[] components = this.encryptedSecret.split("\\$");
        return components[3];
    }

    public String alias() {
        return this.getProperty("alias");
    }

    public String version() {
        return this.getProperty("version");
    }
}

