/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fckeditor.tool.Utils;

public class XHtmlTagTool {
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String value = null;
    public static final String SPACE = " ";

    public XHtmlTagTool(String name, String value) throws IllegalArgumentException {
        if (Utils.isEmpty(name)) {
            throw new IllegalArgumentException("Parameter 'name' shouldn't be empty!");
        }
        this.name = name;
        this.value = value;
    }

    public XHtmlTagTool(String name) {
        this(name, null);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void addAttribute(String name, String value) {
        if (Utils.isEmpty(name)) {
            throw new IllegalArgumentException("Parameter 'name' shouldn't be empty!");
        }
        this.attributes.put(name, value);
    }

    public String toString() {
        StringBuffer tag = new StringBuffer();
        tag.append("<").append(this.name);
        Iterator<String> i$ = this.attributes.keySet().iterator();
        while (i$.hasNext()) {
            String key = i$.next();
            String val = this.attributes.get(key);
            tag.append(' ').append(key).append('=').append('\"').append(val).append('\"');
        }
        if (Utils.isNotEmpty(this.value)) {
            tag.append(">").append(this.value).append("</").append(this.name).append('>');
        } else {
            tag.append(" />");
        }
        return tag.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            XHtmlTagTool tag = (XHtmlTagTool)obj;
            return this.value.equals(tag.value) && this.name.equals(tag.name) && ((Object)this.attributes).equals(tag.attributes);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode() + ((Object)this.attributes).hashCode();
    }
}

