/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Named;
import net.finmath.plots.Plot;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotableFunction2D;
import net.finmath.plots.Point2D;

public class Plot2DFX
implements Plot {
    private List<Plotable2D> plotables;
    private String title = "";
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private NumberFormat xAxisNumberFormat;
    private NumberFormat yAxisNumberFormat;
    private Boolean isLegendVisible = false;
    LineChart<Number, Number> chart;
    private Object updateLock = new Object();

    public Plot2DFX(double xmin, double xmax, int numberOfPointsX, DoubleUnaryOperator function) {
        this(xmin, xmax, numberOfPointsX, Collections.singletonList(new Named<DoubleUnaryOperator>("", function)));
    }

    public Plot2DFX(double xmin, double xmax, int numberOfPointsX, List<Named<DoubleUnaryOperator>> doubleUnaryOperators) {
        this(doubleUnaryOperators.stream().map(namedFunction -> new PlotableFunction2D(xmin, xmax, numberOfPointsX, (Named<DoubleUnaryOperator>)namedFunction, null)).collect(Collectors.toList()));
    }

    public Plot2DFX(List<Plotable2D> plotables) {
        this.plotables = plotables;
    }

    private void init() {
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        xAxis.setLabel(this.xAxisLabel);
        yAxis.setLabel(this.yAxisLabel);
        this.chart = new LineChart((Axis)xAxis, (Axis)yAxis);
        this.update();
    }

    private void update() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String rgba;
                Color color;
                Plot2DFX.this.chart.setTitle(Plot2DFX.this.title);
                for (int functionIndex = 0; functionIndex < Plot2DFX.this.plotables.size(); ++functionIndex) {
                    Plotable2D plotable = (Plotable2D)Plot2DFX.this.plotables.get(functionIndex);
                    GraphStyle style = plotable.getStyle();
                    color = Plot2DFX.this.getColor(style);
                    if (color == null) {
                        color = Plot2DFX.this.getDefaultColor(functionIndex);
                    }
                    rgba = String.format("%d, %d, %d, %f", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), Float.valueOf((float)color.getOpacity()));
                    List<Point2D> plotableSeries = plotable.getSeries();
                    XYChart.Series series = null;
                    if (functionIndex < Plot2DFX.this.chart.getData().size()) {
                        series = (XYChart.Series)Plot2DFX.this.chart.getData().get(functionIndex);
                    }
                    if (series == null) {
                        series = new XYChart.Series();
                        Plot2DFX.this.chart.getData().add(functionIndex, (Object)series);
                    }
                    series.setName(plotable.getName());
                    for (int i = 0; i < plotableSeries.size(); ++i) {
                        XYChart.Data data = null;
                        if (i < series.getData().size()) {
                            data = (XYChart.Data)series.getData().get(i);
                        }
                        if (data == null) {
                            data = new XYChart.Data((Object)plotableSeries.get(i).getX(), (Object)plotableSeries.get(i).getY());
                            if (style.getShape() != null) {
                                data.setNode((Node)new Rectangle(3.0, 3.0, (Paint)color));
                            }
                            series.getData().add(i, (Object)data);
                        }
                        data.setXValue((Object)plotableSeries.get(i).getX());
                        data.setYValue((Object)plotableSeries.get(i).getY());
                    }
                    if (style.getStoke() != null) {
                        series.getNode().setStyle("-fx-stroke: rgba(" + rgba + ");");
                        continue;
                    }
                    series.getNode().setStyle("-fx-stroke: none;");
                }
                Node[] legendItems = Plot2DFX.this.chart.lookupAll(".chart-legend-item-symbol").toArray(new Node[0]);
                for (int i = 0; i < legendItems.length; ++i) {
                    Node legendItemNode = legendItems[i];
                    color = Plot2DFX.this.getDefaultColor(i);
                    rgba = String.format("%d, %d, %d, %f", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), Float.valueOf((float)color.getOpacity()));
                    legendItemNode.setStyle("-fx-background-color: rgba(" + rgba + ");");
                    Plot2DFX.this.chart.applyCss();
                }
                Plot2DFX.this.chart.applyCss();
            }
        });
    }

    private Color getColor(GraphStyle style) {
        java.awt.Color awtColor = style.getColor();
        Color color = null;
        if (awtColor != null) {
            color = new Color((double)awtColor.getRed() / 255.0, (double)awtColor.getGreen() / 255.0, (double)awtColor.getBlue() / 255.0, (double)awtColor.getAlpha() / 255.0);
        }
        return color;
    }

    private Color getDefaultColor(int functionIndex) {
        switch (functionIndex) {
            case 0: {
                return new Color(1.0, 0.0, 0.0, 1.0);
            }
            case 1: {
                return new Color(0.0, 1.0, 0.0, 1.0);
            }
            case 2: {
                return new Color(0.0, 0.0, 1.0, 1.0);
            }
        }
        return new Color(0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("FX");
                final JFXPanel fxPanel = new JFXPanel();
                frame.add((Component)fxPanel);
                frame.setVisible(true);
                frame.setSize(800, 600);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Plot2DFX.this.init();
                        fxPanel.setScene(new Scene(Plot2DFX.this.chart, 800.0, 600.0));
                    }
                });
                Plot2DFX.this.update();
            }
        });
    }

    @Override
    public void saveAsJPG(File file, int width, int height) throws IOException {
    }

    @Override
    public void saveAsPDF(File file, int width, int height) throws IOException {
    }

    @Override
    public void saveAsSVG(File file, int width, int height) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot2DFX update(List<Plotable2D> plotables) {
        this.plotables = plotables;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.update();
            }
        }
        return this;
    }

    @Override
    public Plot2DFX setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public Plot2DFX setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @Override
    public Plot2DFX setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    @Override
    public Plot setZAxisLabel(String zAxisLabel) {
        throw new UnsupportedOperationException("The 2D plot does not suport a z-axis. Try 3D plot instead.");
    }

    @Override
    public Plot setIsLegendVisible(Boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        return this;
    }
}

