/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Named;
import net.finmath.plots.Plot;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotableFunction2D;
import net.finmath.plots.Point2D;
import net.finmath.plots.jfreechart.JFreeChartUtilities;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Plot2D
implements Plot {
    private List<Plotable2D> plotables;
    private String title = "";
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private NumberFormat xAxisNumberFormat;
    private NumberFormat yAxisNumberFormat;
    private Boolean isLegendVisible = false;
    private transient JFreeChart chart;
    private Object updateLock = new Object();
    private Double ymin;
    private Double ymax;

    public Plot2D(double xmin, double xmax, int numberOfPointsX, DoubleUnaryOperator function) {
        this(xmin, xmax, numberOfPointsX, Collections.singletonList(new Named<DoubleUnaryOperator>("", function)));
    }

    public Plot2D(double xmin, double xmax, DoubleUnaryOperator function) {
        this(xmin, xmax, 300, Collections.singletonList(new Named<DoubleUnaryOperator>("", function)));
    }

    public Plot2D(double xmin, double xmax, int numberOfPointsX, List<Named<DoubleUnaryOperator>> doubleUnaryOperators) {
        this(doubleUnaryOperators.stream().map(namedFunction -> new PlotableFunction2D(xmin, xmax, numberOfPointsX, (Named<DoubleUnaryOperator>)namedFunction, null)).collect(Collectors.toList()));
    }

    public Plot2D(List<Plotable2D> plotables) {
        this.plotables = plotables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                return;
            }
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            XYSeriesCollection data = new XYSeriesCollection();
            this.chart = JFreeChartUtilities.getXYPlotChart(this.title, this.xAxisLabel, "#.##", this.yAxisLabel, "#.##", data, (AbstractXYItemRenderer)renderer, this.isLegendVisible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        XYSeriesCollection data = new XYSeriesCollection();
        for (int functionIndex = 0; functionIndex < this.plotables.size(); ++functionIndex) {
            Color color;
            Plotable2D plotable = this.plotables.get(functionIndex);
            List<Point2D> plotableSeries = plotable.getSeries();
            XYSeries series = new XYSeries((Comparable)((Object)plotable.getName()));
            for (int i = 0; i < plotableSeries.size(); ++i) {
                series.add(plotableSeries.get(i).getX(), plotableSeries.get(i).getY());
            }
            data.addSeries(series);
            GraphStyle style = plotable.getStyle();
            Color color2 = color = style != null ? plotable.getStyle().getColor() : null;
            if (color == null) {
                color = this.getDefaultColor(functionIndex);
            }
            renderer.setSeriesPaint(functionIndex, (Paint)color);
            if (style == null) continue;
            renderer.setSeriesShape(functionIndex, plotable.getStyle().getShape());
            renderer.setSeriesStroke(functionIndex, plotable.getStyle().getStoke());
            renderer.setSeriesShapesVisible(functionIndex, style.getShape() != null);
            renderer.setSeriesLinesVisible(functionIndex, style.getStoke() != null);
        }
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.chart.getXYPlot().setDataset(0, (XYDataset)data);
                this.chart.getXYPlot().setRenderer(0, (XYItemRenderer)renderer);
                NumberAxis domain = (NumberAxis)this.chart.getXYPlot().getDomainAxis();
                if (this.xAxisNumberFormat != null) {
                    domain.setNumberFormatOverride(this.xAxisNumberFormat);
                }
                NumberAxis range = (NumberAxis)this.chart.getXYPlot().getRangeAxis();
                if (this.yAxisNumberFormat != null) {
                    range.setNumberFormatOverride(this.yAxisNumberFormat);
                }
                if (this.ymin != null && this.ymin != null) {
                    range.setAutoRange(false);
                    range.setRange(new Range(this.ymin.doubleValue(), this.ymax.doubleValue()));
                } else {
                    range.setAutoRange(true);
                }
            }
        }
    }

    private Color getDefaultColor(int functionIndex) {
        switch (functionIndex) {
            case 0: {
                return new Color(255, 0, 0);
            }
            case 1: {
                return new Color(0, 255, 0);
            }
            case 2: {
                return new Color(0, 0, 255);
            }
        }
        return new Color(0, 0, 0);
    }

    @Override
    public void show() {
        this.init();
        this.update(this.plotables);
        ChartPanel chartPanel = new ChartPanel(this.chart, 800, 400, 128, 128, 2024, 2024, false, true, true, false, true, false);
        EventQueue.invokeLater(new Runnable((JPanel)chartPanel){
            final /* synthetic */ JPanel val$chartPanel;
            {
                this.val$chartPanel = jPanel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Plot2D.this.updateLock;
                synchronized (object) {
                    JFrame frame = new JFrame();
                    frame.add(this.val$chartPanel);
                    frame.setVisible(true);
                    frame.pack();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAsJPG(File file, int width, int height) throws IOException {
        this.init();
        this.update(this.plotables);
        Object object = this.updateLock;
        synchronized (object) {
            JFreeChartUtilities.saveChartAsJPG(file, this.chart, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAsPDF(File file, int width, int height) throws IOException {
        this.init();
        this.update(this.plotables);
        Object object = this.updateLock;
        synchronized (object) {
            JFreeChartUtilities.saveChartAsPDF(file, this.chart, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAsSVG(File file, int width, int height) throws IOException {
        this.init();
        this.update(this.plotables);
        Object object = this.updateLock;
        synchronized (object) {
            JFreeChartUtilities.saveChartAsSVG(file, this.chart, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot2D update(List<Plotable2D> plotables) {
        this.plotables = plotables;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.update();
            }
        }
        return this;
    }

    @Override
    public Plot2D setTitle(String title) {
        this.title = title;
        this.update();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plot2D setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.chart.getXYPlot().getDomainAxis().setLabel(xAxisLabel);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plot2D setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.chart.getXYPlot().getRangeAxis().setLabel(yAxisLabel);
            }
        }
        return this;
    }

    @Override
    public Plot setZAxisLabel(String zAxisLabel) {
        throw new UnsupportedOperationException("The 2D plot does not suport a z-axis. Try 3D plot instead.");
    }

    public Plot2D setxAxisNumberFormat(NumberFormat xAxisNumberFormat) {
        this.xAxisNumberFormat = xAxisNumberFormat;
        return this;
    }

    public Plot2D setyAxisNumberFormat(NumberFormat yAxisNumberFormat) {
        this.yAxisNumberFormat = yAxisNumberFormat;
        return this;
    }

    public Plot setYRange(double ymin, double ymax) {
        this.ymin = ymin;
        this.ymax = ymax;
        this.update();
        return this;
    }

    @Override
    public Plot setIsLegendVisible(Boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        this.update();
        return this;
    }
}

