/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.io.File;
import java.io.IOException;
import java.util.function.DoubleBinaryOperator;
import net.finmath.plots.Named;
import net.finmath.plots.Plot;
import org.jzy3d.analysis.AbstractAnalysis;
import org.jzy3d.analysis.AnalysisLauncher;
import org.jzy3d.analysis.IAnalysis;
import org.jzy3d.chart.factories.AWTChartComponentFactory;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.builder.Builder;
import org.jzy3d.plot3d.builder.Mapper;
import org.jzy3d.plot3d.builder.concrete.OrthonormalGrid;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

public class Plot3D
implements Plot {
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private int numberOfPointsX;
    private int numberOfPointsY;
    private Named<DoubleBinaryOperator> function;
    private String title = "";
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private String zAxisLabel = "z";
    private Boolean isLegendVisible;

    public Plot3D(double xmin, double xmax, double ymin, double ymax, int numberOfPointsX, int numberOfPointsY, Named<DoubleBinaryOperator> function) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.numberOfPointsX = numberOfPointsX;
        this.numberOfPointsY = numberOfPointsY;
        this.function = function;
    }

    public Plot3D(double xmin, double xmax, double ymin, double ymax, int numberOfPointsX, int numberOfPointsY, DoubleBinaryOperator function) {
        this(xmin, xmax, ymin, ymax, numberOfPointsX, numberOfPointsY, new Named<DoubleBinaryOperator>("", function));
    }

    @Override
    public void show() throws Exception {
        AnalysisLauncher.open((IAnalysis)new Surface());
    }

    @Override
    public void saveAsJPG(File file, int width, int height) throws IOException {
        new Surface().getChart().screenshot(file);
    }

    @Override
    public void saveAsPDF(File file, int width, int height) {
        throw new UnsupportedOperationException("Save as PDF is not supported for this plot. Use saveAsJPG instead.");
    }

    @Override
    public void saveAsSVG(File file, int width, int height) {
        throw new UnsupportedOperationException("Save as SVG is not supported for this plot. Use saveAsJPG instead.");
    }

    @Override
    public Plot setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public Plot setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @Override
    public Plot setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    @Override
    public Plot setZAxisLabel(String zAxisLabel) {
        this.zAxisLabel = zAxisLabel;
        return this;
    }

    @Override
    public Plot setIsLegendVisible(Boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        return this;
    }

    class Surface
    extends AbstractAnalysis {
        Surface() {
        }

        public String getName() {
            return Plot3D.this.function.getName();
        }

        public void init() {
            Mapper mapper = new Mapper(){
                private final DoubleBinaryOperator functionToPlot;
                {
                    this.functionToPlot = (DoubleBinaryOperator)Plot3D.this.function.get();
                }

                public double f(double x, double y) {
                    return this.functionToPlot.applyAsDouble(x, y);
                }
            };
            Shape surface = Builder.buildOrthonormal((OrthonormalGrid)new OrthonormalGrid(new Range((float)Plot3D.this.xmin, (float)Plot3D.this.xmax), Plot3D.this.numberOfPointsX, new Range((float)Plot3D.this.ymin, (float)Plot3D.this.ymax), Plot3D.this.numberOfPointsY), (Mapper)mapper);
            surface.setColorMapper(new ColorMapper((IColorMap)new ColorMapRainbow(), (double)surface.getBounds().getZmin(), (double)surface.getBounds().getZmax(), new Color(1.0f, 1.0f, 1.0f, 0.5f)));
            surface.setFaceDisplayed(true);
            surface.setWireframeDisplayed(true);
            surface.setWireframeColor(Color.BLACK);
            this.chart = AWTChartComponentFactory.chart((Quality)Quality.Advanced, (String)this.getCanvasType());
            this.chart.getScene().getGraph().add((AbstractDrawable)surface);
            this.chart.getAxeLayout().setXAxeLabelDisplayed(true);
            this.chart.getAxeLayout().setYAxeLabelDisplayed(true);
            this.chart.getAxeLayout().setXAxeLabel(Plot3D.this.xAxisLabel);
            this.chart.getAxeLayout().setYAxeLabel(Plot3D.this.yAxisLabel);
            this.chart.getAxeLayout().setZAxeLabel(Plot3D.this.zAxisLabel);
            AxeBox box = (AxeBox)this.chart.getView().getAxe();
            TextBitmapRenderer renderer = new TextBitmapRenderer(TextBitmapRenderer.Font.TimesRoman_24);
            box.setTextRenderer((ITextRenderer)renderer);
        }
    }
}

