/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Named;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.Point2D;

public class PlotableFunction2D
implements Plotable2D {
    private double xmin;
    private double xmax;
    private int numberOfPointsX;
    private Named<DoubleUnaryOperator> namedFunction;
    private GraphStyle style;

    public PlotableFunction2D(double xmin, double xmax, int numberOfPointsX, Named<DoubleUnaryOperator> namedFunction, GraphStyle style) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.numberOfPointsX = numberOfPointsX;
        this.namedFunction = namedFunction;
        this.style = new GraphStyle(new Rectangle(-1, -1, 2, 2), new BasicStroke(1.0f), null);
        if (numberOfPointsX < 2) {
            throw new IllegalArgumentException("Number of points needs to be larger than 1.");
        }
    }

    @Override
    public String getName() {
        return this.namedFunction.getName();
    }

    @Override
    public List<Point2D> getSeries() {
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        DoubleUnaryOperator function = this.namedFunction.get();
        for (int i = 0; i < this.numberOfPointsX; ++i) {
            double x = this.xmin + (double)i * ((this.xmax - this.xmin) / (double)(this.numberOfPointsX - 1));
            double y = function.applyAsDouble(x);
            series.add(new Point2D(x, y));
        }
        return series;
    }

    @Override
    public GraphStyle getStyle() {
        return this.style;
    }
}

