/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.jfreechart;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.renderer.PaintScale;

public class HuePaintScale
implements PaintScale {
    double lowerBound;
    double upperBound;

    public HuePaintScale(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public Paint getPaint(double value) {
        if (value > this.upperBound || value < this.lowerBound || Double.isNaN(value)) {
            return Color.GRAY;
        }
        return Color.getHSBColor((float)((value - this.lowerBound) / (this.upperBound - this.lowerBound) * 240.0 / 360.0), 1.0f, 1.0f);
    }
}

