/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.jfreechart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;

public class StyleGuide {
    static Font titleFont;
    static Font axisLabelFont;
    static Font annotationFont;
    static Font tickLabelFont;
    private Color chartBackgroundPaint;
    private Color plotBackgroundPaint;

    public StyleGuide(double scale) {
        titleFont = new Font("SansSerif", 0, (int)Math.round(10.0 * scale));
        axisLabelFont = new Font("SansSerif", 0, (int)Math.round(10.0 * scale));
        annotationFont = new Font("SansSerif", 0, (int)Math.round(8.0 * scale));
        tickLabelFont = new Font("SansSerif", 0, (int)Math.round(9.0 * scale));
        this.chartBackgroundPaint = new Color(247, 247, 247);
        this.plotBackgroundPaint = new Color(255, 255, 255);
    }

    public static void applyStyleToChart(JFreeChart chart) {
        new StyleGuide(1.0).applyStyleToChart2(chart);
    }

    public static void applyStyleToXYPlot(XYPlot xyPlot) {
        new StyleGuide(1.0).applyStyleToXYPlot2(xyPlot);
    }

    public void applyStyleToChart2(JFreeChart chart) {
        XYPlot xyPlot;
        LegendTitle legend;
        chart.setBackgroundPaint((Paint)this.chartBackgroundPaint);
        if (chart.getTitle() != null) {
            chart.getTitle().setFont(titleFont);
        }
        if ((legend = chart.getLegend()) != null) {
            legend.setBackgroundPaint((Paint)this.chartBackgroundPaint);
        }
        if ((xyPlot = chart.getXYPlot()) != null) {
            this.applyStyleToXYPlot2(xyPlot);
        }
    }

    public void applyStyleToXYPlot2(XYPlot xyPlot) {
        if (xyPlot.getDomainAxis() != null) {
            xyPlot.getDomainAxis().setTickLabelFont(tickLabelFont);
            xyPlot.getDomainAxis().setLabelFont(axisLabelFont);
            xyPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        }
        if (xyPlot.getRangeAxis() != null) {
            xyPlot.getRangeAxis().setTickLabelFont(tickLabelFont);
            xyPlot.getRangeAxis().setLabelFont(axisLabelFont);
            xyPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        }
        xyPlot.setBackgroundPaint((Paint)this.plotBackgroundPaint);
    }

    public static Font getAxisLabelFont() {
        return new Font("SansSerif", 0, Math.round(10.0f));
    }

    public static Font getTickLabelFont() {
        return new Font("SansSerif", 0, Math.round(9.0f));
    }

    public static Font getTitleFont() {
        return new Font("SansSerif", 0, Math.round(10.0f));
    }
}

