/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.Chart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.StackedBarChart;
import javafx.scene.chart.XYChart;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.finmath.plots.Category2D;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Plot;
import net.finmath.plots.PlotableCategories;

public class Plot2DBarFX
implements Plot {
    private List<PlotableCategories> plotables;
    private String title = "";
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private NumberFormat xAxisNumberFormat;
    private NumberFormat yAxisNumberFormat;
    private Double yAxisLowerBound;
    private Double yAxisUpperBound;
    private Double yAxisTick;
    private Boolean isLegendVisible = false;
    private Boolean isSeriesStacked = false;
    XYChart<String, Number> chart;
    private final Object updateLock = new Object();

    public Plot2DBarFX(List<PlotableCategories> plotables, String title, String xAxisLabel, String yAxisLabel, NumberFormat yAxisNumberFormat, Double yAxisLowerBound, Double yAxisUpperBound, Double yAxisTick, Boolean isLegendVisible) {
        this.plotables = plotables;
        this.title = title;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
        this.yAxisNumberFormat = yAxisNumberFormat;
        this.yAxisLowerBound = yAxisLowerBound;
        this.yAxisUpperBound = yAxisUpperBound;
        this.yAxisTick = yAxisTick;
        this.isLegendVisible = isLegendVisible;
    }

    public Plot2DBarFX(List<PlotableCategories> plotables) {
        this.plotables = plotables;
    }

    public Plot2DBarFX() {
    }

    public static Plot2DBarFX of(String[] labels, double[] values, String title, String xAxisLabel, String yAxisLabel, NumberFormat yAxisNumberFormat, boolean isLegendVisible) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        ArrayList<PlotableCategories> plotables = new ArrayList<PlotableCategories>();
        String name = "Swaption";
        final ArrayList<Category2D> histogramAsList = new ArrayList<Category2D>();
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            histogramAsList.add(new Category2D((String)(labels != null ? labels[i] : "" + i), value));
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        PlotableCategories histo = new PlotableCategories(){

            @Override
            public String getName() {
                return "Swaption";
            }

            @Override
            public GraphStyle getStyle() {
                return null;
            }

            @Override
            public List<Category2D> getSeries() {
                return histogramAsList;
            }
        };
        plotables.add(histo);
        return new Plot2DBarFX(plotables, title, xAxisLabel, yAxisLabel, yAxisNumberFormat, min, max, (max - min) / 10.0, isLegendVisible);
    }

    private void init() {
        CategoryAxis xAxis = new CategoryAxis();
        xAxis.setAutoRanging(true);
        xAxis.setAnimated(false);
        NumberAxis yAxis = new NumberAxis(this.yAxisLowerBound.doubleValue(), this.yAxisUpperBound.doubleValue(), this.yAxisTick.doubleValue());
        xAxis.setLabel(this.xAxisLabel);
        yAxis.setLabel(this.yAxisLabel);
        this.chart = this.isSeriesStacked != false ? new StackedBarChart((Axis)xAxis, (Axis)yAxis) : new BarChart((Axis)xAxis, (Axis)yAxis);
        this.chart.setAnimated(true);
        this.update();
    }

    private void update() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Plot2DBarFX.this.plotables == null) {
                    return;
                }
                Plot2DBarFX.this.chart.setTitle(Plot2DBarFX.this.title);
                for (int functionIndex = 0; functionIndex < Plot2DBarFX.this.plotables.size(); ++functionIndex) {
                    PlotableCategories plotable = Plot2DBarFX.this.plotables.get(functionIndex);
                    GraphStyle style = plotable.getStyle();
                    Color color = Plot2DBarFX.this.getColor(style);
                    if (color == null) {
                        color = Plot2DBarFX.this.getDefaultColor(functionIndex);
                    }
                    String rgba = String.format("%d, %d, %d, %f", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), Float.valueOf((float)color.getOpacity()));
                    List<Category2D> plotableSeries = plotable.getSeries();
                    XYChart.Series series = null;
                    if (functionIndex < Plot2DBarFX.this.chart.getData().size()) {
                        series = (XYChart.Series)Plot2DBarFX.this.chart.getData().get(functionIndex);
                    }
                    if (series == null) {
                        series = new XYChart.Series();
                        Plot2DBarFX.this.chart.getData().add(functionIndex, (Object)series);
                    }
                    series.setName(plotable.getName());
                    for (int i = 0; i < plotableSeries.size(); ++i) {
                        XYChart.Data data = null;
                        if (i < series.getData().size()) {
                            data = (XYChart.Data)series.getData().get(i);
                        }
                        if (data == null) {
                            data = new XYChart.Data((Object)plotableSeries.get(i).getName(), (Object)plotableSeries.get(i).getValue());
                            if (style == null || style.getShape() != null) {
                                // empty if block
                            }
                            series.getData().add(i, (Object)data);
                        }
                        data.setXValue((Object)plotableSeries.get(i).getName());
                        data.setYValue((Object)plotableSeries.get(i).getValue());
                    }
                }
            }
        });
    }

    private Color getColor(GraphStyle style) {
        java.awt.Color awtColor = style != null ? style.getColor() : null;
        Color color = null;
        if (awtColor != null) {
            color = new Color((double)awtColor.getRed() / 255.0, (double)awtColor.getGreen() / 255.0, (double)awtColor.getBlue() / 255.0, (double)awtColor.getAlpha() / 255.0);
        }
        return color;
    }

    private Color getDefaultColor(int functionIndex) {
        switch (functionIndex) {
            case 0: {
                return new Color(1.0, 0.0, 0.0, 1.0);
            }
            case 1: {
                return new Color(0.0, 1.0, 0.0, 1.0);
            }
            case 2: {
                return new Color(0.0, 0.0, 1.0, 1.0);
            }
        }
        return new Color(0.0, 0.0, 0.0, 1.0);
    }

    public Chart get() {
        this.init();
        return this.chart;
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("FX");
                final JFXPanel fxPanel = new JFXPanel();
                frame.add((Component)fxPanel);
                frame.setVisible(true);
                frame.setSize(800, 600);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Plot2DBarFX.this.init();
                        fxPanel.setScene(new Scene(Plot2DBarFX.this.chart, 800.0, 600.0));
                    }
                });
                Plot2DBarFX.this.update();
            }
        });
    }

    @Override
    public void saveAsJPG(File file, int width, int height) throws IOException {
    }

    public void saveAsPNG(final File file, final int width, final int height) throws IOException {
        if (this.chart == null) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Plot2DBarFX.this.chart.setAnimated(false);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    BufferedImage imageWithAlpha = new BufferedImage(width, height, 2);
                    Graphics2D g2 = imageWithAlpha.createGraphics();
                    Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
                    WritableImage image = Plot2DBarFX.this.chart.getScene().snapshot(null);
                    ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", out);
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void saveAsPDF(File file, int width, int height) throws IOException {
    }

    @Override
    public void saveAsSVG(File file, int width, int height) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot2DBarFX update(List<PlotableCategories> plotables) {
        if (this.chart != null) {
            this.chart.setAnimated(true);
        }
        this.plotables = plotables;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.update();
            }
        }
        if (this.chart != null) {
            this.chart.setAnimated(false);
        }
        return this;
    }

    @Override
    public Plot2DBarFX setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public Plot2DBarFX setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @Override
    public Plot2DBarFX setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    public Plot2DBarFX setYAxisRange(Double min, Double max) {
        if (this.chart == null || this.chart.getYAxis() == null) {
            return this;
        }
        if (min == null || max == null) {
            this.chart.getYAxis().setAutoRanging(true);
        } else {
            this.chart.getYAxis().setAutoRanging(false);
            ((NumberAxis)this.chart.getYAxis()).setLowerBound(min.doubleValue());
            ((NumberAxis)this.chart.getYAxis()).setUpperBound(max.doubleValue());
        }
        return this;
    }

    @Override
    public Plot setZAxisLabel(String zAxisLabel) {
        throw new UnsupportedOperationException("The 2D plot does not suport a z-axis. Try 3D plot instead.");
    }

    @Override
    public Plot setIsLegendVisible(Boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        return this;
    }

    public void setIsSeriesStacked(Boolean isSeriesStacked) {
        this.isSeriesStacked = isSeriesStacked;
    }
}

