/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.finitedifference.models;

import java.util.function.DoubleUnaryOperator;
import net.finmath.finitedifference.models.FiniteDifference1DBoundary;
import net.finmath.finitedifference.models.FiniteDifference1DModel;
import net.finmath.finitedifference.solvers.FDMThetaMethod;

public class FDMBlackScholesModel
implements FiniteDifference1DModel {
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private final int numTimesteps;
    private final int numSpacesteps;
    private final int numStandardDeviations;
    private final double center;
    private final double theta;

    public FDMBlackScholesModel(int numTimesteps, int numSpacesteps, int numStandardDeviations, double center, double theta, double initialValue, double riskFreeRate, double volatility) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.numTimesteps = numTimesteps;
        this.numSpacesteps = numSpacesteps;
        this.numStandardDeviations = numStandardDeviations;
        this.center = center;
        this.theta = theta;
    }

    @Override
    public double varianceOfStockPrice(double time) {
        return Math.pow(this.initialValue, 2.0) * Math.exp(2.0 * this.riskFreeRate * time) * (Math.exp(Math.pow(this.volatility, 2.0) * time) - 1.0);
    }

    @Override
    public double getForwardValue(double time) {
        return this.initialValue * Math.exp(this.riskFreeRate * time);
    }

    @Override
    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    @Override
    public double getVolatility() {
        return this.volatility;
    }

    @Override
    public double getLocalVolatility(double assetValue, double time) {
        return this.volatility;
    }

    @Override
    public int getNumTimesteps() {
        return this.numTimesteps;
    }

    @Override
    public int getNumSpacesteps() {
        return this.numSpacesteps;
    }

    @Override
    public double getNumStandardDeviations() {
        return this.numStandardDeviations;
    }

    @Override
    public double[][] getValue(double evaluationnTime, double time, DoubleUnaryOperator values, FiniteDifference1DBoundary boundary) {
        FDMThetaMethod solver = new FDMThetaMethod(this, boundary, time, this.center, this.theta);
        return solver.getValue(evaluationnTime, time, values);
    }
}

