/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.calibration;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import net.finmath.exception.CalculationException;
import net.finmath.fouriermethod.calibration.models.CalibratableProcess;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.fouriermethod.products.smile.EuropeanOptionSmile;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.volatilities.OptionSmileData;
import net.finmath.marketdata.model.volatilities.OptionSurfaceData;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.optimizer.Optimizer;
import net.finmath.optimizer.OptimizerFactory;
import net.finmath.optimizer.SolverException;
import org.apache.commons.lang3.ArrayUtils;

public class CalibratedModel {
    private final OptionSurfaceData surface;
    private final CalibratableProcess model;
    private final OptimizerFactory optimizerFactory;
    private final EuropeanOptionSmile pricer;
    private final double[] initialParameters;
    private final double[] lowerBound;
    private final double[] upperBound;
    private final double[] parameterStep;

    public CalibratedModel(OptionSurfaceData surface, CalibratableProcess model, OptimizerFactory optimizerFactory, EuropeanOptionSmile pricer, double[] initialParameters, double[] parameterStep) {
        this.surface = surface;
        this.model = model;
        this.optimizerFactory = optimizerFactory;
        this.pricer = pricer;
        this.initialParameters = initialParameters;
        this.lowerBound = model.getParameterLowerBounds();
        this.upperBound = model.getParameterUpperBounds();
        this.parameterStep = parameterStep;
    }

    public OptimizationResult getCalibration() throws SolverException {
        Optimizer.ObjectiveFunction objectiveFunction = new Optimizer.ObjectiveFunction(){

            @Override
            public void setValues(double[] parameters, double[] values) {
                CalibratableProcess newModel = CalibratedModel.this.model.getCloneForModifiedParameters(parameters);
                CharacteristicFunctionModel newModelFourier = newModel.getCharacteristicFunctionModel();
                int numberOfMaturities = CalibratedModel.this.surface.getMaturities().length;
                double[] mats = CalibratedModel.this.surface.getMaturities();
                VolatilitySurface.QuotingConvention targetConvention = CalibratedModel.this.surface.getQuotingConvention();
                ArrayList<Double> vals = new ArrayList<Double>();
                for (int t = 0; t < numberOfMaturities; ++t) {
                    double[] currentStrikes = CalibratedModel.this.surface.getSmile(mats[t]).getStrikes();
                    EuropeanOptionSmile newPricer = CalibratedModel.this.pricer.getCloneWithModifiedParameters(mats[t], currentStrikes);
                    try {
                        Map<String, Function<Double, Double>> currentModelPrices = newPricer.getValue(0.0, newModelFourier);
                        for (int i = 0; i < currentStrikes.length; ++i) {
                            double optionValue;
                            double payoffUnit;
                            double optionStrike;
                            double optionMaturity;
                            double forward;
                            if (targetConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL)) {
                                forward = CalibratedModel.this.surface.getEquityForwardCurve().getDiscountFactor(mats[t]);
                                optionMaturity = mats[t];
                                optionStrike = currentStrikes[i];
                                payoffUnit = CalibratedModel.this.surface.getDiscountCurve().getDiscountFactor(mats[t]);
                                optionValue = currentModelPrices.get("valuePerStrike").apply(optionStrike);
                                vals.add(AnalyticFormulas.blackScholesOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, optionValue));
                                continue;
                            }
                            if (targetConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYNORMAL)) {
                                forward = CalibratedModel.this.surface.getEquityForwardCurve().getDiscountFactor(mats[t]);
                                optionMaturity = mats[t];
                                optionStrike = currentStrikes[i];
                                payoffUnit = CalibratedModel.this.surface.getDiscountCurve().getDiscountFactor(mats[t]);
                                optionValue = currentModelPrices.get("valuePerStrike").apply(optionStrike);
                                vals.add(AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, optionValue));
                                continue;
                            }
                            vals.add(currentModelPrices.get("valuePerStrike").apply(currentStrikes[i]));
                        }
                        continue;
                    }
                    catch (CalculationException e) {
                        e.printStackTrace();
                    }
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = (Double)vals.get(i);
                }
            }
        };
        Optimizer optimizer = this.optimizerFactory.getOptimizer(objectiveFunction, this.initialParameters, this.lowerBound, this.upperBound, this.parameterStep, this.formatTargetValuesForOptimizer());
        optimizer.run();
        ArrayList<String> calibrationOutput = this.outputCalibrationResult(optimizer.getBestFitParameters());
        CalibratableProcess calibratedModel = this.model.getCloneForModifiedParameters(optimizer.getBestFitParameters());
        return new OptimizationResult(calibratedModel, optimizer.getBestFitParameters(), optimizer.getIterations(), optimizer.getRootMeanSquaredError(), calibrationOutput);
    }

    private double[] formatTargetValuesForOptimizer() {
        int numberOfMaturities = this.surface.getMaturities().length;
        double[] mats = this.surface.getMaturities();
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int t = 0; t < numberOfMaturities; ++t) {
            double mat = mats[t];
            double[] myStrikes = this.surface.getSurface().get(mat).getStrikes();
            OptionSmileData smileOfInterest = this.surface.getSurface().get(mat);
            for (int k = 0; k < myStrikes.length; ++k) {
                vals.add(smileOfInterest.getSmile().get(myStrikes[k]).getValue());
            }
        }
        Double[] targetVals = new Double[vals.size()];
        return ArrayUtils.toPrimitive((Double[])vals.toArray(targetVals));
    }

    private ArrayList<String> outputCalibrationResult(double[] parameters) {
        ArrayList<String> calibrationOutput = new ArrayList<String>();
        CalibratableProcess newModel = this.model.getCloneForModifiedParameters(parameters);
        CharacteristicFunctionModel newModelFourier = newModel.getCharacteristicFunctionModel();
        int numberOfMaturities = this.surface.getMaturities().length;
        double[] mats = this.surface.getMaturities();
        VolatilitySurface.QuotingConvention targetConvention = this.surface.getQuotingConvention();
        calibrationOutput.add("Strike\tMaturity\tMarket Value\tModel Value\tSquared Error");
        for (int t = 0; t < numberOfMaturities; ++t) {
            double T = mats[t];
            OptionSmileData currentSmile = this.surface.getSmile(mats[t]);
            double[] currentStrikes = currentSmile.getStrikes();
            EuropeanOptionSmile newPricer = this.pricer.getCloneWithModifiedParameters(mats[t], currentStrikes);
            try {
                Map<String, Function<Double, Double>> currentModelPrices = newPricer.getValue(0.0, newModelFourier);
                for (int i = 0; i < currentStrikes.length; ++i) {
                    double value;
                    double optionValue;
                    double payoffUnit;
                    double optionStrike;
                    double optionMaturity;
                    double forward;
                    double K = currentStrikes[i];
                    double targetValue = currentSmile.getOption(currentStrikes[i]).getValue();
                    if (targetConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL)) {
                        forward = this.surface.getEquityForwardCurve().getDiscountFactor(mats[t]);
                        optionMaturity = mats[t];
                        optionStrike = currentStrikes[i];
                        payoffUnit = this.surface.getDiscountCurve().getDiscountFactor(mats[t]);
                        optionValue = currentModelPrices.get("valuePerStrike").apply(optionStrike);
                        value = AnalyticFormulas.blackScholesOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, optionValue);
                    } else if (targetConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYNORMAL)) {
                        forward = this.surface.getEquityForwardCurve().getDiscountFactor(mats[t]);
                        optionMaturity = mats[t];
                        optionStrike = currentStrikes[i];
                        payoffUnit = this.surface.getDiscountCurve().getDiscountFactor(mats[t]);
                        optionValue = currentModelPrices.get("valuePerStrike").apply(optionStrike);
                        value = AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, optionValue);
                    } else {
                        value = currentModelPrices.get("valuePerStrike").apply(currentStrikes[i]);
                    }
                    calibrationOutput.add(K + "\t" + T + "\t" + targetValue + "\t" + value + "\t" + Math.pow(targetValue - value, 2.0));
                }
                continue;
            }
            catch (CalculationException e) {
                e.printStackTrace();
            }
        }
        return calibrationOutput;
    }

    public static class OptimizationResult {
        private final CalibratableProcess model;
        private final double[] bestFitParameters;
        private final int iterations;
        private final double rootMeanSquaredError;
        private final ArrayList<String> calibrationOutput;

        public OptimizationResult(CalibratableProcess model, double[] bestFitParameters, int iterations, double rootMeanSquaredError, ArrayList<String> calibrationOutput) {
            this.model = model;
            this.bestFitParameters = bestFitParameters;
            this.iterations = iterations;
            this.rootMeanSquaredError = rootMeanSquaredError;
            this.calibrationOutput = calibrationOutput;
        }

        public CalibratableProcess getModel() {
            return this.model;
        }

        public double[] getBestFitParameters() {
            return this.bestFitParameters;
        }

        public int getIterations() {
            return this.iterations;
        }

        public double getRootMeanSquaredError() {
            return this.rootMeanSquaredError;
        }

        public ArrayList<String> getCalibrationOutput() {
            return this.calibrationOutput;
        }
    }
}

