/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.calibration.models;

import net.finmath.fouriermethod.calibration.ScalarParameterInformation;
import net.finmath.fouriermethod.calibration.ScalarParameterInformationImplementation;
import net.finmath.fouriermethod.calibration.Unconstrained;
import net.finmath.fouriermethod.calibration.models.CalibratableProcess;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.fouriermethod.models.VarianceGammaModel;
import net.finmath.modelling.ModelDescriptor;
import net.finmath.modelling.descriptor.VarianceGammaModelDescriptor;

public class CalibratableVarianceGammaModel
implements CalibratableProcess {
    private final VarianceGammaModelDescriptor descriptor;
    private final ScalarParameterInformation sigmaInfo;
    private final ScalarParameterInformation thetaInfo;
    private final ScalarParameterInformation nuInfo;
    private final double[] parameterUpperBounds;
    private final double[] parameterLowerBounds;

    public CalibratableVarianceGammaModel(VarianceGammaModelDescriptor descriptor) {
        this.descriptor = descriptor;
        this.sigmaInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.thetaInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.nuInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.parameterUpperBounds = this.extractUpperBounds();
        this.parameterLowerBounds = this.extractLowerBounds();
    }

    public CalibratableVarianceGammaModel(VarianceGammaModelDescriptor descriptor, ScalarParameterInformation sigmaInfo, ScalarParameterInformation thetaInfo, ScalarParameterInformation nuInfo) {
        this.descriptor = descriptor;
        this.sigmaInfo = sigmaInfo;
        this.thetaInfo = thetaInfo;
        this.nuInfo = nuInfo;
        this.parameterUpperBounds = this.extractUpperBounds();
        this.parameterLowerBounds = this.extractLowerBounds();
    }

    @Override
    public CalibratableProcess getCloneForModifiedParameters(double[] parameters) {
        double sigma = this.sigmaInfo.getIsParameterToCalibrate() ? this.sigmaInfo.getConstraint().apply(parameters[0]) : this.descriptor.getSigma();
        double theta = this.thetaInfo.getIsParameterToCalibrate() ? this.thetaInfo.getConstraint().apply(parameters[1]) : this.descriptor.getTheta();
        double nu = this.nuInfo.getIsParameterToCalibrate() ? this.nuInfo.getConstraint().apply(parameters[2]) : this.descriptor.getNu();
        VarianceGammaModelDescriptor newDescriptor = new VarianceGammaModelDescriptor(this.descriptor.getReferenceDate(), this.descriptor.getInitialValue(), this.descriptor.getDiscountCurveForForwardRate(), this.descriptor.getDiscountCurveForDiscountRate(), sigma, theta, nu);
        return new CalibratableVarianceGammaModel(newDescriptor, this.sigmaInfo, this.thetaInfo, this.nuInfo);
    }

    @Override
    public ModelDescriptor getModelDescriptor() {
        return this.descriptor;
    }

    @Override
    public CharacteristicFunctionModel getCharacteristicFunctionModel() {
        return new VarianceGammaModel(null, this.descriptor.getInitialValue(), this.descriptor.getDiscountCurveForForwardRate(), this.descriptor.getDiscountCurveForDiscountRate(), this.descriptor.getSigma(), this.descriptor.getTheta(), this.descriptor.getNu());
    }

    @Override
    public double[] getParameterLowerBounds() {
        return this.parameterLowerBounds;
    }

    @Override
    public double[] getParameterUpperBounds() {
        return this.parameterUpperBounds;
    }

    private double[] extractUpperBounds() {
        double[] upperBounds = new double[3];
        double threshold = 1000000.0;
        upperBounds[0] = this.sigmaInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.sigmaInfo.getConstraint().getUpperBound();
        upperBounds[1] = this.thetaInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.thetaInfo.getConstraint().getUpperBound();
        upperBounds[2] = this.nuInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.nuInfo.getConstraint().getUpperBound();
        return upperBounds;
    }

    private double[] extractLowerBounds() {
        double[] upperBounds = new double[3];
        double threshold = -1000000.0;
        upperBounds[0] = this.sigmaInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.sigmaInfo.getConstraint().getLowerBound();
        upperBounds[1] = this.thetaInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.thetaInfo.getConstraint().getLowerBound();
        upperBounds[2] = this.nuInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.nuInfo.getConstraint().getLowerBound();
        return upperBounds;
    }
}

