/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import java.time.LocalDate;
import net.finmath.fouriermethod.CharacteristicFunction;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import org.apache.commons.math3.complex.Complex;

public class HestonModel
implements CharacteristicFunctionModel {
    private final LocalDate referenceDate;
    private final double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final double riskFreeRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final double discountRate;
    private final double volatility;
    private final double theta;
    private final double kappa;
    private final double xi;
    private final double rho;

    public HestonModel(LocalDate referenceDate, double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double volatility, double theta, double kappa, double xi, double rho) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = Double.NaN;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = Double.NaN;
        this.volatility = volatility;
        this.theta = theta;
        this.kappa = kappa;
        this.xi = xi;
        this.rho = rho;
    }

    public HestonModel(double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double volatility, double theta, double kappa, double xi, double rho) {
        this(null, initialValue, discountCurveForForwardRate, discountCurveForDiscountRate, volatility, theta, kappa, xi, rho);
    }

    public HestonModel(double initialValue, double riskFreeRate, double volatility, double discountRate, double theta, double kappa, double xi, double rho) {
        this.referenceDate = null;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = null;
        this.riskFreeRate = riskFreeRate;
        this.discountCurveForDiscountRate = null;
        this.discountRate = discountRate;
        this.volatility = volatility;
        this.theta = theta;
        this.kappa = kappa;
        this.xi = xi;
        this.rho = rho;
    }

    public HestonModel(double initialValue, double riskFreeRate, double volatility, double theta, double kappa, double xi, double rho) {
        this(initialValue, riskFreeRate, volatility, riskFreeRate, theta, kappa, xi, rho);
    }

    @Override
    public CharacteristicFunction apply(final double time) {
        final double logDiscountFactorForForward = this.getLogDiscountFactorForForward(time);
        final double logDiscountFactorForDiscounting = this.getLogDiscountFactorForDiscounting(time);
        return new CharacteristicFunction(){

            @Override
            public Complex apply(Complex argument) {
                Complex iargument = argument.multiply(Complex.I);
                Complex gamma = iargument.multiply(HestonModel.this.rho * HestonModel.this.xi).subtract(HestonModel.this.kappa).pow(2.0).subtract(iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(0.5).multiply(2.0 * HestonModel.this.xi * HestonModel.this.xi)).sqrt();
                Complex a = iargument.multiply(HestonModel.this.rho * HestonModel.this.xi).subtract(HestonModel.this.kappa).subtract(gamma).multiply(-HestonModel.this.theta * HestonModel.this.kappa * time / (HestonModel.this.xi * HestonModel.this.xi)).subtract(iargument.multiply(HestonModel.this.rho * HestonModel.this.xi).subtract(HestonModel.this.kappa).subtract(gamma).multiply(new Complex(1.0).divide(gamma.multiply(time).exp()).subtract(1.0).divide(gamma)).multiply(0.5).add(new Complex(1.0).divide(gamma.multiply(time).exp())).log().add(gamma.multiply(time)).multiply(2.0 * HestonModel.this.theta * HestonModel.this.kappa / (HestonModel.this.xi * HestonModel.this.xi)));
                Complex b = iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(-1).divide(iargument.multiply(HestonModel.this.rho * HestonModel.this.xi).subtract(HestonModel.this.kappa).add(gamma.multiply(new Complex(1.0).divide(gamma.multiply(time).exp()).add(1.0).divide(new Complex(1.0).divide(gamma.multiply(time).exp()).subtract(1.0)))));
                return a.add(b.multiply(HestonModel.this.volatility * HestonModel.this.volatility)).add(iargument.multiply(Math.log(HestonModel.this.initialValue) - logDiscountFactorForForward)).add(logDiscountFactorForDiscounting).exp();
            }
        };
    }

    private double getLogDiscountFactorForForward(double time) {
        return this.discountCurveForForwardRate == null ? -this.riskFreeRate * time : Math.log(this.discountCurveForForwardRate.getDiscountFactor(null, time));
    }

    private double getLogDiscountFactorForDiscounting(double time) {
        return this.discountCurveForDiscountRate == null ? -this.discountRate * time : Math.log(this.discountCurveForDiscountRate.getDiscountFactor(null, time));
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public double getDiscountRate() {
        return this.discountRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getKappa() {
        return this.kappa;
    }

    public double getXi() {
        return this.xi;
    }

    public double getRho() {
        return this.rho;
    }

    public String toString() {
        return "HestonModel [referenceDate=" + this.referenceDate + ", initialValue=" + this.initialValue + ", discountCurveForForwardRate=" + this.discountCurveForForwardRate + ", riskFreeRate=" + this.riskFreeRate + ", discountCurveForDiscountRate=" + this.discountCurveForDiscountRate + ", discountRate=" + this.discountRate + ", volatility=" + this.volatility + ", theta=" + this.theta + ", kappa=" + this.kappa + ", xi=" + this.xi + ", rho=" + this.rho + "]";
    }
}

