/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import java.time.LocalDate;
import net.finmath.fouriermethod.CharacteristicFunction;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import org.apache.commons.math3.complex.Complex;

public class VarianceGammaModel
implements CharacteristicFunctionModel {
    private final LocalDate referenceDate;
    private final double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final double riskFreeRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final double discountRate;
    private final double sigma;
    private final double theta;
    private final double nu;

    public VarianceGammaModel(LocalDate referenceDate, double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double sigma, double theta, double nu) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = Double.NaN;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = Double.NaN;
        this.sigma = sigma;
        this.theta = theta;
        this.nu = nu;
    }

    public VarianceGammaModel(double initialValue, double riskFreeRate, double discountRate, double sigma, double theta, double nu) {
        this.referenceDate = null;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = null;
        this.riskFreeRate = riskFreeRate;
        this.discountCurveForDiscountRate = null;
        this.discountRate = discountRate;
        this.sigma = sigma;
        this.theta = theta;
        this.nu = nu;
    }

    @Override
    public CharacteristicFunction apply(final double time) {
        final double logDiscountFactorForForward = this.getLogDiscountFactorForForward(time);
        final double logDiscountFactorForDiscounting = this.getLogDiscountFactorForDiscounting(time);
        return new CharacteristicFunction(){

            @Override
            public Complex apply(Complex argument) {
                Complex iargument = argument.multiply(Complex.I);
                Complex denominator = Complex.ONE.subtract(iargument.multiply(VarianceGammaModel.this.theta * VarianceGammaModel.this.nu)).add(argument.multiply(argument).multiply(0.5 * VarianceGammaModel.this.sigma * VarianceGammaModel.this.sigma * VarianceGammaModel.this.nu));
                Complex firstLevyExponent = Complex.ONE.divide(denominator).log().multiply(time / VarianceGammaModel.this.nu);
                Complex compensator = iargument.multiply(time / VarianceGammaModel.this.nu * Math.log(1.0 / (1.0 - VarianceGammaModel.this.theta * VarianceGammaModel.this.nu - 0.5 * VarianceGammaModel.this.sigma * VarianceGammaModel.this.sigma * VarianceGammaModel.this.nu)));
                return firstLevyExponent.subtract(compensator).add(iargument.multiply(Math.log(VarianceGammaModel.this.initialValue) - logDiscountFactorForForward)).add(logDiscountFactorForDiscounting).exp();
            }
        };
    }

    private double getLogDiscountFactorForForward(double time) {
        return this.discountCurveForForwardRate == null ? -this.riskFreeRate * time : Math.log(this.discountCurveForForwardRate.getDiscountFactor(null, time));
    }

    private double getLogDiscountFactorForDiscounting(double time) {
        return this.discountCurveForDiscountRate == null ? -this.discountRate * time : Math.log(this.discountCurveForDiscountRate.getDiscountFactor(null, time));
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public double getDiscountRate() {
        return this.discountRate;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getNu() {
        return this.nu;
    }

    public String toString() {
        return "VarianceGammaModel [referenceDate=" + this.referenceDate + ", initialValue=" + this.initialValue + ", discountCurveForForwardRate=" + this.discountCurveForForwardRate + ", riskFreeRate=" + this.riskFreeRate + ", discountCurveForDiscountRate=" + this.discountCurveForDiscountRate + ", discountRate=" + this.discountRate + ", sigma=" + this.sigma + ", theta=" + this.theta + ", nu=" + this.nu + "]";
    }
}

