/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products;

import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import net.finmath.exception.CalculationException;
import net.finmath.fouriermethod.CharacteristicFunction;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.fouriermethod.products.FourierTransformProduct;
import net.finmath.integration.SimpsonRealIntegrator;
import net.finmath.modelling.Model;
import org.apache.commons.math3.complex.Complex;

public abstract class AbstractFourierTransformProduct
implements CharacteristicFunction,
FourierTransformProduct {
    @Override
    public Double getValue(double evaluationTime, Model model) {
        Double value = null;
        try {
            value = this.getValue((CharacteristicFunctionModel)model);
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return value;
    }

    @Override
    public Map<String, Object> getValues(double evaluationTime, Model model) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            double value = this.getValue((CharacteristicFunctionModel)model);
            result.put("value", value);
        }
        catch (CalculationException e) {
            result.put("exception", e);
        }
        return result;
    }

    @Override
    public double getValue(CharacteristicFunctionModel model) throws CalculationException {
        final CharacteristicFunction modelCF = model.apply(this.getMaturity());
        final double lineOfIntegration = 0.5 * this.getIntegrationDomainImagUpperBound() + this.getIntegrationDomainImagLowerBound();
        DoubleUnaryOperator integrand = new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double real) {
                Complex z = new Complex(real, lineOfIntegration);
                return ((Complex)modelCF.apply(z.negate())).multiply((Complex)AbstractFourierTransformProduct.this.apply(z)).getReal();
            }
        };
        SimpsonRealIntegrator integrator = new SimpsonRealIntegrator(-100.0, 100.0, 20000, true);
        return integrator.integrate(integrand) / 2.0 / Math.PI;
    }

    @Override
    public abstract double getMaturity();

    @Override
    public abstract double getIntegrationDomainImagLowerBound();

    @Override
    public abstract double getIntegrationDomainImagUpperBound();
}

