/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products;

import net.finmath.fouriermethod.products.AbstractFourierTransformProduct;
import org.apache.commons.math3.complex.Complex;

public class EuropeanOption
extends AbstractFourierTransformProduct {
    private final String underlyingName;
    private final double maturity;
    private final double strike;

    public EuropeanOption(String underlyingName, double maturity, double strike) {
        this.underlyingName = underlyingName;
        this.maturity = maturity;
        this.strike = strike;
    }

    public EuropeanOption(double maturity, double strike) {
        this(null, maturity, strike);
    }

    @Override
    public Complex apply(Complex argument) {
        Complex iargument = argument.multiply(Complex.I);
        Complex exponent = iargument.add(1.0);
        Complex numerator = new Complex(this.strike).pow(exponent);
        Complex denominator = argument.multiply(argument).subtract(iargument);
        return numerator.divide(denominator).negate();
    }

    @Override
    public double getMaturity() {
        return this.maturity;
    }

    @Override
    public double getIntegrationDomainImagLowerBound() {
        return 0.5;
    }

    @Override
    public double getIntegrationDomainImagUpperBound() {
        return 2.5;
    }
}

