/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products.smile;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.finmath.exception.CalculationException;
import net.finmath.fouriermethod.CharacteristicFunction;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.fouriermethod.products.smile.EuropeanOptionSmile;
import net.finmath.interpolation.RationalFunctionInterpolation;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class EuropeanOptionSmileByCarrMadan
extends EuropeanOptionSmile {
    private final int numberOfPoints;
    private final double gridSpacing;
    private final RationalFunctionInterpolation.InterpolationMethod intMethod;
    private final RationalFunctionInterpolation.ExtrapolationMethod extMethod;

    public EuropeanOptionSmileByCarrMadan(double maturity, double[] strikes) {
        super(maturity, strikes);
        this.numberOfPoints = 4096;
        this.gridSpacing = 0.1;
        this.intMethod = RationalFunctionInterpolation.InterpolationMethod.HARMONIC_SPLINE;
        this.extMethod = RationalFunctionInterpolation.ExtrapolationMethod.CONSTANT;
    }

    public EuropeanOptionSmileByCarrMadan(String underlyingName, double maturity, double[] strikes) {
        super(underlyingName, maturity, strikes);
        this.numberOfPoints = 4096;
        this.gridSpacing = 0.1;
        this.intMethod = RationalFunctionInterpolation.InterpolationMethod.HARMONIC_SPLINE;
        this.extMethod = RationalFunctionInterpolation.ExtrapolationMethod.CONSTANT;
    }

    public EuropeanOptionSmileByCarrMadan(String underlyingName, double maturity, double[] strikes, int numberOfPoints, double gridSpacing, RationalFunctionInterpolation.InterpolationMethod intMethod, RationalFunctionInterpolation.ExtrapolationMethod extMethod) {
        super(underlyingName, maturity, strikes);
        this.numberOfPoints = numberOfPoints;
        this.gridSpacing = gridSpacing;
        this.intMethod = intMethod;
        this.extMethod = extMethod;
    }

    @Override
    public Map<String, Function<Double, Double>> getValue(double evaluationTime, CharacteristicFunctionModel model) throws CalculationException {
        CharacteristicFunction modelCF = model.apply(this.getMaturity());
        double lineOfIntegration = 0.5 * (this.getIntegrationDomainImagUpperBound() + this.getIntegrationDomainImagLowerBound());
        double lambda = Math.PI * 2 / ((double)this.numberOfPoints * this.gridSpacing);
        double upperBound = (double)this.numberOfPoints * lambda / 2.0;
        Complex[] integrandEvaluations = new Complex[this.numberOfPoints];
        for (int i = 0; i < this.numberOfPoints; ++i) {
            double u = this.gridSpacing * (double)i;
            Complex z = new Complex(u, -lineOfIntegration);
            Complex numerator = (Complex)modelCF.apply(z.subtract(Complex.I));
            Complex denominator = this.apply(z);
            Complex ratio = numerator.divide(denominator);
            ratio = ratio.multiply(Complex.I.multiply(upperBound * u).exp()).multiply(this.gridSpacing);
            double delta = i == 0 ? 1.0 : 0.0;
            double simpsonWeight = (3.0 + Math.pow(-1.0, i + 1) - delta) / 3.0;
            integrandEvaluations[i] = ratio.multiply(simpsonWeight);
        }
        Complex[] transformedVector = new Complex[this.numberOfPoints];
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        transformedVector = fft.transform(integrandEvaluations, TransformType.FORWARD);
        double[] logStrikeVector = new double[this.numberOfPoints];
        double[] strikeVector = new double[this.numberOfPoints];
        double[] optionPriceVector = new double[this.numberOfPoints];
        for (int j = 0; j < this.numberOfPoints; ++j) {
            logStrikeVector[j] = -upperBound + lambda * (double)j;
            strikeVector[j] = Math.exp(logStrikeVector[j]);
            optionPriceVector[j] = transformedVector[j].multiply(Math.exp(-lineOfIntegration * logStrikeVector[j])).getReal() / Math.PI;
        }
        final RationalFunctionInterpolation interpolation = new RationalFunctionInterpolation(strikeVector, optionPriceVector, this.intMethod, this.extMethod);
        Complex minusI = new Complex(0.0, -1.0);
        final double residueTerm = ((Complex)modelCF.apply(minusI)).getReal();
        Function<Double, Double> strikeToPrice = new Function<Double, Double>(){

            @Override
            public Double apply(Double t) {
                return residueTerm + interpolation.getValue(t);
            }
        };
        HashMap<String, Function<Double, Double>> results = new HashMap<String, Function<Double, Double>>();
        results.put("valuePerStrike", strikeToPrice);
        return results;
    }

    @Override
    public EuropeanOptionSmile getCloneWithModifiedParameters(double maturity, double[] strikes) {
        return new EuropeanOptionSmileByCarrMadan(maturity, strikes);
    }
}

